/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.Loggerx;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MD5Util {
    private static Loggerx logger = Loggerx.getLogger("system");
    private static final String[] STR_DIGITS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    private MD5Util() {
    }

    public static String encrypt(String inputText) {
        if (inputText == null || "".equals(inputText.trim())) {
            throw new IllegalArgumentException("\u8bf7\u8f93\u5165\u8981\u52a0\u5bc6\u7684\u5185\u5bb9");
        }
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.update(inputText.getBytes("UTF-8"));
            byte[] s = m.digest();
            return MD5Util.hex(s);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error(LogType.ERROR, "MD5\u52a0\u5bc6\u5f02\u5e38", e);
            throw new RuntimeException("MD5\u52a0\u5bc6\u5f02\u5e38", e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error(LogType.ERROR, "MD5\u52a0\u5bc6\u5f02\u5e38", e);
            throw new RuntimeException("MD5\u52a0\u5bc6\u5f02\u5e38", e);
        }
    }

    private static String hex(byte[] arr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(Integer.toHexString(arr[i] & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public static String encrypt(byte[] data) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(data);
            return MD5Util.byteToString(md5.digest());
        }
        catch (Exception exception) {
            return "";
        }
    }

    private static String byteToString(byte[] bByte) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bByte.length; ++i) {
            sb.append(MD5Util.byteToArrayString(bByte[i]));
        }
        return sb.toString();
    }

    private static String byteToArrayString(byte bByte) {
        int iRet = bByte;
        if (iRet < 0) {
            iRet += 256;
        }
        int iD1 = iRet / 16;
        int iD2 = iRet % 16;
        return STR_DIGITS[iD1] + STR_DIGITS[iD2];
    }
}

