/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.security;

import cpcn.dsp.institution.api.security.SM3Digest;
import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.Loggerx;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class SM3Util {
    protected static final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected static final byte[] decodingTable = new byte[128];
    private static Loggerx logger = Loggerx.getLogger("system");

    public static String encrypt(String str) throws Exception {
        if (str != null && !"".equals(str)) {
            byte[] md = new byte[32];
            byte[] msg1 = str.getBytes("UTF-8");
            SM3Digest sm3 = new SM3Digest();
            sm3.update(msg1, 0, msg1.length);
            sm3.doFinal(md, 0);
            String ret = new String(SM3Util.encode(md));
            return ret;
        }
        return "";
    }

    public static byte[] encode(byte[] data) {
        return SM3Util.encode(data, 0, data.length);
    }

    public static byte[] encode(byte[] data, int off, int length) {
        ByteArrayOutputStream bOut;
        block2: {
            bOut = new ByteArrayOutputStream();
            try {
                SM3Util.encode(data, off, length, bOut);
            }
            catch (Exception e) {
                if (null == logger) break block2;
                logger.error(LogType.ERROR, e.getMessage());
            }
        }
        return bOut.toByteArray();
    }

    public static int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        for (int i = off; i < off + length; ++i) {
            int v = data[i] & 0xFF;
            out.write(encodingTable[v >>> 4]);
            out.write(encodingTable[v & 0xF]);
        }
        return length * 2;
    }
}

