/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.system;

import cfca.sadk.x509.certificate.X509Cert;
import cpcn.dsp.institution.api.net.SecurityContext;
import cpcn.dsp.institution.api.security.CertificateVerifier;
import cpcn.dsp.institution.api.security.PfxSigner;
import cpcn.dsp.institution.api.security.SMSigner;
import cpcn.dsp.institution.api.security.SMVerifier;
import cpcn.dsp.institution.api.security.SecurityUtil;
import cpcn.dsp.institution.api.security.SignatureFactory;
import cpcn.dsp.institution.api.security.Signer;
import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.Loggerx;
import cpcn.dsp.institution.api.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class DSPInstitutionEnvironment {
    private static Loggerx logger = Loggerx.getLogger("system");
    public static String asyncURL;
    public static String livenessURL;
    public static String txURL;
    public static String fileURL;
    public static String orgveriURL;
    public static final int PERSONAL_ACCOUNT = 11;
    public static final int BUSINESS_ACCOUNT = 12;
    public static final int PAYMENT_ACCOUNT = 20;
    public static final String SUCCESS_CODE = "2000";
    public static boolean useHttpClient;
    public static boolean useDefaultSSLSocketFactory;
    public static boolean ignoreHostname;
    public static boolean useHttpProxy;
    public static String proxyHostname;
    public static int proxyPort;
    public static String proxyUserName;
    public static String proxyPassword;
    public static String debugMode;
    public static int connectionTimeout;
    public static int readTimeout;
    public static Set<String> ENVIRONMENT;
    public static Properties properties;
    public static String paymentConfigPath;
    public static final String SYS_CONFIG_FILE = "dsp.ini";
    public static Map<String, String> INDUSTRY_DIC;
    public static List<String> INDUSTRY_LIST;
    public static final String SYS_INDUSTRY_DIC_FILE = "industryCategory.dic";
    public static String msgEncryptType;
    public static String signSN;
    public static String encryptSN;
    public static String zjPublicSftpUserName;
    public static String zjPublicSftpPassword;
    public static String zjPublicSftpHost;
    public static String zjPublicSftpPort;
    public static String publicSftpOrgFilePath;
    public static String localOrgFilePath;

    private DSPInstitutionEnvironment() {
    }

    public static void initialize(String dspConfigPath) throws Exception {
        DSPInstitutionEnvironment.head();
        try {
            paymentConfigPath = dspConfigPath;
            String sysConfigFile = paymentConfigPath + File.separatorChar + SYS_CONFIG_FILE;
            logger.info(LogType.INFO, sysConfigFile);
            properties.load(new FileInputStream(sysConfigFile));
            Enumeration<?> enu = properties.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                logger.info(LogType.INFO, "key=" + key + ";value=" + properties.get(key));
            }
            DSPInstitutionEnvironment.initURLProperties();
            DSPInstitutionEnvironment.initCertificates();
            DSPInstitutionEnvironment.initIndustry(dspConfigPath);
            DSPInstitutionEnvironment.initFileServer();
        }
        catch (Exception e) {
            logger.error(LogType.ERROR, e.getMessage(), e);
            throw e;
        }
    }

    public static void initURLProperties() throws Exception {
        String txURL = properties.getProperty("tx.url");
        String livenessURL = properties.getProperty("liveness.url");
        String asyncURL = properties.getProperty("async.url");
        String fileURL = properties.getProperty("file.url");
        String orgveriURL = properties.getProperty("orgveri.url");
        String connectionTimeout = properties.getProperty("connectionTimeouts");
        String readTimeout = properties.getProperty("readTimeout");
        boolean flag = false;
        if (null == txURL) {
            logger.info(LogType.INFO, "Missing the property: tx.url");
        } else if (txURL.startsWith("http://")) {
            logger.info(LogType.INFO, "Property tx.url should starts with https://");
        } else {
            flag = true;
        }
        DSPInstitutionEnvironment.txURL = txURL;
        if (null == livenessURL) {
            logger.info(LogType.INFO, "Missing the property: liveness.url");
        } else if (livenessURL.startsWith("http://")) {
            logger.info(LogType.INFO, "Property liveness.url should starts with https://");
        } else {
            flag = true;
        }
        DSPInstitutionEnvironment.livenessURL = livenessURL;
        if (null == asyncURL) {
            logger.info(LogType.INFO, "Missing the property: async.url");
        } else if (asyncURL.startsWith("http://")) {
            logger.info(LogType.INFO, "Property async.url should starts with https://");
        } else {
            flag = true;
        }
        DSPInstitutionEnvironment.asyncURL = asyncURL;
        if (null == fileURL) {
            logger.info(LogType.INFO, "Missing the property: file.url");
        } else if (fileURL.startsWith("http://")) {
            logger.info(LogType.INFO, "Property file.url should starts with https://");
        } else {
            flag = true;
        }
        DSPInstitutionEnvironment.fileURL = fileURL;
        if (orgveriURL == null) {
            logger.info(LogType.INFO, "Missing the property: orgveri.url");
        } else if (orgveriURL.startsWith("https://")) {
            DSPInstitutionEnvironment.initSSLProperties();
        } else {
            logger.info(LogType.INFO, "Property orgveri.url should starts with https://");
        }
        if (StringUtil.isNotEmpty(connectionTimeout)) {
            DSPInstitutionEnvironment.connectionTimeout = Integer.parseInt(connectionTimeout);
        }
        if (StringUtil.isNotEmpty(readTimeout)) {
            DSPInstitutionEnvironment.readTimeout = Integer.parseInt(readTimeout);
        }
        DSPInstitutionEnvironment.orgveriURL = orgveriURL;
        if (flag) {
            DSPInstitutionEnvironment.initSSLProperties();
        }
        DSPInstitutionEnvironment.initMsgEncryptType();
    }

    private static void initMsgEncryptType() throws Exception {
        String type = properties.getProperty("msgEncryptType");
        if (type == null) {
            throw new Exception("Missing the property: msgEncryptType");
        }
        msgEncryptType = new String(type);
    }

    public static void initSSLProperties() throws Exception {
        String useDefaultSSLSocketFactoryTmp = properties.getProperty("useDefaultSSLSocketFactory");
        String useHttpClientTmp = properties.getProperty("useHttpClient");
        String ignoreHostnameTmp = properties.getProperty("ignoreHostname");
        if ("yes".equalsIgnoreCase(useHttpClientTmp)) {
            useHttpClient = true;
            String useHttpPorxy = properties.getProperty("useHttpProxy");
            if ("yes".equalsIgnoreCase(useHttpPorxy)) {
                useHttpProxy = true;
                DSPInstitutionEnvironment.initHttpProxy();
            } else {
                useHttpProxy = false;
            }
        } else {
            useHttpClient = false;
        }
        ignoreHostname = "yes".equalsIgnoreCase(ignoreHostnameTmp);
        if ("yes".equalsIgnoreCase(useDefaultSSLSocketFactoryTmp)) {
            useDefaultSSLSocketFactory = true;
        } else {
            useDefaultSSLSocketFactory = false;
            DSPInstitutionEnvironment.initSecurityContext();
        }
    }

    private static void initSecurityContext() throws Exception {
        String trustKeystoreFilename = properties.getProperty("trust.keystore.filename");
        if (trustKeystoreFilename == null) {
            throw new Exception("Missing the property: trust.keystore.filename");
        }
        String trustKeystoreFilePath = paymentConfigPath + File.separatorChar + trustKeystoreFilename;
        logger.info(LogType.INFO, trustKeystoreFilePath);
        String trustKeystorePassword = properties.getProperty("trust.keystore.password");
        if (trustKeystorePassword == null) {
            throw new Exception("Missing the property: trust.keystore.password");
        }
        SecurityContext.initSSLSocketFactory(trustKeystoreFilePath, trustKeystorePassword);
    }

    private static void initCertificates() throws Exception {
        Signer signer;
        String myKeystoreFilename = properties.getProperty("my.keystore.filename");
        String myKeystorePassword = properties.getProperty("my.keystore.password");
        String algorithm = properties.getProperty("signatureAlgorithm");
        if (StringUtil.isNotEmpty(algorithm)) {
            if ((algorithm = SecurityUtil.convertSignatureAlgorithm(algorithm)) == null) {
                throw new Exception("\u7b7e\u540d\u7b97\u6cd5\u4e0d\u5408\u6cd5");
            }
        } else {
            algorithm = "SHA1withRSA";
        }
        logger.info(LogType.INFO, algorithm);
        if (myKeystoreFilename == null) {
            throw new Exception("Missing the property: my.keystore.filename");
        }
        String myKeystoreFilepath = paymentConfigPath + File.separatorChar + myKeystoreFilename;
        logger.info(LogType.INFO, myKeystoreFilepath);
        if (!"30".equals(msgEncryptType)) {
            signer = new PfxSigner(myKeystoreFilepath, myKeystorePassword, algorithm);
            signSN = signer.getSN();
            SignatureFactory.addSigner(signSN, signer);
        } else {
            signer = new SMSigner(myKeystoreFilepath, myKeystorePassword);
            signSN = signer.getSN();
            SignatureFactory.addSigner(signSN, signer);
        }
        String certificateFilename = properties.getProperty("payment.certificate.filename");
        if (certificateFilename == null) {
            throw new Exception("Missing the property: payment.certificate.filename");
        }
        String certificateFilepath = paymentConfigPath + File.separatorChar + properties.getProperty("payment.certificate.filename");
        logger.info(LogType.INFO, certificateFilepath);
        if ("30".equals(msgEncryptType)) {
            X509Cert x509Cert = new X509Cert(certificateFilepath);
            SMVerifier verifier = new SMVerifier(x509Cert);
            logger.info(LogType.INFO, verifier);
            encryptSN = verifier.getSN();
            SignatureFactory.addVerifier(encryptSN, verifier);
        } else {
            CertificateVerifier verifier = new CertificateVerifier(certificateFilepath, algorithm);
            logger.info(LogType.INFO, verifier);
            encryptSN = verifier.getSN();
            SignatureFactory.addVerifier(encryptSN, verifier);
        }
    }

    private static void initHttpProxy() throws Exception {
        proxyHostname = properties.getProperty("proxy.hostname");
        if (proxyHostname == null) {
            throw new Exception("Missing the property: proxy.hostname");
        }
        String proxyPortTmp = properties.getProperty("proxy.port");
        if (proxyPortTmp == null) {
            throw new Exception("Missing the property: proxy.port");
        }
        proxyPort = Integer.parseInt(proxyPortTmp);
        proxyUserName = properties.getProperty("proxy.username");
        proxyPassword = properties.getProperty("proxy.password");
    }

    public static void initIndustry(String dspConfigPath) throws IOException {
        String sysConfigFile = dspConfigPath + File.separatorChar + SYS_INDUSTRY_DIC_FILE;
        Properties properties = new Properties();
        properties.load(new FileInputStream(sysConfigFile));
        INDUSTRY_DIC.clear();
        INDUSTRY_LIST.clear();
        ArrayList<String> tempList = new ArrayList<String>();
        Enumeration<?> enu = properties.propertyNames();
        while (enu.hasMoreElements()) {
            String code = (String)enu.nextElement();
            String name = (String)properties.get(code);
            code = new String(code.getBytes("ISO8859-1"), "UTF-8");
            name = new String(name.getBytes("ISO8859-1"), "UTF-8");
            INDUSTRY_DIC.put(code, name);
            tempList.add(code);
        }
        Collections.sort(tempList);
        INDUSTRY_LIST = tempList;
    }

    private static void initFileServer() throws Exception {
        zjPublicSftpUserName = properties.getProperty("zjPublicSftpUserName");
        zjPublicSftpPassword = properties.getProperty("zjPublicSftpPassword");
        zjPublicSftpHost = properties.getProperty("zjPublicSftpHost");
        zjPublicSftpPort = properties.getProperty("zjPublicSftpPort");
        publicSftpOrgFilePath = properties.getProperty("publicSftpOrgFilePath");
        localOrgFilePath = properties.getProperty("localOrgFilePath");
        zjPublicSftpUserName = new String(DSPInstitutionEnvironment.gateDecryptionValue(zjPublicSftpUserName).getBytes(), "UTF-8");
        zjPublicSftpPassword = new String(DSPInstitutionEnvironment.gateDecryptionValue(zjPublicSftpPassword).getBytes(), "UTF-8");
    }

    private static void head() {
        logger.info(LogType.INFO, "==========================================");
        logger.info(LogType.INFO, "China Payment & Clearing Network Co., Ltd.");
        logger.info(LogType.INFO, "Data Service Platform V1.0");
        logger.info(LogType.INFO, "DSPInstitution Simulator v1.4.7.00-SNAPSHOT");
        logger.info(LogType.INFO, "==========================================");
    }

    public static String gateDecryptionValue(String encryptValue) {
        return SecurityUtil.des3CBCDecrypt(encryptValue);
    }

    public static void initialize(String myKeystoreFilepath, String myKeystorePassword, String certificateFilepath, String msgEncryptType) throws Exception {
        Signer signer;
        DSPInstitutionEnvironment.msgEncryptType = msgEncryptType;
        if (!"30".equals(msgEncryptType)) {
            signer = new PfxSigner(myKeystoreFilepath, myKeystorePassword, "SHA1withRSA");
            signSN = signer.getSN();
            SignatureFactory.addSigner(signSN, signer);
        } else {
            signer = new SMSigner(myKeystoreFilepath, myKeystorePassword);
            signSN = signer.getSN();
            SignatureFactory.addSigner(signSN, signer);
        }
        if ("30".equals(msgEncryptType)) {
            X509Cert x509Cert = new X509Cert(certificateFilepath);
            SMVerifier verifier = new SMVerifier(x509Cert);
            logger.info(LogType.INFO, verifier);
            encryptSN = verifier.getSN();
            SignatureFactory.addVerifier(encryptSN, verifier);
        } else {
            CertificateVerifier verifier = new CertificateVerifier(certificateFilepath, "SHA1withRSA");
            logger.info(LogType.INFO, verifier);
            encryptSN = verifier.getSN();
            SignatureFactory.addVerifier(encryptSN, verifier);
        }
    }

    static {
        useDefaultSSLSocketFactory = true;
        connectionTimeout = 60000;
        readTimeout = 60000;
        ENVIRONMENT = new HashSet<String>();
        ENVIRONMENT.add("DSP");
        properties = new Properties();
        INDUSTRY_DIC = new HashMap<String, String>();
        INDUSTRY_LIST = new ArrayList<String>();
    }
}

