/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.system;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import cpcn.dsp.institution.api.net.DefaultHttpsConnection;
import cpcn.dsp.institution.api.net.HttpConnection;
import cpcn.dsp.institution.api.net.HttpsConnection;
import cpcn.dsp.institution.api.net.HttpsConnectionByHttpClient;
import cpcn.dsp.institution.api.net.NameValuePair;
import cpcn.dsp.institution.api.system.CodeException;
import cpcn.dsp.institution.api.system.DSPInstitutionEnvironment;
import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.Loggerx;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TxMessenger {
    private Loggerx logger = Loggerx.getLogger("system");

    public String[] send(String requestMessage, String requestSignature, String encryptSN) throws Exception {
        return this.send(requestMessage, requestSignature, encryptSN, DSPInstitutionEnvironment.txURL);
    }

    public String[] send(String requestMessage, String requestSignature, String requestEncryptSN, String sendUrl) throws Exception {
        String responseText;
        String[] response = new String[2];
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        NameValuePair message = new NameValuePair("message", requestMessage);
        NameValuePair signature = new NameValuePair("signature", requestSignature);
        NameValuePair encryptSN = new NameValuePair("encryptSN", requestEncryptSN);
        list.add(message);
        list.add(signature);
        list.add(encryptSN);
        if (sendUrl.startsWith("https")) {
            HttpsConnection httpsConnection;
            if (DSPInstitutionEnvironment.useHttpClient) {
                if (DSPInstitutionEnvironment.useHttpProxy) {
                    httpsConnection = new HttpsConnectionByHttpClient(sendUrl, DSPInstitutionEnvironment.proxyHostname, DSPInstitutionEnvironment.proxyPort, DSPInstitutionEnvironment.proxyUserName, DSPInstitutionEnvironment.proxyPassword);
                    httpsConnection.setUseHttpProxy(true);
                } else {
                    httpsConnection = new HttpsConnectionByHttpClient(sendUrl);
                }
            } else {
                httpsConnection = new DefaultHttpsConnection(sendUrl);
            }
            if (DSPInstitutionEnvironment.useDefaultSSLSocketFactory) {
                httpsConnection.setUseDefaultSSLSocketFactory(true);
            } else {
                httpsConnection.setUseDefaultSSLSocketFactory(false);
            }
            if (DSPInstitutionEnvironment.ignoreHostname) {
                httpsConnection.setIgnoreHostname(true);
            } else {
                httpsConnection.setIgnoreHostname(false);
            }
            if (DSPInstitutionEnvironment.connectionTimeout > 0) {
                httpsConnection.setConnectionTimeout(DSPInstitutionEnvironment.connectionTimeout);
            }
            if (DSPInstitutionEnvironment.readTimeout > 0) {
                httpsConnection.setReadTimeout(DSPInstitutionEnvironment.readTimeout);
            }
            responseText = httpsConnection.send(list);
        } else {
            HttpConnection httpConnection = new HttpConnection(sendUrl);
            if (DSPInstitutionEnvironment.connectionTimeout > 0) {
                httpConnection.setConnectTimeoutLimit(DSPInstitutionEnvironment.connectionTimeout);
            }
            if (DSPInstitutionEnvironment.readTimeout > 0) {
                httpConnection.setReadTimeoutLimit(DSPInstitutionEnvironment.readTimeout);
            }
            try {
                responseText = httpConnection.send(list);
            }
            catch (Exception e) {
                String errorCode = "280001";
                String errorMessage = "\u901a\u8baf\u5f02\u5e38\u3002 ";
                this.logger.error(LogType.ERROR, errorMessage, e);
                throw new CodeException(errorCode, errorMessage);
            }
        }
        int index = responseText.indexOf(44);
        if (index <= 0) {
            this.logger.info(LogType.INFO, responseText);
            String errorMessage = "\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u6b63\u786e\u683c\u5f0f\uff1amessage,signature";
            throw new Exception(errorMessage);
        }
        response[0] = responseText.substring(0, index);
        response[1] = responseText.substring(index + 1, responseText.length());
        return response;
    }

    public String[] send(String requestMessage, String requestSignature, String requestDgtlEnvlp, String requestSignSN, String requestEncryptSN, String institutionID) throws Exception {
        return this.send(requestMessage, requestSignature, DSPInstitutionEnvironment.txURL, requestDgtlEnvlp, requestSignSN, requestEncryptSN, institutionID);
    }

    public String[] send(String requestMessage, String requestSignature, String sendUrl, String requestDgtlEnvlp, String requestSignSN, String requestEncryptSN, String requestInstitutionID) throws Exception {
        String[] respText;
        String responseText;
        String[] response = new String[5];
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        NameValuePair message = new NameValuePair("message", requestMessage);
        NameValuePair signature = new NameValuePair("signature", requestSignature);
        NameValuePair dgtlEnvlp = new NameValuePair("dgtlenvlp", requestDgtlEnvlp);
        NameValuePair signSN = new NameValuePair("signSN", requestSignSN);
        NameValuePair encryptSN = new NameValuePair("encryptSN", requestEncryptSN);
        NameValuePair institutionID = new NameValuePair("institutionID", requestInstitutionID);
        list.add(message);
        list.add(signature);
        list.add(dgtlEnvlp);
        list.add(signSN);
        list.add(encryptSN);
        list.add(institutionID);
        if (sendUrl.startsWith("https")) {
            HttpsConnection httpsConnection;
            if (DSPInstitutionEnvironment.useHttpClient) {
                if (DSPInstitutionEnvironment.useHttpProxy) {
                    httpsConnection = new HttpsConnectionByHttpClient(sendUrl, DSPInstitutionEnvironment.proxyHostname, DSPInstitutionEnvironment.proxyPort, DSPInstitutionEnvironment.proxyUserName, DSPInstitutionEnvironment.proxyPassword);
                    httpsConnection.setUseHttpProxy(true);
                } else {
                    httpsConnection = new HttpsConnectionByHttpClient(sendUrl);
                }
            } else {
                httpsConnection = new DefaultHttpsConnection(sendUrl);
            }
            if (DSPInstitutionEnvironment.useDefaultSSLSocketFactory) {
                httpsConnection.setUseDefaultSSLSocketFactory(true);
            } else {
                httpsConnection.setUseDefaultSSLSocketFactory(false);
            }
            if (DSPInstitutionEnvironment.ignoreHostname) {
                httpsConnection.setIgnoreHostname(true);
            } else {
                httpsConnection.setIgnoreHostname(false);
            }
            if (DSPInstitutionEnvironment.connectionTimeout > 0) {
                httpsConnection.setConnectionTimeout(DSPInstitutionEnvironment.connectionTimeout);
            }
            if (DSPInstitutionEnvironment.readTimeout > 0) {
                httpsConnection.setReadTimeout(DSPInstitutionEnvironment.readTimeout);
            }
            responseText = httpsConnection.send(list);
        } else {
            HttpConnection httpConnection = new HttpConnection(sendUrl);
            if (DSPInstitutionEnvironment.connectionTimeout > 0) {
                httpConnection.setConnectTimeoutLimit(DSPInstitutionEnvironment.connectionTimeout);
            }
            if (DSPInstitutionEnvironment.readTimeout > 0) {
                httpConnection.setReadTimeoutLimit(DSPInstitutionEnvironment.readTimeout);
            }
            try {
                responseText = httpConnection.send(list);
            }
            catch (Exception e) {
                String errorCode = "280001";
                String errorMessage = "\u901a\u8baf\u5f02\u5e38\u3002 ";
                this.logger.error(LogType.ERROR, errorMessage, e);
                throw new CodeException(errorCode, errorMessage);
            }
        }
        if (responseText.contains(",")) {
            respText = responseText.split(",");
            if (respText.length <= 0) {
                this.logger.info(LogType.INFO, responseText);
                String errorMessage = "\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u6b63\u786e\u683c\u5f0f\uff1amessage,signature,dgtlEnvlp,signSN,encryptSN";
                throw new Exception(errorMessage);
            }
        } else {
            respText = new String[]{responseText};
            return respText;
        }
        response[0] = respText[0];
        response[1] = respText[1];
        response[2] = respText[2];
        response[3] = respText[3];
        response[4] = respText[4];
        return response;
    }

    public String[] send(String requestMessage, String requestSignature, int connectTimeoutLimit, int readTimeoutLimit) throws Exception {
        return this.send(requestMessage, requestSignature, connectTimeoutLimit, readTimeoutLimit, DSPInstitutionEnvironment.txURL);
    }

    public String[] send(String requestMessage, String requestSignature, int connectTimeoutLimit, int readTimeoutLimit, String sendUrl) throws Exception {
        String responseText;
        String[] response = new String[2];
        ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
        NameValuePair message = new NameValuePair("message", requestMessage);
        NameValuePair signature = new NameValuePair("signature", requestSignature);
        list.add(message);
        list.add(signature);
        if (sendUrl.startsWith("https")) {
            HttpsConnection httpsConnection;
            if (DSPInstitutionEnvironment.useHttpClient) {
                if (DSPInstitutionEnvironment.useHttpProxy) {
                    httpsConnection = new HttpsConnectionByHttpClient(sendUrl, DSPInstitutionEnvironment.proxyHostname, DSPInstitutionEnvironment.proxyPort, DSPInstitutionEnvironment.proxyUserName, DSPInstitutionEnvironment.proxyPassword);
                    httpsConnection.setUseHttpProxy(true);
                } else {
                    httpsConnection = new HttpsConnectionByHttpClient(sendUrl);
                }
            } else {
                httpsConnection = new DefaultHttpsConnection(sendUrl);
                ((DefaultHttpsConnection)httpsConnection).setConnectTimeoutLimit(connectTimeoutLimit);
                ((DefaultHttpsConnection)httpsConnection).setReadTimeoutLimit(readTimeoutLimit);
            }
            if (DSPInstitutionEnvironment.useDefaultSSLSocketFactory) {
                httpsConnection.setUseDefaultSSLSocketFactory(true);
            } else {
                httpsConnection.setUseDefaultSSLSocketFactory(false);
            }
            if (DSPInstitutionEnvironment.ignoreHostname) {
                httpsConnection.setIgnoreHostname(true);
            } else {
                httpsConnection.setIgnoreHostname(false);
            }
            if (DSPInstitutionEnvironment.connectionTimeout > 0) {
                httpsConnection.setConnectionTimeout(DSPInstitutionEnvironment.connectionTimeout);
            }
            if (DSPInstitutionEnvironment.readTimeout > 0) {
                httpsConnection.setReadTimeout(DSPInstitutionEnvironment.readTimeout);
            }
            responseText = httpsConnection.send(list);
        } else {
            HttpConnection httpConnection = new HttpConnection(sendUrl);
            if (DSPInstitutionEnvironment.connectionTimeout > 0) {
                httpConnection.setConnectTimeoutLimit(DSPInstitutionEnvironment.connectionTimeout);
            }
            if (DSPInstitutionEnvironment.readTimeout > 0) {
                httpConnection.setReadTimeoutLimit(DSPInstitutionEnvironment.readTimeout);
            }
            httpConnection.setConnectTimeoutLimit(connectTimeoutLimit);
            httpConnection.setReadTimeoutLimit(readTimeoutLimit);
            try {
                responseText = httpConnection.send(list);
            }
            catch (Exception e) {
                String errorCode = "280001";
                String errorMessage = "\u901a\u8baf\u5f02\u5e38\u3002  ";
                this.logger.error(LogType.ERROR, errorMessage, e);
                throw new CodeException(errorCode, errorMessage);
            }
        }
        int index = responseText.indexOf(44);
        if (index <= 0) {
            this.logger.info(LogType.INFO, responseText);
            String errorMessage = "\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002 \u6b63\u786e\u683c\u5f0f\uff1amessage,signature";
            throw new Exception(errorMessage);
        }
        response[0] = responseText.substring(0, index);
        response[1] = responseText.substring(index + 1, responseText.length());
        return response;
    }

    public String[] sendWithAttachment(String requestMessage, String requestSignature, String sendUrl, String requestDgtlEnvlp, String requestSignSN, String requestEncryptSN, String requestFiles, String requestInstitutionID) throws Exception {
        String[] respText;
        String responseText;
        String[] response = new String[5];
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("message", requestMessage);
        paramMap.put("signature", requestSignature);
        paramMap.put("dgtlenvlp", requestDgtlEnvlp);
        paramMap.put("signSN", requestSignSN);
        paramMap.put("encryptSN", requestEncryptSN);
        paramMap.put("institutionID", requestInstitutionID);
        Map<String, String> fileMap = this.getFilesMap(requestFiles);
        if (sendUrl.startsWith("https")) {
            HttpsConnection httpsConnection;
            if (DSPInstitutionEnvironment.useHttpClient) {
                if (DSPInstitutionEnvironment.useHttpProxy) {
                    httpsConnection = new HttpsConnectionByHttpClient(sendUrl, DSPInstitutionEnvironment.proxyHostname, DSPInstitutionEnvironment.proxyPort, DSPInstitutionEnvironment.proxyUserName, DSPInstitutionEnvironment.proxyPassword);
                    httpsConnection.setUseHttpProxy(true);
                } else {
                    httpsConnection = new HttpsConnectionByHttpClient(sendUrl);
                }
            } else {
                httpsConnection = new DefaultHttpsConnection(sendUrl);
            }
            if (DSPInstitutionEnvironment.useDefaultSSLSocketFactory) {
                httpsConnection.setUseDefaultSSLSocketFactory(true);
            } else {
                httpsConnection.setUseDefaultSSLSocketFactory(false);
            }
            if (DSPInstitutionEnvironment.ignoreHostname) {
                httpsConnection.setIgnoreHostname(true);
            } else {
                httpsConnection.setIgnoreHostname(false);
            }
            if (DSPInstitutionEnvironment.connectionTimeout > 0) {
                httpsConnection.setConnectionTimeout(DSPInstitutionEnvironment.connectionTimeout);
            }
            if (DSPInstitutionEnvironment.readTimeout > 0) {
                httpsConnection.setReadTimeout(DSPInstitutionEnvironment.readTimeout);
            }
            responseText = httpsConnection.sendWithAttachment(paramMap, fileMap);
        } else {
            HttpConnection httpConnection = new HttpConnection(sendUrl);
            if (DSPInstitutionEnvironment.connectionTimeout > 0) {
                httpConnection.setConnectTimeoutLimit(DSPInstitutionEnvironment.connectionTimeout);
            }
            if (DSPInstitutionEnvironment.readTimeout > 0) {
                httpConnection.setReadTimeoutLimit(DSPInstitutionEnvironment.readTimeout);
            }
            try {
                responseText = httpConnection.sendWithAttachment(paramMap, fileMap);
            }
            catch (Exception e) {
                String errorCode = "280001";
                String errorMessage = "\u901a\u8baf\u5f02\u5e38\u3002 ";
                this.logger.error(LogType.ERROR, errorMessage, e);
                throw new CodeException(errorCode, errorMessage);
            }
        }
        if (responseText.contains(",")) {
            respText = responseText.split(",");
            if (respText.length <= 0) {
                this.logger.info(LogType.INFO, responseText);
                String errorMessage = "\u54cd\u5e94\u6570\u636e\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u6b63\u786e\u683c\u5f0f\uff1amessage,signature,dgtlEnvlp,signSN,encryptSN";
                throw new Exception(errorMessage);
            }
        } else {
            respText = new String[]{responseText};
            return respText;
        }
        response[0] = respText[0];
        response[1] = respText[1];
        response[2] = respText[2];
        response[3] = respText[3];
        response[4] = respText[4];
        return response;
    }

    private Map<String, String> getFilesMap(String files) {
        HashMap<String, String> filesMap = new HashMap<String, String>();
        List jsonArray = JSONArray.parseArray((String)files, JSONObject.class);
        String key = null;
        String value = null;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            Set entries = jsonObject.entrySet();
            for (Map.Entry entry : entries) {
                if ("FileName".equalsIgnoreCase((String)entry.getKey())) {
                    key = (String)entry.getValue();
                    continue;
                }
                if (!"FileContent".equalsIgnoreCase((String)entry.getKey())) continue;
                value = (String)entry.getValue();
            }
            filesMap.put(key, value);
        }
        return filesMap;
    }
}

