/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.util;

import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.Loggerx;
import cpcn.dsp.institution.api.util.StringUtil;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;

public final class EnumUtil {
    private static Loggerx logger = Loggerx.getLogger("system");

    private EnumUtil() {
    }

    public static <T extends Enum<T>> T getEnumType(Class<T> enumType, int val) {
        try {
            String methodName = "get" + enumType.getSimpleName();
            Method method = enumType.getDeclaredMethod(methodName, Integer.TYPE);
            return (T)((Enum)method.invoke((Object)val, val));
        }
        catch (Exception e) {
            logger.error(LogType.ERROR, e.getMessage(), e);
            return null;
        }
    }

    public static <T extends Enum<T>> T getEnumType(Class<T> enumType, String val) {
        try {
            return EnumUtil.getEnumType(enumType, Integer.valueOf(val));
        }
        catch (Exception e) {
            logger.error(LogType.ERROR, e.getMessage(), e);
            return null;
        }
    }

    public static Map<String, String> getEnumElementMap(String enumName) throws Exception {
        ?[] enumConstants;
        Class<?> enumClass = Class.forName(enumName);
        Method valueMethod = enumClass.getDeclaredMethod("getValue", new Class[0]);
        Method nameMethod = enumClass.getDeclaredMethod("getName", new Class[0]);
        LinkedHashMap<String, String> enumMap = new LinkedHashMap<String, String>();
        for (Object enumConstant : enumConstants = enumClass.getEnumConstants()) {
            Object value = valueMethod.invoke(enumConstant, new Object[0]);
            Object name = nameMethod.invoke(enumConstant, new Object[0]);
            if (value == null || name == null) continue;
            enumMap.put(value.toString(), name.toString());
        }
        return enumMap;
    }

    public static boolean isNotEmpty(int val) {
        return val != -1;
    }

    public static boolean isNotEmpty(String str) {
        return StringUtil.isNotEmpty(str) && !"-1".equals(str);
    }
}

