/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.util;

import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.Loggerx;
import cpcn.dsp.institution.api.vo.LogContextVO;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;

public final class LogContextHolder {
    private static final ThreadLocal<LogContextVO> LOG_CONTEXT = new ThreadLocal();
    private String hostIP = this.getIP();
    private String port = "";
    private static LogContextHolder context = new LogContextHolder();
    private static final Loggerx LOGGER = Loggerx.getLogger("system");

    private LogContextHolder() {
    }

    public static LogContextHolder getInstance() {
        return context;
    }

    public void setLogContext(LogContextVO contextParam) {
        contextParam.setLocalIP(this.getLocalIP());
        LOG_CONTEXT.set(contextParam);
    }

    public LogContextVO getLogContext() {
        LogContextVO contextVO = LOG_CONTEXT.get();
        if (contextVO == null) {
            contextVO = new LogContextVO();
            contextVO.setLocalIP(this.getLocalIP());
            LOG_CONTEXT.set(contextVO);
        }
        return contextVO;
    }

    public void removeLogContext() {
        LOG_CONTEXT.remove();
    }

    public String getTraceID() {
        return this.getLogContext().getTraceID();
    }

    public void setTraceID(String id) {
        this.getLogContext().setTraceID(id);
    }

    public String getCurrentTransferID() {
        return this.getLogContext().getCurrentTransferID();
    }

    public void setCurrentTransferID(String currentTransferID) {
        this.getLogContext().setCurrentTransferID(currentTransferID);
    }

    public int getNextTransferID() {
        return this.getLogContext().getNextTransferID();
    }

    public void setNextTransferID(int id) {
        this.getLogContext().setNextTransferID(id);
    }

    public String getTransferID() {
        return this.getLogContext().getTransferID();
    }

    public long getTimeMillis() {
        return this.getLogContext().getTimeMillis();
    }

    public void setTimeMillis(long timeMillis) {
        this.getLogContext().setTimeMillis(timeMillis);
    }

    public String getRootID() {
        return this.getLogContext().getRootID();
    }

    public void setRootID(String rootID) {
        this.getLogContext().setRootID(rootID);
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public String getLocalIP() {
        return this.hostIP + ":" + this.port;
    }

    private String getIP() {
        Collection<InetAddress> colInetAddress = this.getAllHostAddress();
        if (colInetAddress != null) {
            for (InetAddress address : colInetAddress) {
                if (address.isLoopbackAddress() || !(address instanceof Inet4Address)) continue;
                return address.getHostAddress();
            }
        }
        return "";
    }

    private Collection<InetAddress> getAllHostAddress() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    InetAddress inetAddress = inetAddresses.nextElement();
                    addresses.add(inetAddress);
                }
            }
            return addresses;
        }
        catch (SocketException e) {
            LOGGER.error(LogType.EX, "", e);
            return Collections.emptyList();
        }
    }
}

