/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.util;

import cpcn.dsp.institution.api.util.LogContextHolder;
import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.StringUtil;
import cpcn.dsp.institution.api.vo.LogContextVO;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Loggerx {
    private static String moduleID = "moduleID";
    private static volatile HashMap<String, Loggerx> loggerxMap;
    private Logger logger;

    private Loggerx(Logger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static Loggerx getLogger(String name) {
        Loggerx loggerx;
        if (StringUtil.isEmpty(name)) {
            throw new IllegalArgumentException();
        }
        if (loggerxMap == null) {
            Class<Loggerx> clazz = Loggerx.class;
            // MONITORENTER : cpcn.dsp.institution.api.util.Loggerx.class
            if (loggerxMap == null) {
                loggerxMap = new HashMap();
                // MONITOREXIT : clazz
                return Loggerx.getLoggerx(name);
            }
            // MONITOREXIT : clazz
        }
        if ((loggerx = loggerxMap.get(name)) != null) return loggerx;
        return Loggerx.getLoggerx(name);
    }

    private static Loggerx getLoggerx(String name) {
        Logger logger = LogManager.getLogger((String)name);
        if (logger == null) {
            return null;
        }
        Loggerx loggerx = new Loggerx(logger);
        loggerxMap.put(name, loggerx);
        return loggerx;
    }

    public void info(LogType logType, Object message) {
        String msgFormatted = this.msgFormat(logType, message);
        this.logger.info(msgFormatted);
    }

    public void info(LogType logType, Map<String, String> custMsg, Object message) {
        String msgFormatted = this.msgFormat(logType, custMsg, message);
        this.logger.info(msgFormatted);
    }

    public void error(LogType logType, Object message) {
        String msgFormatted = this.msgFormat(logType, message);
        this.logger.error(msgFormatted);
    }

    public void error(LogType logType, Map<String, String> custMsg, Object message) {
        String msgFormatted = this.msgFormat(logType, custMsg, message);
        this.logger.error(msgFormatted);
    }

    public void error(LogType logType, Object message, Throwable t) {
        String msgFormatted = this.msgFormat(logType, message, t);
        this.logger.error(msgFormatted, t);
    }

    public void error(LogType logType, Map<String, String> custMsg, Object message, Throwable t) {
        String msgFormatted = this.msgFormat(logType, custMsg, message);
        this.logger.error(msgFormatted, t);
    }

    public void warn(LogType logType, Object message) {
        String msgFormatted = this.msgFormat(logType, message);
        this.logger.warn(msgFormatted);
    }

    public void warn(LogType logType, Map<String, String> custMsg, Object message) {
        String msgFormatted = this.msgFormat(logType, custMsg, message);
        this.logger.warn(msgFormatted);
    }

    public void debug(LogType logType, Object message) {
        String msgFormatted = this.msgFormat(logType, message);
        this.logger.debug(msgFormatted);
    }

    private String msgFormat(LogType logType, Object message) {
        StringBuilder sb = new StringBuilder();
        LogContextVO logContext = LogContextHolder.getInstance().getLogContext();
        sb.append(logContext.getTraceID());
        sb.append("|").append(logContext.getTransferID());
        sb.append("|").append(logContext.getLocalIP());
        sb.append("|").append(logContext.getTraceIP());
        sb.append("|").append(moduleID);
        sb.append("|").append(logContext.getRootID());
        sb.append("|").append((Object)logType);
        sb.append("|");
        sb.append(message != null ? "|" + message.toString() + "|" : "");
        return sb.toString();
    }

    private String msgFormat(LogType logType, Object message, Throwable t) {
        StringBuilder sb = new StringBuilder();
        LogContextVO logContext = LogContextHolder.getInstance().getLogContext();
        sb.append(logContext.getTraceID());
        sb.append("|").append(logContext.getTransferID());
        sb.append("|").append(logContext.getLocalIP());
        sb.append("|").append(logContext.getTraceIP());
        sb.append("|").append(moduleID);
        sb.append("|").append(logContext.getRootID());
        sb.append("|").append((Object)logType);
        sb.append("|");
        sb.append(message != null ? "|" + message.toString() + "|" : "");
        if (t != null) {
            sb.append("|EX: " + t.getMessage() + "|");
        }
        return sb.toString();
    }

    private String msgFormat(LogType logType, Map<String, String> custMsgMap, Object message) {
        if (custMsgMap == null || custMsgMap.isEmpty()) {
            return this.msgFormat(logType, message);
        }
        StringBuilder sb = new StringBuilder();
        LogContextVO logContext = LogContextHolder.getInstance().getLogContext();
        sb.append(logContext.getTraceID());
        sb.append("|").append(logContext.getTransferID());
        sb.append("|").append(logContext.getLocalIP());
        sb.append("|").append(logContext.getTraceIP());
        sb.append("|").append(moduleID);
        sb.append("|").append(logContext.getRootID());
        sb.append("|").append((Object)logType);
        sb.append("|");
        for (Map.Entry<String, String> entry : custMsgMap.entrySet()) {
            sb.append(entry.getKey() + "=" + entry.getValue() + ",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(message != null ? "|" + message.toString() + "|" : "");
        return sb.toString();
    }

    public synchronized String getModuleID() {
        return moduleID;
    }

    public static synchronized void setModuleID(String module) {
        moduleID = module;
    }

    public void error(LogType error, String message, Exception e) {
    }
}

