/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import cpcn.dsp.institution.api.util.Base64;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public final class QRCodeUtil {
    private static final String CHARSET = "utf-8";

    QRCodeUtil() {
    }

    public static String createQRCodeWithLogo(String content, String logoFileName, int width, int height) throws Exception {
        if (logoFileName == null || "".equals(logoFileName)) {
            throw new Exception("logo\u6587\u4ef6\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u751f\u6210\u4e8c\u7ef4\u7801");
        }
        String path1 = new File("").getAbsolutePath();
        String logoPath = path1 + "\\" + logoFileName;
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = QRCodeUtil.deleteWhite(bitMatrix);
        QRCodeUtil.insertImage(image, logoPath, image.getWidth(), image.getHeight());
        return QRCodeUtil.bufferedImageToString(image);
    }

    public static String createQRCode(String content, int width, int height) throws Exception {
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, CHARSET);
        BitMatrix bitMatrix = new MultiFormatWriter().encode(content, BarcodeFormat.QR_CODE, width, height, hints);
        BufferedImage image = QRCodeUtil.deleteWhite(bitMatrix);
        return QRCodeUtil.bufferedImageToString(image);
    }

    private static BufferedImage deleteWhite(BitMatrix matrix) {
        int width = matrix.getWidth();
        int height = matrix.getHeight();
        BufferedImage image = new BufferedImage(width, height, 1);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                image.setRGB(x, y, matrix.get(x, y) ? -16777216 : -1);
            }
        }
        return image;
    }

    private static String bufferedImageToString(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "jpg", baos);
        byte[] bytes = baos.toByteArray();
        byte[] b = Base64.encode(bytes);
        return "data:image/jpg;base64," + new String(b, "UTF-8");
    }

    private static void insertImage(BufferedImage source, String logoPath, int qrWidth, int qrHeight) throws Exception {
        File file = new File(logoPath);
        if (!file.exists()) {
            return;
        }
        Image src = ImageIO.read(new File(logoPath));
        int width = qrWidth / 4;
        int height = qrWidth / 4;
        Image image = src.getScaledInstance(width, height, 4);
        BufferedImage tag = new BufferedImage(width, height, 1);
        Graphics g = tag.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        src = image;
        Graphics2D graph = source.createGraphics();
        int x = (qrWidth - width) / 2;
        int y = (qrHeight - height) / 2;
        graph.drawImage(src, x, y, width, height, null);
        RoundRectangle2D.Float shape = new RoundRectangle2D.Float(x, y, width, width, 6.0f, 6.0f);
        graph.setStroke(new BasicStroke(3.0f));
        graph.draw(shape);
        graph.dispose();
    }
}

