/*
 * Decompiled with CFR 0.152.
 */
package cpcn.dsp.institution.api.util;

import cpcn.dsp.institution.api.util.LogType;
import cpcn.dsp.institution.api.util.Loggerx;
import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtil {
    public static final String DEFAULT_CHARSET = "UTF-8";
    private static final Loggerx logger = Loggerx.getLogger("system");

    private StringUtil() {
    }

    public static String escape(String src, Map<String, String> hashMap) {
        if (src == null || src.trim().length() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        StringCharacterIterator sci = new StringCharacterIterator(src);
        char c = sci.first();
        while (c != '\uffff') {
            String ch = String.valueOf(c);
            if (hashMap.containsKey(ch)) {
                ch = hashMap.get(ch);
            }
            sb.append(ch);
            c = sci.next();
        }
        return sb.toString();
    }

    public static String escapeSQL(String input) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("'", "''");
        return StringUtil.escape(input, hashMap);
    }

    public static String escapeXML(String input) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("<", "&lt;");
        hashMap.put(">", "&gt;");
        hashMap.put("'", "&apos;");
        hashMap.put("\"", "&quot;");
        hashMap.put("&", "&amp;");
        return StringUtil.escape(input, hashMap);
    }

    public static String removeComma(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (',' == string.charAt(i)) continue;
            sb.append(string.charAt(i));
        }
        return sb.toString();
    }

    public static String toLetterOrDigit(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetterOrDigit(string.charAt(i))) {
                sb.append(string.charAt(i));
                continue;
            }
            sb.append("X");
        }
        return sb.toString();
    }

    public static String toLetter(String string) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isLetter(string.charAt(i))) {
                sb.append(string.charAt(i));
                continue;
            }
            if (Character.isDigit(string.charAt(i))) {
                switch (string.charAt(i)) {
                    case '0': {
                        sb.append("A");
                        break;
                    }
                    case '1': {
                        sb.append("B");
                        break;
                    }
                    case '2': {
                        sb.append("C");
                        break;
                    }
                    case '3': {
                        sb.append("D");
                        break;
                    }
                    case '4': {
                        sb.append("E");
                        break;
                    }
                    case '5': {
                        sb.append("F");
                        break;
                    }
                    case '6': {
                        sb.append("G");
                        break;
                    }
                    case '7': {
                        sb.append("H");
                        break;
                    }
                    case '8': {
                        sb.append("I");
                        break;
                    }
                    case '9': {
                        sb.append("J");
                        break;
                    }
                }
                continue;
            }
            sb.append("M");
        }
        return sb.toString();
    }

    public static String bytes2hex(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        String b = "";
        if (null == bytes) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            b = Integer.toHexString(bytes[i] & 0xFF);
            if (b.length() == 1) {
                result.append("0");
            }
            result.append(b);
        }
        return result.toString().toUpperCase();
    }

    public static byte[] hex2bytes(String hexStringParam) {
        String hexString = hexStringParam;
        hexString = hexString.toUpperCase();
        char[] chars = hexString.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int index = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | StringUtil.char2byte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[index] = newByte = (byte)(newByte | StringUtil.char2byte(chars[i + 1]));
            ++index;
        }
        return bytes;
    }

    public static byte char2byte(char ch) {
        switch (ch) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return Byte.parseByte(String.valueOf(ch), 16);
            }
        }
        return 0;
    }

    private static void byte2hex(byte b, StringBuffer sb) {
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        sb.append(hexChars[high]);
        sb.append(hexChars[low]);
    }

    public static String toHexString(byte[] bytes, char c) {
        StringBuffer sb = new StringBuffer();
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            StringUtil.byte2hex(bytes[i], sb);
            if (i >= len - 1) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toHexString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        int len = bytes.length;
        for (int i = 0; i < len; ++i) {
            StringUtil.byte2hex(bytes[i], sb);
        }
        return sb.toString();
    }

    public static Object byteToObject(byte[] bytes) {
        Object obj = null;
        try {
            ByteArrayInputStream bi = new ByteArrayInputStream(bytes);
            ObjectInputStream oi = new ObjectInputStream(bi);
            obj = oi.readObject();
            bi.close();
            oi.close();
        }
        catch (Exception e) {
            logger.error(LogType.ERROR, "translation" + e.getMessage(), e);
        }
        return obj;
    }

    public static boolean isEmpty(String str) {
        return null == str || "".equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return str != null && !"".equals(str.trim());
    }

    public static String replace(String string, String replacement) {
        if (string != null) {
            return string.replaceAll(replacement, "");
        }
        return null;
    }

    public static String trim(String string) {
        if (StringUtil.isEmpty(string)) {
            return "";
        }
        return string.trim();
    }

    public static String trimNum(String string) {
        if (StringUtil.isEmpty(string)) {
            return "0";
        }
        return string.trim();
    }

    public static boolean isValidList(String string) {
        return !StringUtil.isEmpty(string) && !"-1".equals(string.trim());
    }

    public static boolean validate(String string) {
        Pattern pattern = Pattern.compile("^[\\\\\\(\\)\\\uff08\\\uff09\\[\\]\\{\\}\\\u300e\\\u300f\\\u3010\\\u3011\\\u00b7\\!\\w\\.\\@\\?\\+\\_\\\u2014\\|\\\uff0d\\-\\=\\/\\:\\\uff1a\\,\\s\u4e00-\u9fbb\u3400-\u4db5\uf900-\ufa6a\ue815-\ue864\\#]*$");
        Matcher m = pattern.matcher(string);
        return m.matches();
    }

    public static byte[] byteConcat(byte[] b1, byte[] b2) {
        int i;
        if (null == b1 || null == b2) {
            return new byte[0];
        }
        int b1Len = b1.length;
        int b2Len = b2.length;
        byte[] b = new byte[b1Len + b2Len];
        for (i = 0; i < b1Len; ++i) {
            b[i] = b1[i];
        }
        for (i = 0; i < b2Len; ++i) {
            b[i + b1Len] = b2[i];
        }
        return b;
    }

    public static byte[] byteXORbyte(byte[] b1, byte[] b2) {
        if (null != b1 && null != b2) {
            int b1Len = b1.length;
            int b2Len = b2.length;
            if (b1Len != b2Len) {
                return new byte[0];
            }
            byte[] byteXOR = new byte[b1Len];
            for (int i = 0; i < b1Len; ++i) {
                byteXOR[i] = (byte)(b1[i] ^ b2[i]);
            }
            return byteXOR;
        }
        return new byte[0];
    }

    public static String rightPad(String str, char stuff, int size) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(size);
        sb.append(str);
        while (sb.length() < size) {
            sb.append(stuff);
        }
        return sb.toString();
    }

    public static String leftPad(String str, char stuff, int size) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(size);
        while (sb.length() < pads) {
            sb.append(stuff);
        }
        sb.append(str);
        return sb.toString();
    }

    public static int parseInt(String sourceString, int defaultValue) {
        int value = defaultValue;
        if (!StringUtil.isEmpty(sourceString)) {
            try {
                value = Integer.parseInt(sourceString.trim());
            }
            catch (Exception e) {
                value = defaultValue;
                logger.error(LogType.ERROR, e.getMessage(), e);
            }
        }
        return value;
    }

    public static long parseLong(String sourceString, long defaultValue) {
        long value = defaultValue;
        if (!StringUtil.isEmpty(sourceString)) {
            try {
                value = Long.parseLong(sourceString.trim());
            }
            catch (Exception e) {
                value = defaultValue;
                logger.error(LogType.ERROR, e.getMessage(), e);
            }
        }
        return value;
    }

    public static void removeDuplicate(List<String> list) {
        HashSet<String> h = new HashSet<String>(list);
        list.clear();
        list.addAll(h);
    }
}

