/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.impl;

import com.cloudhopper.smpp.SmppBindType;
import com.cloudhopper.smpp.SmppClient;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.SmppSessionHandler;
import com.cloudhopper.smpp.channel.SmppClientConnector;
import com.cloudhopper.smpp.channel.SmppSessionLogger;
import com.cloudhopper.smpp.channel.SmppSessionPduDecoder;
import com.cloudhopper.smpp.channel.SmppSessionThreadRenamer;
import com.cloudhopper.smpp.channel.SmppSessionWrapper;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.pdu.BindReceiver;
import com.cloudhopper.smpp.pdu.BindTransceiver;
import com.cloudhopper.smpp.pdu.BindTransmitter;
import com.cloudhopper.smpp.ssl.SslConfiguration;
import com.cloudhopper.smpp.ssl.SslContextFactory;
import com.cloudhopper.smpp.type.RecoverablePduException;
import com.cloudhopper.smpp.type.SmppBindException;
import com.cloudhopper.smpp.type.SmppChannelConnectException;
import com.cloudhopper.smpp.type.SmppChannelConnectTimeoutException;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppTimeoutException;
import com.cloudhopper.smpp.type.UnrecoverablePduException;
import com.cloudhopper.smpp.util.DaemonExecutors;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ConnectTimeoutException;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.timeout.WriteTimeoutHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSmppClient
implements SmppClient {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSmppClient.class);
    private ChannelGroup channels = new DefaultChannelGroup();
    private SmppClientConnector clientConnector;
    private ExecutorService executors;
    private ClientSocketChannelFactory channelFactory;
    private ClientBootstrap clientBootstrap;
    private ScheduledExecutorService monitorExecutor;
    private final Timer writeTimeoutTimer;

    public DefaultSmppClient() {
        this(DaemonExecutors.newCachedDaemonThreadPool());
    }

    public DefaultSmppClient(ExecutorService executors) {
        this(executors, Runtime.getRuntime().availableProcessors());
    }

    public DefaultSmppClient(ExecutorService executors, int expectedSessions) {
        this(executors, expectedSessions, null);
    }

    public DefaultSmppClient(ExecutorService executors, int expectedSessions, ScheduledExecutorService monitorExecutor) {
        this.executors = executors;
        this.channelFactory = new NioClientSocketChannelFactory((Executor)this.executors, (Executor)this.executors, expectedSessions);
        this.clientBootstrap = new ClientBootstrap((ChannelFactory)this.channelFactory);
        this.clientConnector = new SmppClientConnector(this.channels);
        this.clientBootstrap.getPipeline().addLast("smppClientConnector", (ChannelHandler)this.clientConnector);
        this.monitorExecutor = monitorExecutor;
        this.writeTimeoutTimer = new HashedWheelTimer();
    }

    public int getConnectionSize() {
        return this.channels.size();
    }

    @Override
    public void destroy() {
        this.channels.close().awaitUninterruptibly();
        this.clientBootstrap.releaseExternalResources();
        this.writeTimeoutTimer.stop();
    }

    protected BaseBind createBindRequest(SmppSessionConfiguration config) throws UnrecoverablePduException {
        BaseBind bind = null;
        if (config.getType() == SmppBindType.TRANSCEIVER) {
            bind = new BindTransceiver();
        } else if (config.getType() == SmppBindType.RECEIVER) {
            bind = new BindReceiver();
        } else if (config.getType() == SmppBindType.TRANSMITTER) {
            bind = new BindTransmitter();
        } else {
            throw new UnrecoverablePduException("Unable to convert SmppSessionConfiguration into a BaseBind request");
        }
        bind.setSystemId(config.getSystemId());
        bind.setPassword(config.getPassword());
        bind.setSystemType(config.getSystemType());
        bind.setInterfaceVersion(config.getInterfaceVersion());
        bind.setAddressRange(config.getAddressRange());
        return bind;
    }

    public SmppSession bind(SmppSessionConfiguration config) throws SmppTimeoutException, SmppChannelException, SmppBindException, UnrecoverablePduException, InterruptedException {
        return this.bind(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SmppSession bind(SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, SmppBindException, UnrecoverablePduException, InterruptedException {
        DefaultSmppSession session = null;
        try {
            session = this.doOpen(config, sessionHandler);
            this.doBind(session, config, sessionHandler);
        }
        finally {
            if (session != null && !session.isBound()) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
        }
        return session;
    }

    protected void doBind(DefaultSmppSession session, SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, SmppBindException, UnrecoverablePduException, InterruptedException {
        BaseBind bindRequest = this.createBindRequest(config);
        BaseBindResp bindResp = null;
        try {
            bindResp = session.bind(bindRequest, config.getBindTimeout());
        }
        catch (RecoverablePduException e) {
            throw new UnrecoverablePduException(e.getMessage(), e);
        }
    }

    protected DefaultSmppSession doOpen(SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, InterruptedException {
        Channel channel = this.createConnectedChannel(config.getHost(), config.getPort(), config.getConnectTimeout());
        return this.createSession(channel, config, sessionHandler);
    }

    protected DefaultSmppSession createSession(Channel channel, SmppSessionConfiguration config, SmppSessionHandler sessionHandler) throws SmppTimeoutException, SmppChannelException, InterruptedException {
        DefaultSmppSession session = new DefaultSmppSession(SmppSession.Type.CLIENT, config, channel, sessionHandler, this.monitorExecutor);
        if (config.isUseSsl()) {
            SslConfiguration sslConfig = config.getSslConfiguration();
            if (sslConfig == null) {
                throw new IllegalStateException("sslConfiguration must be set");
            }
            try {
                SslContextFactory factory = new SslContextFactory(sslConfig);
                SSLEngine sslEngine = factory.newSslEngine();
                sslEngine.setUseClientMode(true);
                channel.getPipeline().addLast("smppSessionSSL", (ChannelHandler)new SslHandler(sslEngine));
            }
            catch (Exception e) {
                throw new SmppChannelConnectException("Unable to create SSL session]: " + e.getMessage(), e);
            }
        }
        if (config.getName() != null) {
            channel.getPipeline().addLast("smppSessionThreadRenamer", (ChannelHandler)new SmppSessionThreadRenamer(config.getName()));
        } else {
            logger.warn("Session configuration did not have a name set - skipping threadRenamer in pipeline");
        }
        SmppSessionLogger loggingHandler = new SmppSessionLogger(DefaultSmppSession.class.getCanonicalName(), config.getLoggingOptions());
        channel.getPipeline().addLast("smppSessionLogger", (ChannelHandler)loggingHandler);
        if (config.getWriteTimeout() > 0L) {
            WriteTimeoutHandler writeTimeoutHandler = new WriteTimeoutHandler(this.writeTimeoutTimer, config.getWriteTimeout(), TimeUnit.MILLISECONDS);
            channel.getPipeline().addLast("smppSessionWriteTimeout", (ChannelHandler)writeTimeoutHandler);
        }
        channel.getPipeline().addLast("smppSessionPduDecoder", (ChannelHandler)new SmppSessionPduDecoder(session.getTranscoder()));
        channel.getPipeline().addLast("smppSessionWrapper", (ChannelHandler)new SmppSessionWrapper(session));
        return session;
    }

    protected Channel createConnectedChannel(String host, int port, long connectTimeoutMillis) throws SmppTimeoutException, SmppChannelException, InterruptedException {
        InetSocketAddress socketAddr = new InetSocketAddress(host, port);
        this.clientBootstrap.setOption("connectTimeoutMillis", (Object)connectTimeoutMillis);
        ChannelFuture connectFuture = this.clientBootstrap.connect((SocketAddress)socketAddr);
        connectFuture.awaitUninterruptibly();
        if (connectFuture.isCancelled()) {
            throw new InterruptedException("connectFuture cancelled by user");
        }
        if (!connectFuture.isSuccess()) {
            if (connectFuture.getCause() instanceof ConnectTimeoutException) {
                throw new SmppChannelConnectTimeoutException("Unable to connect to host [" + host + "] and port [" + port + "] within " + connectTimeoutMillis + " ms", connectFuture.getCause());
            }
            throw new SmppChannelConnectException("Unable to connect to host [" + host + "] and port [" + port + "]: " + connectFuture.getCause().getMessage(), connectFuture.getCause());
        }
        return connectFuture.getChannel();
    }
}

