/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.impl;

import com.cloudhopper.smpp.SmppServer;
import com.cloudhopper.smpp.SmppServerConfiguration;
import com.cloudhopper.smpp.SmppServerHandler;
import com.cloudhopper.smpp.SmppSession;
import com.cloudhopper.smpp.SmppSessionConfiguration;
import com.cloudhopper.smpp.channel.SmppServerConnector;
import com.cloudhopper.smpp.channel.SmppSessionLogger;
import com.cloudhopper.smpp.channel.SmppSessionThreadRenamer;
import com.cloudhopper.smpp.channel.SmppSessionWrapper;
import com.cloudhopper.smpp.impl.DefaultSmppServerCounters;
import com.cloudhopper.smpp.impl.DefaultSmppSession;
import com.cloudhopper.smpp.jmx.DefaultSmppServerMXBean;
import com.cloudhopper.smpp.pdu.BaseBind;
import com.cloudhopper.smpp.pdu.BaseBindResp;
import com.cloudhopper.smpp.tlv.Tlv;
import com.cloudhopper.smpp.transcoder.DefaultPduTranscoder;
import com.cloudhopper.smpp.transcoder.DefaultPduTranscoderContext;
import com.cloudhopper.smpp.transcoder.PduTranscoder;
import com.cloudhopper.smpp.type.SmppChannelException;
import com.cloudhopper.smpp.type.SmppProcessingException;
import com.cloudhopper.smpp.util.DaemonExecutors;
import java.lang.management.ManagementFactory;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Timer;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.jboss.netty.handler.timeout.WriteTimeoutHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSmppServer
implements SmppServer,
DefaultSmppServerMXBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSmppServer.class);
    private final ChannelGroup channels;
    private final SmppServerConnector serverConnector;
    private final SmppServerConfiguration configuration;
    private final SmppServerHandler serverHandler;
    private final PduTranscoder transcoder;
    private ExecutorService bossThreadPool;
    private ChannelFactory channelFactory;
    private ServerBootstrap serverBootstrap;
    private Channel serverChannel;
    private final org.jboss.netty.util.Timer writeTimeoutTimer;
    private final Timer bindTimer;
    private final AtomicLong sessionIdSequence;
    private final ScheduledExecutorService monitorExecutor;
    private DefaultSmppServerCounters counters;

    public DefaultSmppServer(SmppServerConfiguration configuration, SmppServerHandler serverHandler) {
        this(configuration, serverHandler, DaemonExecutors.newCachedDaemonThreadPool());
    }

    public DefaultSmppServer(SmppServerConfiguration configuration, SmppServerHandler serverHandler, ExecutorService executor) {
        this(configuration, serverHandler, executor, null);
    }

    public DefaultSmppServer(SmppServerConfiguration configuration, SmppServerHandler serverHandler, ExecutorService executor, ScheduledExecutorService monitorExecutor) {
        this.configuration = configuration;
        this.channels = new DefaultChannelGroup();
        this.serverHandler = serverHandler;
        this.bossThreadPool = Executors.newCachedThreadPool();
        this.channelFactory = configuration.isNonBlockingSocketsEnabled() ? new NioServerSocketChannelFactory((Executor)this.bossThreadPool, (Executor)executor, configuration.getMaxConnectionSize()) : new OioServerSocketChannelFactory((Executor)this.bossThreadPool, (Executor)executor);
        this.serverBootstrap = new ServerBootstrap(this.channelFactory);
        this.serverBootstrap.setOption("reuseAddress", (Object)configuration.isReuseAddress());
        this.serverConnector = new SmppServerConnector(this.channels, this);
        this.serverBootstrap.getPipeline().addLast("smppServerConnector", (ChannelHandler)this.serverConnector);
        this.writeTimeoutTimer = new HashedWheelTimer();
        this.bindTimer = new Timer(configuration.getName() + "-BindTimer0", true);
        this.transcoder = new DefaultPduTranscoder(new DefaultPduTranscoderContext());
        this.sessionIdSequence = new AtomicLong(0L);
        this.monitorExecutor = monitorExecutor;
        this.counters = new DefaultSmppServerCounters();
        if (configuration.isJmxEnabled()) {
            this.registerMBean();
        }
    }

    private void registerMBean() {
        if (this.configuration == null) {
            return;
        }
        if (this.configuration.isJmxEnabled()) {
            try {
                ObjectName name = new ObjectName(this.configuration.getJmxDomain() + ":name=" + this.configuration.getName());
                ManagementFactory.getPlatformMBeanServer().registerMBean(this, name);
            }
            catch (Exception e) {
                logger.error("Unable to register DefaultSmppServerMXBean [{}]", (Object)this.configuration.getName(), (Object)e);
            }
        }
    }

    private void unregisterMBean() {
        if (this.configuration == null) {
            return;
        }
        if (this.configuration.isJmxEnabled()) {
            try {
                ObjectName name = new ObjectName(this.configuration.getJmxDomain() + ":name=" + this.configuration.getName());
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
            }
            catch (Exception e) {
                logger.error("Unable to unregister DefaultSmppServerMXBean [{}]", (Object)this.configuration.getName(), (Object)e);
            }
        }
    }

    public PduTranscoder getTranscoder() {
        return this.transcoder;
    }

    @Override
    public ChannelGroup getChannels() {
        return this.channels;
    }

    public SmppServerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public DefaultSmppServerCounters getCounters() {
        return this.counters;
    }

    public Timer getBindTimer() {
        return this.bindTimer;
    }

    @Override
    public boolean isStarted() {
        return this.serverChannel != null && this.serverChannel.isBound();
    }

    @Override
    public boolean isStopped() {
        return this.serverChannel == null;
    }

    @Override
    public boolean isDestroyed() {
        return this.serverBootstrap == null;
    }

    @Override
    public void start() throws SmppChannelException {
        if (this.isDestroyed()) {
            throw new SmppChannelException("Unable to start: server is destroyed");
        }
        try {
            this.serverChannel = this.serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.configuration.getHost(), this.configuration.getPort()));
            logger.info("{} started at {}:{}", new Object[]{this.configuration.getName(), this.configuration.getHost(), this.configuration.getPort()});
        }
        catch (ChannelException e) {
            throw new SmppChannelException(e.getMessage(), e);
        }
    }

    @Override
    public void stop() {
        if (this.channels.size() > 0) {
            logger.info("{} currently has [{}] open child channel(s) that will be closed as part of stop()", (Object)this.configuration.getName(), (Object)this.channels.size());
        }
        this.channels.close().awaitUninterruptibly();
        if (this.serverChannel != null) {
            this.serverChannel.close().awaitUninterruptibly();
            this.serverChannel = null;
        }
        logger.info("{} stopped at {}:{}", new Object[]{this.configuration.getName(), this.configuration.getHost(), this.configuration.getPort()});
    }

    @Override
    public void destroy() {
        this.bindTimer.cancel();
        this.stop();
        this.serverBootstrap.releaseExternalResources();
        this.serverBootstrap = null;
        this.writeTimeoutTimer.stop();
        this.unregisterMBean();
        logger.info("{} destroyed on SMPP port [{}]", (Object)this.configuration.getName(), (Object)this.configuration.getPort());
    }

    protected Long nextSessionId() {
        return this.sessionIdSequence.getAndIncrement();
    }

    protected byte autoNegotiateInterfaceVersion(byte requestedInterfaceVersion) {
        if (!this.configuration.isAutoNegotiateInterfaceVersion()) {
            return requestedInterfaceVersion;
        }
        if (requestedInterfaceVersion >= 52) {
            return 52;
        }
        return 51;
    }

    protected BaseBindResp createBindResponse(BaseBind bindRequest, int statusCode) {
        BaseBindResp bindResponse = (BaseBindResp)bindRequest.createResponse();
        bindResponse.setCommandStatus(statusCode);
        bindResponse.setSystemId(this.configuration.getSystemId());
        if (this.configuration.getInterfaceVersion() >= 52 && bindRequest.getInterfaceVersion() >= 52) {
            Tlv scInterfaceVersion = new Tlv(528, new byte[]{this.configuration.getInterfaceVersion()});
            bindResponse.addOptionalParameter(scInterfaceVersion);
        }
        return bindResponse;
    }

    protected void bindRequested(Long sessionId, SmppSessionConfiguration config, BaseBind bindRequest) throws SmppProcessingException {
        this.counters.incrementBindRequestedAndGet();
        this.serverHandler.sessionBindRequested(sessionId, config, bindRequest);
    }

    protected void createSession(Long sessionId, Channel channel, SmppSessionConfiguration config, BaseBindResp preparedBindResponse) throws SmppProcessingException {
        channel.setReadable(false).awaitUninterruptibly();
        byte interfaceVersion = this.autoNegotiateInterfaceVersion(config.getInterfaceVersion());
        DefaultSmppSession session = new DefaultSmppSession(SmppSession.Type.SERVER, config, channel, this, sessionId, preparedBindResponse, interfaceVersion, this.monitorExecutor);
        SmppSessionThreadRenamer threadRenamer = (SmppSessionThreadRenamer)channel.getPipeline().get("smppSessionThreadRenamer");
        threadRenamer.setThreadName(config.getName());
        SmppSessionLogger loggingHandler = new SmppSessionLogger(DefaultSmppSession.class.getCanonicalName(), config.getLoggingOptions());
        channel.getPipeline().addAfter("smppSessionThreadRenamer", "smppSessionLogger", (ChannelHandler)loggingHandler);
        if (config.getWriteTimeout() > 0L) {
            WriteTimeoutHandler writeTimeoutHandler = new WriteTimeoutHandler(this.writeTimeoutTimer, config.getWriteTimeout(), TimeUnit.MILLISECONDS);
            channel.getPipeline().addAfter("smppSessionLogger", "smppSessionWriteTimeout", (ChannelHandler)writeTimeoutHandler);
        }
        channel.getPipeline().remove("smppSessionWrapper");
        channel.getPipeline().addLast("smppSessionWrapper", (ChannelHandler)new SmppSessionWrapper(session));
        if (this.channels.size() > this.configuration.getMaxConnectionSize()) {
            logger.warn("The current connection size [{}] exceeds the configured max connection size [{}]", (Object)this.channels.size(), (Object)this.configuration.getMaxConnectionSize());
        }
        this.counters.incrementSessionCreatedAndGet();
        this.incrementSessionSizeCounters(session);
        this.serverHandler.sessionCreated(sessionId, session, preparedBindResponse);
        if (this.configuration.isJmxEnabled()) {
            session.registerMBean(this.configuration.getJmxDomain() + ":type=" + this.configuration.getName() + "Sessions,name=" + sessionId);
        }
    }

    protected void destroySession(Long sessionId, DefaultSmppSession session) {
        this.counters.incrementSessionDestroyedAndGet();
        this.decrementSessionSizeCounters(session);
        this.serverHandler.sessionDestroyed(sessionId, session);
        if (this.configuration.isJmxEnabled()) {
            session.unregisterMBean(this.configuration.getJmxDomain() + ":type=" + this.configuration.getName() + "Sessions,name=" + sessionId);
        }
    }

    private void incrementSessionSizeCounters(DefaultSmppSession session) {
        this.counters.incrementSessionSizeAndGet();
        switch (session.getBindType()) {
            case TRANSCEIVER: {
                this.counters.incrementTransceiverSessionSizeAndGet();
                break;
            }
            case RECEIVER: {
                this.counters.incrementTransmitterSessionSizeAndGet();
                break;
            }
            case TRANSMITTER: {
                this.counters.incrementReceiverSessionSizeAndGet();
            }
        }
    }

    private void decrementSessionSizeCounters(DefaultSmppSession session) {
        this.counters.decrementSessionSizeAndGet();
        switch (session.getBindType()) {
            case TRANSCEIVER: {
                this.counters.decrementTransceiverSessionSizeAndGet();
                break;
            }
            case RECEIVER: {
                this.counters.decrementTransmitterSessionSizeAndGet();
                break;
            }
            case TRANSMITTER: {
                this.counters.decrementReceiverSessionSizeAndGet();
            }
        }
    }

    @Override
    public void resetCounters() {
        this.counters.reset();
    }

    @Override
    public int getSessionSize() {
        return this.counters.getSessionSize();
    }

    @Override
    public int getTransceiverSessionSize() {
        return this.counters.getTransceiverSessionSize();
    }

    @Override
    public int getTransmitterSessionSize() {
        return this.counters.getTransmitterSessionSize();
    }

    @Override
    public int getReceiverSessionSize() {
        return this.counters.getReceiverSessionSize();
    }

    @Override
    public int getMaxConnectionSize() {
        return this.configuration.getMaxConnectionSize();
    }

    @Override
    public int getConnectionSize() {
        return this.channels.size();
    }

    @Override
    public long getBindTimeout() {
        return this.configuration.getBindTimeout();
    }

    @Override
    public boolean isNonBlockingSocketsEnabled() {
        return this.configuration.isNonBlockingSocketsEnabled();
    }

    @Override
    public boolean isReuseAddress() {
        return this.configuration.isReuseAddress();
    }

    @Override
    public int getChannelConnects() {
        return this.getCounters().getChannelConnects();
    }

    @Override
    public int getChannelDisconnects() {
        return this.getCounters().getChannelDisconnects();
    }

    @Override
    public int getBindTimeouts() {
        return this.getCounters().getBindTimeouts();
    }

    @Override
    public int getBindRequested() {
        return this.getCounters().getBindRequested();
    }

    @Override
    public int getSessionCreated() {
        return this.getCounters().getSessionCreated();
    }

    @Override
    public int getSessionDestroyed() {
        return this.getCounters().getSessionDestroyed();
    }
}

