/*
 * Decompiled with CFR 0.152.
 */
package com.cloudhopper.smpp.simulator;

import com.cloudhopper.commons.util.HexUtil;
import com.cloudhopper.smpp.pdu.Pdu;
import com.cloudhopper.smpp.simulator.SmppSimulatorPduProcessor;
import com.cloudhopper.smpp.transcoder.PduTranscoder;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppSimulatorSessionHandler
extends FrameDecoder {
    private static final Logger logger = LoggerFactory.getLogger(SmppSimulatorSessionHandler.class);
    private final Channel channel;
    private final PduTranscoder transcoder;
    private final BlockingQueue<Pdu> pduQueue;
    private final BlockingQueue<Throwable> exceptionQueue;
    private final BlockingDeque<Pdu> writePduQueue;
    private SmppSimulatorPduProcessor pduProcessor;

    public SmppSimulatorSessionHandler(Channel channel, PduTranscoder transcoder) {
        this.channel = channel;
        this.transcoder = transcoder;
        this.pduQueue = new LinkedBlockingQueue<Pdu>();
        this.exceptionQueue = new LinkedBlockingQueue<Throwable>();
        this.writePduQueue = new LinkedBlockingDeque<Pdu>();
    }

    public SmppSimulatorPduProcessor getPduProcessor() {
        return this.pduProcessor;
    }

    public void setPduProcessor(SmppSimulatorPduProcessor pduProcessor) {
        this.pduProcessor = pduProcessor;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public PduTranscoder getTranscoder() {
        return this.transcoder;
    }

    public BlockingQueue<Pdu> getPduQueue() {
        return this.pduQueue;
    }

    public void addPduToWriteOnNextPduReceived(Pdu pdu) {
        this.writePduQueue.add(pdu);
    }

    public Pdu pollNextPdu(long timeoutInMillis) throws InterruptedException {
        return this.pduQueue.poll(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public BlockingQueue<Throwable> getThrowableQueue() {
        return this.exceptionQueue;
    }

    public Throwable pollNextThrowable(long timeoutInMillis) throws InterruptedException {
        return this.exceptionQueue.poll(timeoutInMillis, TimeUnit.MILLISECONDS);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        logger.info("Received new throwable on channel 0x" + HexUtil.toHexString((int)this.channel.getId()));
        this.exceptionQueue.add(e.getCause());
    }

    public void sendPdu(Pdu pdu) throws Exception {
        logger.info("Sending on channel 0x" + HexUtil.toHexString((int)this.channel.getId()) + " PDU: {}", (Object)pdu);
        ChannelBuffer writeBuffer = this.transcoder.encode(pdu);
        this.channel.write((Object)writeBuffer).await();
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (buffer.readableBytes() <= 0) {
            return null;
        }
        Pdu pdu = this.transcoder.decode(buffer);
        if (pdu == null) {
            logger.info("Received data on channel 0x" + HexUtil.toHexString((int)channel.getId()) + ", but not enough to parse PDU fully yet");
            logger.info("Bytes in buffer: [{}]", (Object)ChannelBuffers.hexDump((ChannelBuffer)buffer));
            return null;
        }
        logger.info("Decoded buffer on channel 0x" + HexUtil.toHexString((int)channel.getId()) + " into PDU: {}", (Object)pdu);
        boolean processed = false;
        if (this.pduProcessor != null) {
            processed = this.pduProcessor.process(this, channel, pdu);
        }
        if (processed) {
            logger.info("This PDU was processed by the registered PduProcessor");
        } else {
            this.pduQueue.add(pdu);
        }
        if (this.writePduQueue.size() > 0) {
            Pdu pduToWrite = this.writePduQueue.remove();
            logger.info("Automatically writing back on channel 0x" + HexUtil.toHexString((int)channel.getId()) + " the PDU: {}", (Object)pduToWrite);
            ChannelBuffer writeBuffer = this.transcoder.encode(pduToWrite);
            channel.write((Object)writeBuffer);
        }
        return pdu;
    }
}

