/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.aspect;

import com.codingapi.txlcn.common.util.Transactions;
import com.codingapi.txlcn.tc.annotation.DTXPropagation;
import com.codingapi.txlcn.tc.aspect.TransactionInfo;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.aopalliance.intercept.MethodInvocation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.ConcurrentReferenceHashMap;

public class DTXInfo {
    private static final Map<String, DTXInfo> dtxInfoCache = new ConcurrentReferenceHashMap();
    private String transactionType;
    private DTXPropagation transactionPropagation;
    private TransactionInfo transactionInfo;
    private Method businessMethod;
    private String unitId;

    private DTXInfo(Method method, Object[] args, Class<?> targetClass) {
        this.transactionInfo = new TransactionInfo();
        this.transactionInfo.setTargetClazz(targetClass);
        this.transactionInfo.setArgumentValues(args);
        this.transactionInfo.setMethod(method.getName());
        this.transactionInfo.setMethodStr(method.toString());
        this.transactionInfo.setParameterTypes(method.getParameterTypes());
        this.businessMethod = method;
        this.unitId = Transactions.unitId((String)method.toString());
    }

    private void reanalyseMethodArgs(Object[] args) {
        this.transactionInfo.setArgumentValues(args);
    }

    public static DTXInfo getFromCache(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        String signature = proceedingJoinPoint.getSignature().toString();
        String unitId = Transactions.unitId((String)signature);
        DTXInfo dtxInfo = dtxInfoCache.get(unitId);
        if (Objects.isNull(dtxInfo)) {
            MethodSignature methodSignature = (MethodSignature)proceedingJoinPoint.getSignature();
            Method method = methodSignature.getMethod();
            Class<?> targetClass = proceedingJoinPoint.getTarget().getClass();
            Method thisMethod = targetClass.getMethod(method.getName(), method.getParameterTypes());
            dtxInfo = new DTXInfo(thisMethod, proceedingJoinPoint.getArgs(), targetClass);
            dtxInfoCache.put(unitId, dtxInfo);
        }
        dtxInfo.reanalyseMethodArgs(proceedingJoinPoint.getArgs());
        return dtxInfo;
    }

    public static DTXInfo getFromCache(MethodInvocation methodInvocation) {
        String signature = methodInvocation.getMethod().toString();
        String unitId = Transactions.unitId((String)signature);
        DTXInfo dtxInfo = dtxInfoCache.get(unitId);
        if (Objects.isNull(dtxInfo)) {
            dtxInfo = new DTXInfo(methodInvocation.getMethod(), methodInvocation.getArguments(), methodInvocation.getThis().getClass());
            dtxInfoCache.put(unitId, dtxInfo);
        }
        dtxInfo.reanalyseMethodArgs(methodInvocation.getArguments());
        return dtxInfo;
    }

    public static DTXInfo getFromCache(Method method, Object[] args, Class<?> targetClass) {
        String signature = method.getName();
        String unitId = Transactions.unitId((String)signature);
        DTXInfo dtxInfo = dtxInfoCache.get(unitId);
        if (Objects.isNull(dtxInfo)) {
            dtxInfo = new DTXInfo(method, args, targetClass);
            dtxInfoCache.put(unitId, dtxInfo);
        }
        dtxInfo.reanalyseMethodArgs(args);
        return dtxInfo;
    }

    public DTXInfo(String transactionType, DTXPropagation transactionPropagation, TransactionInfo transactionInfo, Method businessMethod, String unitId) {
        this.transactionType = transactionType;
        this.transactionPropagation = transactionPropagation;
        this.transactionInfo = transactionInfo;
        this.businessMethod = businessMethod;
        this.unitId = unitId;
    }

    public String getTransactionType() {
        return this.transactionType;
    }

    public DTXPropagation getTransactionPropagation() {
        return this.transactionPropagation;
    }

    public TransactionInfo getTransactionInfo() {
        return this.transactionInfo;
    }

    public Method getBusinessMethod() {
        return this.businessMethod;
    }

    public String getUnitId() {
        return this.unitId;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public void setTransactionPropagation(DTXPropagation transactionPropagation) {
        this.transactionPropagation = transactionPropagation;
    }

    public void setTransactionInfo(TransactionInfo transactionInfo) {
        this.transactionInfo = transactionInfo;
    }

    public void setBusinessMethod(Method businessMethod) {
        this.businessMethod = businessMethod;
    }

    public void setUnitId(String unitId) {
        this.unitId = unitId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DTXInfo)) {
            return false;
        }
        DTXInfo other = (DTXInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$transactionType = this.getTransactionType();
        String other$transactionType = other.getTransactionType();
        if (this$transactionType == null ? other$transactionType != null : !this$transactionType.equals(other$transactionType)) {
            return false;
        }
        DTXPropagation this$transactionPropagation = this.getTransactionPropagation();
        DTXPropagation other$transactionPropagation = other.getTransactionPropagation();
        if (this$transactionPropagation == null ? other$transactionPropagation != null : !((Object)((Object)this$transactionPropagation)).equals((Object)other$transactionPropagation)) {
            return false;
        }
        TransactionInfo this$transactionInfo = this.getTransactionInfo();
        TransactionInfo other$transactionInfo = other.getTransactionInfo();
        if (this$transactionInfo == null ? other$transactionInfo != null : !this$transactionInfo.equals(other$transactionInfo)) {
            return false;
        }
        Method this$businessMethod = this.getBusinessMethod();
        Method other$businessMethod = other.getBusinessMethod();
        if (this$businessMethod == null ? other$businessMethod != null : !((Object)this$businessMethod).equals(other$businessMethod)) {
            return false;
        }
        String this$unitId = this.getUnitId();
        String other$unitId = other.getUnitId();
        return !(this$unitId == null ? other$unitId != null : !this$unitId.equals(other$unitId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DTXInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $transactionType = this.getTransactionType();
        result = result * 59 + ($transactionType == null ? 43 : $transactionType.hashCode());
        DTXPropagation $transactionPropagation = this.getTransactionPropagation();
        result = result * 59 + ($transactionPropagation == null ? 43 : ((Object)((Object)$transactionPropagation)).hashCode());
        TransactionInfo $transactionInfo = this.getTransactionInfo();
        result = result * 59 + ($transactionInfo == null ? 43 : $transactionInfo.hashCode());
        Method $businessMethod = this.getBusinessMethod();
        result = result * 59 + ($businessMethod == null ? 43 : ((Object)$businessMethod).hashCode());
        String $unitId = this.getUnitId();
        result = result * 59 + ($unitId == null ? 43 : $unitId.hashCode());
        return result;
    }

    public String toString() {
        return "DTXInfo(transactionType=" + this.getTransactionType() + ", transactionPropagation=" + (Object)((Object)this.getTransactionPropagation()) + ", transactionInfo=" + this.getTransactionInfo() + ", businessMethod=" + this.getBusinessMethod() + ", unitId=" + this.getUnitId() + ")";
    }
}

