/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.analy;

import com.codingapi.txlcn.common.exception.TCGlobalContextException;
import com.codingapi.txlcn.common.exception.TxcLogicException;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.TxcService;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.TxcSqlExecutor;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.DeleteImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.FieldCluster;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.FieldValue;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.InsertImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.ModifiedRecord;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.SelectImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.StatementInfo;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.UndoLogDO;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.UpdateImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.undo.TableRecord;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.undo.TableRecordList;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.undo.UndoLogAnalyser;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.util.SqlUtils;
import com.codingapi.txlcn.tc.corelog.txc.TxcLogHelper;
import com.codingapi.txlcn.tc.txmsg.ReliableMessenger;
import com.codingapi.txlcn.txmsg.exception.RpcException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;

@Component
public class TxcServiceImpl
implements TxcService {
    private static final Logger log = LoggerFactory.getLogger(TxcServiceImpl.class);
    private final TxcSqlExecutor txcSqlExecutor;
    private final TxcLogHelper txcLogHelper;
    private final ReliableMessenger reliableMessenger;
    private final TCGlobalContext globalContext;

    @Autowired
    public TxcServiceImpl(TxcSqlExecutor txcSqlExecutor, TxcLogHelper txcLogHelper, ReliableMessenger reliableMessenger, TCGlobalContext globalContext) {
        this.txcSqlExecutor = txcSqlExecutor;
        this.txcLogHelper = txcLogHelper;
        this.reliableMessenger = reliableMessenger;
        this.globalContext = globalContext;
    }

    private void lockDataLine(String groupId, String unitId, Set<String> lockIdSet, boolean isXLock) throws TxcLogicException {
        try {
            if (!this.reliableMessenger.acquireLocks(groupId, lockIdSet, isXLock ? 1 : 2)) {
                throw new TxcLogicException("resource is locked! place try again later.");
            }
            this.globalContext.addTxcLockId(groupId, unitId, lockIdSet);
        }
        catch (RpcException e) {
            throw new TxcLogicException("can't contact to any TM for lock info. default error.");
        }
    }

    private void saveUndoLog(String groupId, String unitId, int sqlType, TableRecordList recordList) throws TxcLogicException {
        UndoLogDO undoLogDO = new UndoLogDO();
        undoLogDO.setRollbackInfo(SqlUtils.objectToBlob(recordList));
        undoLogDO.setUnitId(unitId);
        undoLogDO.setGroupId(groupId);
        undoLogDO.setSqlType(sqlType);
        try {
            this.txcLogHelper.saveUndoLog(undoLogDO);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
    }

    private String hex(String content) {
        return DigestUtils.md5DigestAsHex((byte[])content.getBytes(StandardCharsets.UTF_8));
    }

    private void resolveModifiedRecords(List<ModifiedRecord> modifiedRecords, int sqlType) throws TxcLogicException {
        TableRecordList tableRecords = new TableRecordList();
        HashSet<String> lockIdSet = new HashSet<String>();
        for (ModifiedRecord modifiedRecord : modifiedRecords) {
            for (Map.Entry<String, FieldCluster> entry : modifiedRecord.getFieldClusters().entrySet()) {
                TableRecord tableRecord = new TableRecord();
                tableRecord.setTableName(entry.getKey());
                tableRecord.setFieldCluster(entry.getValue());
                tableRecords.getTableRecords().add(tableRecord);
                lockIdSet.add(this.hex(tableRecord.getFieldCluster().getPrimaryKeys().toString()));
            }
        }
        if (lockIdSet.isEmpty()) {
            return;
        }
        String groupId = DTXLocalContext.cur().getGroupId();
        String unitId = DTXLocalContext.cur().getUnitId();
        this.lockDataLine(groupId, unitId, lockIdSet, true);
        this.saveUndoLog(groupId, unitId, sqlType, tableRecords);
    }

    @Override
    public void lockSelect(SelectImageParams selectImageParams, boolean isxLock) throws TxcLogicException {
        Connection connection = (Connection)DTXLocalContext.cur().getResource();
        try {
            List<ModifiedRecord> modifiedRecords = this.txcSqlExecutor.selectSqlPreviousPrimaryKeys(connection, selectImageParams);
            HashSet<String> lockIdSet = new HashSet<String>();
            for (ModifiedRecord modifiedRecord : modifiedRecords) {
                for (Map.Entry<String, FieldCluster> entry : modifiedRecord.getFieldClusters().entrySet()) {
                    FieldCluster v = entry.getValue();
                    lockIdSet.add(this.hex(v.getPrimaryKeys().toString()));
                }
            }
            this.lockDataLine(DTXLocalContext.cur().getGroupId(), DTXLocalContext.cur().getUnitId(), lockIdSet, isxLock);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
    }

    @Override
    public void resolveUpdateImage(UpdateImageParams updateImageParams) throws TxcLogicException {
        List<ModifiedRecord> modifiedRecords;
        Connection connection = (Connection)DTXLocalContext.cur().getResource();
        try {
            modifiedRecords = this.txcSqlExecutor.updateSqlPreviousData(connection, updateImageParams);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
        this.resolveModifiedRecords(modifiedRecords, 3);
    }

    @Override
    public void resolveDeleteImage(DeleteImageParams deleteImageParams) throws TxcLogicException {
        List<ModifiedRecord> modifiedRecords;
        Connection connection = (Connection)DTXLocalContext.cur().getResource();
        try {
            modifiedRecords = this.txcSqlExecutor.deleteSqlPreviousData(connection, deleteImageParams);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
        this.resolveModifiedRecords(modifiedRecords, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resolveInsertImage(InsertImageParams insertImageParams) throws TxcLogicException {
        ArrayList<FieldValue> primaryKeys = new ArrayList<FieldValue>();
        FieldCluster fieldCluster = new FieldCluster();
        fieldCluster.setPrimaryKeys(primaryKeys);
        ResultSet resultSet = null;
        try {
            resultSet = insertImageParams.getStatement().getGeneratedKeys();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            for (int i = 0; i < insertImageParams.getPrimaryKeyValuesList().size(); ++i) {
                Map<String, Object> pks = insertImageParams.getPrimaryKeyValuesList().get(i);
                for (String key : insertImageParams.getFullyQualifiedPrimaryKeys()) {
                    FieldValue fieldValue = new FieldValue();
                    fieldValue.setFieldName(key);
                    if (pks.containsKey(key)) {
                        fieldValue.setValue(pks.get(key));
                    } else if (Objects.nonNull(resultSet)) {
                        try {
                            resultSet.next();
                            fieldValue.setValue(resultSet.getObject(1));
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                    primaryKeys.add(fieldValue);
                }
            }
        }
        finally {
            try {
                DbUtils.close((ResultSet)resultSet);
            }
            catch (SQLException i) {}
        }
        TableRecordList tableRecords = new TableRecordList();
        tableRecords.getTableRecords().add(new TableRecord(insertImageParams.getTableName(), fieldCluster));
        this.saveUndoLog(DTXLocalContext.cur().getGroupId(), DTXLocalContext.cur().getUnitId(), 1, tableRecords);
    }

    @Override
    public void cleanTxc(String groupId, String unitId) throws TxcLogicException {
        try {
            this.reliableMessenger.releaseLocks(this.globalContext.findTxcLockSet(groupId, unitId));
        }
        catch (RpcException e) {
            throw new TxcLogicException((Throwable)e);
        }
        catch (TCGlobalContextException e) {
            // empty catch block
        }
        try {
            this.txcLogHelper.deleteUndoLog(groupId, unitId);
        }
        catch (SQLException e) {
            throw new TxcLogicException((Throwable)e);
        }
    }

    @Override
    public void undo(String groupId, String unitId) throws TxcLogicException {
        DTXLocalContext.makeUnProxy();
        ArrayList<StatementInfo> statementInfoList = new ArrayList<StatementInfo>();
        try {
            List<UndoLogDO> undoLogDOList = this.txcLogHelper.getUndoLogByGroupAndUnitId(groupId, unitId);
            for (UndoLogDO undoLogDO : undoLogDOList) {
                TableRecordList tableRecords = SqlUtils.blobToObject(undoLogDO.getRollbackInfo(), TableRecordList.class);
                switch (undoLogDO.getSqlType()) {
                    case 3: {
                        tableRecords.getTableRecords().forEach(tableRecord -> statementInfoList.add(UndoLogAnalyser.update(tableRecord)));
                        break;
                    }
                    case 2: {
                        tableRecords.getTableRecords().forEach(tableRecord -> statementInfoList.add(UndoLogAnalyser.delete(tableRecord)));
                        break;
                    }
                    case 1: {
                        tableRecords.getTableRecords().forEach(tableRecord -> statementInfoList.add(UndoLogAnalyser.insert(tableRecord)));
                        break;
                    }
                }
            }
            this.txcSqlExecutor.applyUndoLog(statementInfoList);
        }
        catch (SQLException e) {
            TxcLogicException exception = new TxcLogicException((Throwable)e);
            exception.setAttachment(statementInfoList);
            throw exception;
        }
        finally {
            DTXLocalContext.undoProxyStatus();
        }
    }
}

