/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.core.transaction.txc.analy;

import com.codingapi.txlcn.common.exception.TxcLogicException;
import com.codingapi.txlcn.common.util.function.Supplier;
import com.codingapi.txlcn.tc.core.DTXLocalContext;
import com.codingapi.txlcn.tc.core.context.TCGlobalContext;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.PrimaryKeyListVisitor;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.TableStructAnalyser;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.SqlExecuteInterceptor;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.TxcService;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.DeleteImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.InsertImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.LockableSelect;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.SelectImageParams;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.TableStruct;
import com.codingapi.txlcn.tc.core.transaction.txc.analy.def.bean.UpdateImageParams;
import com.codingapi.txlcn.tc.support.p6spy.common.StatementInformation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.update.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TxcSqlExecuteInterceptor
implements SqlExecuteInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TxcSqlExecuteInterceptor.class);
    private final TableStructAnalyser tableStructAnalyser;
    private final TxcService txcService;
    private final TCGlobalContext globalContext;

    @Autowired
    public TxcSqlExecuteInterceptor(TableStructAnalyser tableStructAnalyser, TxcService txcService, TCGlobalContext globalContext) {
        this.tableStructAnalyser = tableStructAnalyser;
        this.txcService = txcService;
        this.globalContext = globalContext;
    }

    @Override
    public void preUpdate(Update update) throws SQLException {
        Connection connection = (Connection)DTXLocalContext.cur().getResource();
        ArrayList<String> columns = new ArrayList<String>(update.getColumns().size());
        ArrayList<String> primaryKeys = new ArrayList<String>(3);
        ArrayList<String> tables = new ArrayList<String>(update.getTables().size());
        update.getColumns().forEach(column -> {
            column.setTable((Table)update.getTables().get(0));
            columns.add(column.getFullyQualifiedName());
        });
        for (Table table : update.getTables()) {
            tables.add(table.getName());
            TableStruct tableStruct = this.globalContext.tableStruct(table.getName(), (Supplier<TableStruct, SQLException>)((Supplier)() -> this.tableStructAnalyser.analyse(connection, table.getName())));
            tableStruct.getPrimaryKeys().forEach(key -> primaryKeys.add(table.getName() + "." + key));
        }
        try {
            UpdateImageParams updateImageParams = new UpdateImageParams();
            updateImageParams.setColumns(columns);
            updateImageParams.setPrimaryKeys(primaryKeys);
            updateImageParams.setTables(tables);
            updateImageParams.setWhereSql(update.getWhere() == null ? "1=1" : update.getWhere().toString());
            this.txcService.resolveUpdateImage(updateImageParams);
        }
        catch (TxcLogicException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void preDelete(Delete delete) throws SQLException {
        Connection connection = (Connection)DTXLocalContext.cur().getResource();
        if (delete.getTables().size() == 0) {
            delete.setTables(Collections.singletonList(delete.getTable()));
        }
        ArrayList<String> tables = new ArrayList<String>(delete.getTables().size());
        ArrayList<String> primaryKeys = new ArrayList<String>(3);
        ArrayList<String> columns = new ArrayList<String>();
        for (Table table : delete.getTables()) {
            TableStruct tableStruct = this.globalContext.tableStruct(table.getName(), (Supplier<TableStruct, SQLException>)((Supplier)() -> this.tableStructAnalyser.analyse(connection, table.getName())));
            tableStruct.getColumns().forEach((k, v) -> columns.add(tableStruct.getTableName() + "." + k));
            tableStruct.getPrimaryKeys().forEach(primaryKey -> primaryKeys.add(tableStruct.getTableName() + "." + primaryKey));
            tables.add(tableStruct.getTableName());
        }
        try {
            DeleteImageParams deleteImageParams = new DeleteImageParams();
            deleteImageParams.setColumns(columns);
            deleteImageParams.setPrimaryKeys(primaryKeys);
            deleteImageParams.setTables(tables);
            deleteImageParams.setSqlWhere(delete.getWhere().toString());
            this.txcService.resolveDeleteImage(deleteImageParams);
        }
        catch (TxcLogicException e) {
            throw new SQLException(e.getMessage());
        }
    }

    @Override
    public void preInsert(Insert insert) {
    }

    @Override
    public void postInsert(StatementInformation statementInformation) throws SQLException {
        Connection connection = (Connection)DTXLocalContext.cur().getResource();
        Insert insert = (Insert)statementInformation.getAttachment();
        TableStruct tableStruct = this.globalContext.tableStruct(insert.getTable().getName(), (Supplier<TableStruct, SQLException>)((Supplier)() -> this.tableStructAnalyser.analyse(connection, insert.getTable().getName())));
        PrimaryKeyListVisitor primaryKeyListVisitor = new PrimaryKeyListVisitor(insert.getTable(), insert.getColumns(), tableStruct.getFullyQualifiedPrimaryKeys());
        insert.getItemsList().accept((ItemsListVisitor)primaryKeyListVisitor);
        try {
            InsertImageParams insertImageParams = new InsertImageParams();
            insertImageParams.setTableName(tableStruct.getTableName());
            insertImageParams.setStatement(statementInformation.getStatement());
            insertImageParams.setFullyQualifiedPrimaryKeys(tableStruct.getFullyQualifiedPrimaryKeys());
            insertImageParams.setPrimaryKeyValuesList(primaryKeyListVisitor.getPrimaryKeyValuesList());
            this.txcService.resolveInsertImage(insertImageParams);
        }
        catch (TxcLogicException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void preSelect(LockableSelect lockableSelect) throws SQLException {
        if (!lockableSelect.shouldLock()) {
            return;
        }
        if (!(lockableSelect.statement().getSelectBody() instanceof PlainSelect)) {
            throw new SQLException("non support this query when use control lock.");
        }
        PlainSelect plainSelect = (PlainSelect)lockableSelect.statement().getSelectBody();
        if (!(plainSelect.getFromItem() instanceof Table)) {
            throw new SQLException("non support this query when use control lock.");
        }
        ArrayList<String> primaryKeys = new ArrayList<String>();
        Table leftTable = (Table)plainSelect.getFromItem();
        ArrayList selectItems = new ArrayList();
        Connection connection = (Connection)DTXLocalContext.cur().getResource();
        TableStruct leftTableStruct = this.globalContext.tableStruct(leftTable.getName(), (Supplier<TableStruct, SQLException>)((Supplier)() -> this.tableStructAnalyser.analyse(connection, leftTable.getName())));
        leftTableStruct.getPrimaryKeys().forEach(primaryKey -> {
            Column column = new Column(leftTable, primaryKey);
            selectItems.add(new SelectExpressionItem((Expression)column));
            primaryKeys.add(column.getFullyQualifiedName());
        });
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                if (!join.isSimple()) continue;
                TableStruct rightTableStruct = this.globalContext.tableStruct(join.getRightItem().toString(), (Supplier<TableStruct, SQLException>)((Supplier)() -> this.tableStructAnalyser.analyse(connection, join.getRightItem().toString())));
                rightTableStruct.getPrimaryKeys().forEach(primaryKey -> {
                    Column column = new Column((Table)join.getRightItem(), primaryKey);
                    selectItems.add(new SelectExpressionItem((Expression)column));
                    primaryKeys.add(column.getFullyQualifiedName());
                });
            }
        }
        plainSelect.setSelectItems(selectItems);
        log.info("lock select sql: {}", (Object)plainSelect);
        SelectImageParams selectImageParams = new SelectImageParams();
        selectImageParams.setPrimaryKeys(primaryKeys);
        selectImageParams.setSql(plainSelect.toString());
        try {
            this.txcService.lockSelect(selectImageParams, lockableSelect.isxLock());
        }
        catch (TxcLogicException e) {
            throw new SQLException(e.getMessage());
        }
    }
}

