/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.txlcn.tc.txmsg.transaction;

import com.codingapi.txlcn.common.exception.SerializerException;
import com.codingapi.txlcn.common.exception.TxClientException;
import com.codingapi.txlcn.common.util.serializer.SerializerContext;
import com.codingapi.txlcn.tc.aspect.TransactionInfo;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLog;
import com.codingapi.txlcn.tc.corelog.aspect.AspectLogHelper;
import com.codingapi.txlcn.tc.txmsg.RpcExecuteService;
import com.codingapi.txlcn.tc.txmsg.TransactionCmd;
import com.codingapi.txlcn.txmsg.params.GetAspectLogParams;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="rpc_get-aspect-log")
public class GetAspectLogService
implements RpcExecuteService {
    private final AspectLogHelper txLogHelper;

    @Autowired
    public GetAspectLogService(AspectLogHelper txLogHelper) {
        this.txLogHelper = txLogHelper;
    }

    @Override
    public Serializable execute(TransactionCmd transactionCmd) throws TxClientException {
        try {
            GetAspectLogParams getAspectLogParams = (GetAspectLogParams)transactionCmd.getMsg().loadBean(GetAspectLogParams.class);
            AspectLog txLog = this.txLogHelper.getTxLog(getAspectLogParams.getGroupId(), getAspectLogParams.getUnitId());
            if (Objects.isNull(txLog)) {
                throw new TxClientException("non exists aspect log.");
            }
            TransactionInfo transactionInfo = (TransactionInfo)SerializerContext.getInstance().deSerialize(txLog.getBytes(), TransactionInfo.class);
            return transactionInfo.toJsonObject();
        }
        catch (SerializerException e) {
            throw new TxClientException((Throwable)e);
        }
    }
}

