/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio.protocol;

import com.corundumstudio.socketio.AckCallback;
import com.corundumstudio.socketio.MultiTypeAckCallback;
import com.corundumstudio.socketio.protocol.AckArgs;
import com.corundumstudio.socketio.protocol.Event;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.constant.Constable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonJsonSupport
implements JsonSupport {
    protected final ExBeanSerializerModifier modifier = new ExBeanSerializerModifier();
    protected final ThreadLocal<String> namespaceClass = new ThreadLocal();
    protected final ThreadLocal<AckCallback<?>> currentAckClass = new ThreadLocal();
    protected final ObjectMapper objectMapper = new ObjectMapper();
    protected final EventDeserializer eventDeserializer = new EventDeserializer();
    protected final AckArgsDeserializer ackArgsDeserializer = new AckArgsDeserializer();
    protected static final Logger log = LoggerFactory.getLogger(JacksonJsonSupport.class);

    public JacksonJsonSupport() {
        this(new Module[0]);
    }

    public JacksonJsonSupport(Module ... modules) {
        if (modules != null && modules.length > 0) {
            this.objectMapper.registerModules(modules);
        }
        this.init(this.objectMapper);
    }

    protected void init(ObjectMapper objectMapper) {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier((BeanSerializerModifier)this.modifier);
        module.addDeserializer(Event.class, (JsonDeserializer)this.eventDeserializer);
        module.addDeserializer(AckArgs.class, (JsonDeserializer)this.ackArgsDeserializer);
        objectMapper.registerModule((Module)module);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(SerializationFeature.WRITE_BIGDECIMAL_AS_PLAIN, true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }

    @Override
    public void addEventMapping(String namespaceName, String eventName, Class<?> ... eventClass) {
        this.eventDeserializer.eventMapping.put(new EventKey(namespaceName, eventName), Arrays.asList(eventClass));
    }

    @Override
    public void removeEventMapping(String namespaceName, String eventName) {
        this.eventDeserializer.eventMapping.remove(new EventKey(namespaceName, eventName));
    }

    @Override
    public <T> T readValue(String namespaceName, ByteBufInputStream src, Class<T> valueType) throws IOException {
        this.namespaceClass.set(namespaceName);
        return (T)this.objectMapper.readValue((InputStream)src, valueType);
    }

    @Override
    public AckArgs readAckArgs(ByteBufInputStream src, AckCallback<?> callback) throws IOException {
        this.currentAckClass.set(callback);
        return (AckArgs)this.objectMapper.readValue((InputStream)src, AckArgs.class);
    }

    @Override
    public void writeValue(ByteBufOutputStream out, Object value) throws IOException {
        this.modifier.getSerializer().clear();
        this.objectMapper.writeValue((OutputStream)out, value);
    }

    @Override
    public List<byte[]> getArrays() {
        return this.modifier.getSerializer().getArrays();
    }

    protected static class ExBeanSerializerModifier
    extends BeanSerializerModifier {
        private final ByteArraySerializer serializer = new ByteArraySerializer();

        protected ExBeanSerializerModifier() {
        }

        public JsonSerializer<?> modifyArraySerializer(SerializationConfig config, ArrayType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (valueType.getRawClass().equals(byte[].class)) {
                return this.serializer;
            }
            return super.modifyArraySerializer(config, valueType, beanDesc, serializer);
        }

        public ByteArraySerializer getSerializer() {
            return this.serializer;
        }
    }

    protected class EventDeserializer
    extends StdDeserializer<Event> {
        private static final long serialVersionUID = 8178797221017768689L;
        final Map<EventKey, List<Class<?>>> eventMapping;

        protected EventDeserializer() {
            super(Event.class);
            this.eventMapping = PlatformDependent.newConcurrentHashMap();
        }

        public Event deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken token;
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            String eventName = jp.nextTextValue();
            EventKey ek = new EventKey(JacksonJsonSupport.this.namespaceClass.get(), eventName);
            if (!this.eventMapping.containsKey(ek) && !this.eventMapping.containsKey(ek = new EventKey("", eventName))) {
                return new Event(eventName, Collections.emptyList());
            }
            ArrayList<Object> eventArgs = new ArrayList<Object>();
            Event event = new Event(eventName, eventArgs);
            List<Class<?>> eventClasses = this.eventMapping.get(ek);
            int i = 0;
            while ((token = jp.nextToken()) != JsonToken.END_ARRAY) {
                if (i > eventClasses.size() - 1) {
                    log.debug("Event {} has more args than declared in handler: {}", (Object)eventName, null);
                    break;
                }
                Class<?> eventClass = eventClasses.get(i);
                Object arg = mapper.readValue(jp, eventClass);
                eventArgs.add(arg);
                ++i;
            }
            return event;
        }
    }

    protected class AckArgsDeserializer
    extends StdDeserializer<AckArgs> {
        private static final long serialVersionUID = 7810461017389946707L;

        protected AckArgsDeserializer() {
            super(AckArgs.class);
        }

        public AckArgs deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ArrayList<Object> args = new ArrayList<Object>();
            AckArgs result = new AckArgs(args);
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode root = (JsonNode)mapper.readTree(jp);
            AckCallback<?> callback = JacksonJsonSupport.this.currentAckClass.get();
            Iterator iter = root.iterator();
            int i = 0;
            while (iter.hasNext()) {
                JsonNode arg;
                Class<Object> clazz = callback.getResultClass();
                if (callback instanceof MultiTypeAckCallback) {
                    MultiTypeAckCallback multiTypeAckCallback = (MultiTypeAckCallback)callback;
                    clazz = multiTypeAckCallback.getResultClasses()[i];
                }
                if ((arg = (JsonNode)iter.next()).isTextual() || arg.isBoolean()) {
                    clazz = Object.class;
                }
                Object val = mapper.treeToValue((TreeNode)arg, clazz);
                args.add(val);
                ++i;
            }
            return result;
        }
    }

    public static class EventKey {
        private String namespaceName;
        private String eventName;

        public EventKey(String namespaceName, String eventName) {
            this.namespaceName = namespaceName;
            this.eventName = eventName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.eventName == null ? 0 : this.eventName.hashCode());
            result = 31 * result + (this.namespaceName == null ? 0 : this.namespaceName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EventKey other = (EventKey)obj;
            if (this.eventName == null ? other.eventName != null : !this.eventName.equals(other.eventName)) {
                return false;
            }
            return !(this.namespaceName == null ? other.namespaceName != null : !this.namespaceName.equals(other.namespaceName));
        }
    }

    public static class ByteArraySerializer
    extends StdSerializer<byte[]> {
        private static final long serialVersionUID = 3420082888596468148L;
        private final ThreadLocal<List<byte[]>> arrays = new ThreadLocal<List<byte[]>>(){

            @Override
            protected List<byte[]> initialValue() {
                return new ArrayList<byte[]>();
            }
        };

        public ByteArraySerializer() {
            super(byte[].class);
        }

        public boolean isEmpty(byte[] value) {
            return value == null || value.length == 0;
        }

        public void serialize(byte[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            HashMap<String, Constable> map = new HashMap<String, Constable>();
            map.put("num", Integer.valueOf(this.arrays.get().size()));
            map.put("_placeholder", Boolean.valueOf(true));
            jgen.writeObject(map);
            this.arrays.get().add(value);
        }

        public void serializeWithType(byte[] value, JsonGenerator jgen, SerializerProvider provider, TypeSerializer typeSer) throws IOException, JsonGenerationException {
            this.serialize(value, jgen, provider);
        }

        public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
            ObjectNode o = this.createSchemaNode("array", true);
            ObjectNode itemSchema = this.createSchemaNode("string");
            return o.set("items", (JsonNode)itemSchema);
        }

        public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
            JsonArrayFormatVisitor v2;
            if (visitor != null && (v2 = visitor.expectArrayFormat(typeHint)) != null) {
                v2.itemsFormat(JsonFormatTypes.STRING);
            }
        }

        public List<byte[]> getArrays() {
            return this.arrays.get();
        }

        public void clear() {
            this.arrays.set(new ArrayList());
        }
    }
}

