/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.definition;

import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.utils.Preconditions;
import java.util.Comparator;

public class FieldDefinition {
    private CronFieldName fieldName;
    private FieldConstraints constraints;

    public FieldDefinition(CronFieldName fieldName, FieldConstraints constraints) {
        this.fieldName = Preconditions.checkNotNull(fieldName, "CronFieldName must not be null");
        this.constraints = Preconditions.checkNotNull(constraints, "FieldConstraints must not be null");
    }

    public CronFieldName getFieldName() {
        return this.fieldName;
    }

    public FieldConstraints getConstraints() {
        return this.constraints;
    }

    public static Comparator<FieldDefinition> createFieldDefinitionComparator() {
        return new Comparator<FieldDefinition>(){

            @Override
            public int compare(FieldDefinition o1, FieldDefinition o2) {
                return o1.getFieldName().getOrder() - o2.getFieldName().getOrder();
            }
        };
    }
}

