/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.utils.VisibleForTesting;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EveryFieldValueGenerator
extends FieldValueGenerator {
    private static final Logger log = LoggerFactory.getLogger(EveryFieldValueGenerator.class);

    public EveryFieldValueGenerator(CronField cronField) {
        super(cronField);
        log.trace(String.format("processing \"%s\" at %s", cronField.getExpression().asString(), ZonedDateTime.now()));
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        int remainder;
        if (reference >= this.cronField.getConstraints().getEndRange()) {
            throw new NoSuchValueException();
        }
        Every every = (Every)this.cronField.getExpression();
        int referenceWithoutOffset = reference - this.offset();
        int period = every.getPeriod().getValue();
        int next = reference + (period - (remainder = referenceWithoutOffset % period));
        if (next < this.cronField.getConstraints().getStartRange()) {
            return this.cronField.getConstraints().getStartRange();
        }
        if (next > this.cronField.getConstraints().getEndRange()) {
            throw new NoSuchValueException();
        }
        return next;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Every every = (Every)this.cronField.getExpression();
        int period = every.getPeriod().getValue();
        int remainder = reference % period;
        if (remainder == 0) {
            return reference - period;
        }
        return reference - remainder;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        try {
            if (start != this.offset()) {
                values.add(this.offset());
            }
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException noSuchValueException) {
            // empty catch block
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Every every = (Every)this.cronField.getExpression();
        int start = this.offset();
        return (value - start) % every.getPeriod().getValue() == 0;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Every;
    }

    @VisibleForTesting
    int offset() {
        FieldExpression expression = ((Every)this.cronField.getExpression()).getExpression();
        if (expression instanceof On) {
            return ((On)expression).getTime().getValue();
        }
        return this.cronField.getConstraints().getStartRange();
    }
}

