/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.config.data.importer;

import com.ctrip.framework.apollo.Config;
import com.ctrip.framework.apollo.ConfigService;
import com.ctrip.framework.apollo.config.data.importer.ApolloConfigDataLoaderInitializer;
import com.ctrip.framework.apollo.config.data.importer.ApolloConfigDataResource;
import com.ctrip.framework.apollo.config.data.util.Slf4jLogMessageFormatter;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySource;
import com.ctrip.framework.apollo.spring.config.ConfigPropertySourceFactory;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.BootstrapRegistry;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.context.config.ConfigData;
import org.springframework.boot.context.config.ConfigDataLoader;
import org.springframework.boot.context.config.ConfigDataLoaderContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.properties.bind.BindHandler;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertySource;

public class ApolloConfigDataLoader
implements ConfigDataLoader<ApolloConfigDataResource>,
Ordered {
    private final Log log;

    public ApolloConfigDataLoader(Log log) {
        this.log = log;
    }

    public ConfigData load(ConfigDataLoaderContext context, ApolloConfigDataResource resource) throws IOException, ConfigDataResourceNotFoundException {
        ConfigurableBootstrapContext bootstrapContext = context.getBootstrapContext();
        Binder binder = (Binder)bootstrapContext.get(Binder.class);
        BindHandler bindHandler = this.getBindHandler(context);
        bootstrapContext.registerIfAbsent(ApolloConfigDataLoaderInitializer.class, BootstrapRegistry.InstanceSupplier.from(() -> new ApolloConfigDataLoaderInitializer(this.log, binder, bindHandler, bootstrapContext)));
        ApolloConfigDataLoaderInitializer apolloConfigDataLoaderInitializer = (ApolloConfigDataLoaderInitializer)bootstrapContext.get(ApolloConfigDataLoaderInitializer.class);
        List<PropertySource<?>> initialPropertySourceList = apolloConfigDataLoaderInitializer.initApolloClient();
        bootstrapContext.registerIfAbsent(ConfigPropertySourceFactory.class, BootstrapRegistry.InstanceSupplier.from(() -> (ConfigPropertySourceFactory)SpringInjector.getInstance(ConfigPropertySourceFactory.class)));
        ConfigPropertySourceFactory configPropertySourceFactory = (ConfigPropertySourceFactory)bootstrapContext.get(ConfigPropertySourceFactory.class);
        String namespace = resource.getNamespace();
        Config config = ConfigService.getConfig((String)namespace);
        ConfigPropertySource configPropertySource = configPropertySourceFactory.getConfigPropertySource(namespace, config);
        ArrayList<Object> propertySourceList = new ArrayList<Object>();
        propertySourceList.add(configPropertySource);
        propertySourceList.addAll(initialPropertySourceList);
        this.log.debug((Object)Slf4jLogMessageFormatter.format("apollo client loaded namespace [{}]", namespace));
        return new ConfigData(propertySourceList, new ConfigData.Option[0]);
    }

    private BindHandler getBindHandler(ConfigDataLoaderContext context) {
        return (BindHandler)context.getBootstrapContext().getOrElse(BindHandler.class, null);
    }

    public int getOrder() {
        return -2147483548;
    }
}

