/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.config.data.importer;

import com.ctrip.framework.apollo.config.data.importer.ApolloConfigDataResource;
import com.ctrip.framework.apollo.config.data.util.Slf4jLogMessageFormatter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.config.ConfigDataLocationNotFoundException;
import org.springframework.boot.context.config.ConfigDataLocationResolver;
import org.springframework.boot.context.config.ConfigDataLocationResolverContext;
import org.springframework.boot.context.config.ConfigDataResourceNotFoundException;
import org.springframework.boot.context.config.Profiles;
import org.springframework.core.Ordered;
import org.springframework.util.StringUtils;

public class ApolloConfigDataLocationResolver
implements ConfigDataLocationResolver<ApolloConfigDataResource>,
Ordered {
    private static final String PREFIX = "apollo://";
    private final Log log;

    public ApolloConfigDataLocationResolver(Log log) {
        this.log = log;
    }

    public boolean isResolvable(ConfigDataLocationResolverContext context, ConfigDataLocation location) {
        return location.hasPrefix(PREFIX);
    }

    public List<ApolloConfigDataResource> resolve(ConfigDataLocationResolverContext context, ConfigDataLocation location) throws ConfigDataLocationNotFoundException, ConfigDataResourceNotFoundException {
        return Collections.emptyList();
    }

    public List<ApolloConfigDataResource> resolveProfileSpecific(ConfigDataLocationResolverContext context, ConfigDataLocation location, Profiles profiles) throws ConfigDataLocationNotFoundException {
        String namespace = location.getNonPrefixedValue(PREFIX);
        if (StringUtils.hasText((String)namespace)) {
            this.log.debug((Object)Slf4jLogMessageFormatter.format("apollo config namespace [{}]", namespace));
            return Collections.singletonList(new ApolloConfigDataResource(namespace));
        }
        this.log.debug((Object)Slf4jLogMessageFormatter.format("apollo config namespace is empty, default to [{}]", "application"));
        return Collections.singletonList(ApolloConfigDataResource.DEFAULT);
    }

    public int getOrder() {
        return -2147483548;
    }
}

