/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.internals;

import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.internals.ConfigRepository;
import com.ctrip.framework.apollo.internals.RepositoryChangeListener;
import com.ctrip.framework.apollo.tracer.Tracer;
import com.ctrip.framework.apollo.util.ExceptionUtil;
import com.ctrip.framework.apollo.util.factory.PropertiesFactory;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigRepository
implements ConfigRepository {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConfigRepository.class);
    private List<RepositoryChangeListener> m_listeners = Lists.newCopyOnWriteArrayList();
    protected PropertiesFactory propertiesFactory = ApolloInjector.getInstance(PropertiesFactory.class);

    protected boolean trySync() {
        try {
            this.sync();
            return true;
        }
        catch (Throwable ex) {
            Tracer.logEvent((String)"ApolloConfigException", (String)ExceptionUtil.getDetailMessage(ex));
            logger.warn("Sync config failed, will retry. Repository {}, reason: {}", this.getClass(), (Object)ExceptionUtil.getDetailMessage(ex));
            return false;
        }
    }

    protected abstract void sync();

    @Override
    public void addChangeListener(RepositoryChangeListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeChangeListener(RepositoryChangeListener listener) {
        this.m_listeners.remove(listener);
    }

    protected void fireRepositoryChange(String namespace, Properties newProperties) {
        for (RepositoryChangeListener listener : this.m_listeners) {
            try {
                listener.onRepositoryChange(namespace, newProperties);
            }
            catch (Throwable ex) {
                Tracer.logError((Throwable)ex);
                logger.error("Failed to invoke repository change listener {}", listener.getClass(), (Object)ex);
            }
        }
    }

    @Override
    public void initialize() {
        this.sync();
    }
}

