/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.spring.property;

import com.ctrip.framework.apollo.ConfigChangeListener;
import com.ctrip.framework.apollo.build.ApolloInjector;
import com.ctrip.framework.apollo.core.utils.StringUtils;
import com.ctrip.framework.apollo.model.ConfigChangeEvent;
import com.ctrip.framework.apollo.spring.annotation.ApolloJsonValue;
import com.ctrip.framework.apollo.spring.events.ApolloConfigChangeEvent;
import com.ctrip.framework.apollo.spring.property.PlaceholderHelper;
import com.ctrip.framework.apollo.spring.property.SpringValue;
import com.ctrip.framework.apollo.spring.property.SpringValueRegistry;
import com.ctrip.framework.apollo.spring.util.SpringInjector;
import com.ctrip.framework.apollo.util.ConfigUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.CollectionUtils;

public class AutoUpdateConfigChangeListener
implements ConfigChangeListener,
ApplicationListener<ApolloConfigChangeEvent>,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(AutoUpdateConfigChangeListener.class);
    private final boolean typeConverterHasConvertIfNecessaryWithFieldParameter = this.testTypeConverterHasConvertIfNecessaryWithFieldParameter();
    private ConfigurableBeanFactory beanFactory;
    private TypeConverter typeConverter;
    private final PlaceholderHelper placeholderHelper = SpringInjector.getInstance(PlaceholderHelper.class);
    private final SpringValueRegistry springValueRegistry = SpringInjector.getInstance(SpringValueRegistry.class);
    private final Map<String, Gson> datePatternGsonMap = new ConcurrentHashMap<String, Gson>();
    private final ConfigUtil configUtil = ApolloInjector.getInstance(ConfigUtil.class);

    @Override
    public void onChange(ConfigChangeEvent changeEvent) {
        Set<String> keys = changeEvent.changedKeys();
        if (CollectionUtils.isEmpty(keys)) {
            return;
        }
        for (String key : keys) {
            Collection<SpringValue> targetValues = this.springValueRegistry.get((BeanFactory)this.beanFactory, key);
            if (targetValues == null || targetValues.isEmpty()) continue;
            for (SpringValue val : targetValues) {
                this.updateSpringValue(val);
            }
        }
    }

    private void updateSpringValue(SpringValue springValue) {
        try {
            Object value = this.resolvePropertyValue(springValue);
            springValue.update(value);
            logger.info("Auto update apollo changed value successfully, new value: {}, {}", value, (Object)springValue);
        }
        catch (Throwable ex) {
            logger.error("Auto update apollo changed value failed, {}", (Object)springValue.toString(), (Object)ex);
        }
    }

    private Object resolvePropertyValue(SpringValue springValue) {
        Object value = this.placeholderHelper.resolvePropertyValue(this.beanFactory, springValue.getBeanName(), springValue.getPlaceholder());
        if (springValue.isJson()) {
            ApolloJsonValue apolloJsonValue = springValue.isField() ? springValue.getField().getAnnotation(ApolloJsonValue.class) : (ApolloJsonValue)springValue.getMethodParameter().getMethodAnnotation(ApolloJsonValue.class);
            String datePattern = apolloJsonValue != null ? apolloJsonValue.datePattern() : "";
            value = this.parseJsonValue((String)value, springValue.getGenericType(), datePattern);
        } else {
            value = springValue.isField() ? (this.typeConverterHasConvertIfNecessaryWithFieldParameter ? this.typeConverter.convertIfNecessary(value, springValue.getTargetType(), springValue.getField()) : this.typeConverter.convertIfNecessary(value, springValue.getTargetType())) : this.typeConverter.convertIfNecessary(value, springValue.getTargetType(), springValue.getMethodParameter());
        }
        return value;
    }

    private Object parseJsonValue(String json, Type targetType, String datePattern) {
        try {
            return this.datePatternGsonMap.computeIfAbsent(datePattern, this::buildGson).fromJson(json, targetType);
        }
        catch (Throwable ex) {
            logger.error("Parsing json '{}' to type {} failed!", new Object[]{json, targetType, ex});
            throw ex;
        }
    }

    private Gson buildGson(String datePattern) {
        if (StringUtils.isBlank((String)datePattern)) {
            return new Gson();
        }
        return new GsonBuilder().setDateFormat(datePattern).create();
    }

    private boolean testTypeConverterHasConvertIfNecessaryWithFieldParameter() {
        try {
            TypeConverter.class.getMethod("convertIfNecessary", Object.class, Class.class, Field.class);
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = ((ConfigurableApplicationContext)applicationContext).getBeanFactory();
        this.typeConverter = this.beanFactory.getTypeConverter();
    }

    public void onApplicationEvent(ApolloConfigChangeEvent event) {
        if (!this.configUtil.isAutoUpdateInjectedSpringPropertiesEnabled()) {
            return;
        }
        this.onChange(event.getConfigChangeEvent());
    }
}

