/*
 * Decompiled with CFR 0.152.
 */
package com.ctrip.framework.apollo.openapi.client.service;

import com.ctrip.framework.apollo.openapi.client.service.AbstractOpenApiService;
import com.ctrip.framework.apollo.openapi.dto.OpenClusterDTO;
import com.google.common.base.Strings;
import com.google.gson.Gson;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class ClusterOpenApiService
extends AbstractOpenApiService {
    public ClusterOpenApiService(CloseableHttpClient client, String baseUrl, Gson gson) {
        super(client, baseUrl, gson);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenClusterDTO getCluster(String appId, String env, String clusterName) {
        this.checkNotEmpty(appId, "App id");
        this.checkNotEmpty(env, "Env");
        if (Strings.isNullOrEmpty((String)clusterName)) {
            clusterName = "default";
        }
        String path = String.format("envs/%s/apps/%s/clusters/%s", this.escapePath(env), this.escapePath(appId), this.escapePath(clusterName));
        try (CloseableHttpResponse response = this.get(path);){
            OpenClusterDTO openClusterDTO = (OpenClusterDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenClusterDTO.class);
            return openClusterDTO;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Get cluster for appId: %s, cluster: %s in env: %s failed", appId, clusterName, env), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenClusterDTO createCluster(String env, OpenClusterDTO openClusterDTO) {
        this.checkNotEmpty(openClusterDTO.getAppId(), "App id");
        this.checkNotEmpty(env, "Env");
        this.checkNotEmpty(openClusterDTO.getName(), "Cluster name");
        this.checkNotEmpty(openClusterDTO.getDataChangeCreatedBy(), "Created by");
        String path = String.format("envs/%s/apps/%s/clusters", this.escapePath(env), this.escapePath(openClusterDTO.getAppId()));
        try (CloseableHttpResponse response = this.post(path, openClusterDTO);){
            OpenClusterDTO openClusterDTO2 = (OpenClusterDTO)this.gson.fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), OpenClusterDTO.class);
            return openClusterDTO2;
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format("Create cluster: %s for appId: %s in env: %s failed", openClusterDTO.getName(), openClusterDTO.getAppId(), env), ex);
        }
    }
}

