/*
 * Decompiled with CFR 0.152.
 */
package com.dtsx.astra.sdk.streaming;

import com.dtsx.astra.sdk.AbstractApiClient;
import com.dtsx.astra.sdk.streaming.domain.StreamingRegion;
import com.dtsx.astra.sdk.utils.ApiLocator;
import com.dtsx.astra.sdk.utils.ApiResponse;
import com.dtsx.astra.sdk.utils.AstraEnvironment;
import com.dtsx.astra.sdk.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class RegionsClient
extends AbstractApiClient {
    private static final TypeReference<ApiResponse<Map<String, Map<String, List<StreamingRegion>>>>> TYPE_LIST_REGIONS = new TypeReference<ApiResponse<Map<String, Map<String, List<StreamingRegion>>>>>(){};
    private static final String JSON_ORGANIZATION = "organization";
    private static final String JSON_SERVERLESS_REGIONS = "availableServerlessRegions";

    public RegionsClient(String token) {
        this(token, AstraEnvironment.PROD);
    }

    public RegionsClient(String token, AstraEnvironment env) {
        super(token, env);
    }

    public Stream<StreamingRegion> findAllServerless() {
        Map<String, Map<String, List<StreamingRegion>>> res = JsonUtils.unmarshallType(this.GET(this.getApiDevopsEndpointRegionsServerless()).getBody(), TYPE_LIST_REGIONS).getData();
        if (null != res && null != res.get(JSON_ORGANIZATION) && null != res.get(JSON_ORGANIZATION).get(JSON_SERVERLESS_REGIONS)) {
            return res.get(JSON_ORGANIZATION).get(JSON_SERVERLESS_REGIONS).stream();
        }
        return Stream.of(new StreamingRegion[0]);
    }

    public String getApiDevopsEndpointRegionsServerless() {
        return ApiLocator.getApiDevopsEndpoint(this.environment) + "/streaming/serverless-regions";
    }
}

