/*
 * Decompiled with CFR 0.152.
 */
package io.stargate.sdk.loadbalancer;

import io.stargate.sdk.loadbalancer.LoadBalancedResource;
import io.stargate.sdk.loadbalancer.LoadBalancingPolicy;
import io.stargate.sdk.loadbalancer.NoneResourceAvailableException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loadbalancer<RSC> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Loadbalancer.class);
    private static final double HUNDRED = 100.0;
    private static final int THOUSAND = 1000;
    private double totalCount = 0.0;
    private double globalCount = 0.0;
    private int unavailableCount = 0;
    private int unavailabilityPeriod = 10;
    private final LoadBalancingPolicy lbPolicy;
    private List<LoadBalancedResource<RSC>> resources = new ArrayList<LoadBalancedResource<RSC>>();

    public Loadbalancer(RSC ... lst) {
        this(LoadBalancingPolicy.ROUND_ROBIN, lst);
    }

    public Loadbalancer(LoadBalancingPolicy policy, List<LoadBalancedResource<RSC>> listRsc) {
        this.lbPolicy = policy;
        this.resources = listRsc;
        Collections.sort(this.resources);
    }

    public Loadbalancer(LoadBalancingPolicy policy, RSC ... resources) {
        this.lbPolicy = policy;
        for (RSC rsc : resources) {
            LoadBalancedResource<RSC> lbRsc = new LoadBalancedResource<RSC>(rsc);
            lbRsc.setAvailable(true);
            lbRsc.setNbUse(0.0);
            if (this.lbPolicy == LoadBalancingPolicy.ROUND_ROBIN) {
                lbRsc.setDefaultWeight(100.0 / (double)resources.length);
            }
            lbRsc.setCurrentWeight(lbRsc.getDefaultWeight());
            this.resources.add(lbRsc);
        }
        Collections.sort(this.resources);
    }

    public final synchronized LoadBalancedResource<RSC> getLoadBalancedResource() {
        this.totalCount += 1.0;
        this.globalCount += 1.0;
        switch (this.lbPolicy) {
            case WEIGHT_LOAD_BALANCING: 
            case ROUND_ROBIN: {
                if (this.unavailableCount == this.resources.size()) {
                    throw new NoneResourceAvailableException("Cannot retrieve a resource all '" + this.unavailableCount + "' resources are down.");
                }
                for (LoadBalancedResource<RSC> rsc : this.resources) {
                    if (this.shouldEnableResource(rsc)) {
                        rsc.setAvailable(true);
                        LOGGER.info("{} has reached ends of its unavailability period, putting it back in the pool", (Object)rsc.getId());
                        this.redistributeWeights();
                        return this.getLoadBalancedResource();
                    }
                    if (!(100.0 * (rsc.getNbUse() / this.totalCount) <= rsc.getCurrentWeight())) continue;
                    rsc.setNbUse(rsc.getNbUse() + 1.0);
                    return rsc;
                }
                break;
            }
            case RANDOM: {
                return this.resources.get(new Random().nextInt(this.resources.size()));
            }
        }
        throw new NoneResourceAvailableException("Cannot retrieve a resource with round robin weights all consumed or unavailable");
    }

    public RSC get() {
        return this.getLoadBalancedResource().getResource();
    }

    private final void redistributeWeights() {
        double loadtoBalance = 0.0;
        this.totalCount = 0.0;
        this.unavailableCount = 0;
        for (LoadBalancedResource<RSC> rsc : this.resources) {
            rsc.setNbUse(0.0);
            if (rsc.isAvailable()) continue;
            ++this.unavailableCount;
            loadtoBalance += rsc.getDefaultWeight();
        }
        double loadtoDistribute = loadtoBalance / Double.valueOf(this.resources.size() - this.unavailableCount);
        for (LoadBalancedResource<RSC> wrapper2 : this.resources) {
            if (wrapper2.isAvailable()) {
                wrapper2.setCurrentWeight(wrapper2.getDefaultWeight() + loadtoDistribute);
                continue;
            }
            wrapper2.setCurrentWeight(0.0);
        }
        Collections.sort(this.resources);
        LOGGER.info("Resources status after weight computation:");
        for (LoadBalancedResource<RSC> w : this.resources) {
            LOGGER.info(" + " + w.getId() + ": " + w.getCurrentWeight());
        }
    }

    private boolean shouldEnableResource(LoadBalancedResource<RSC> rsc) {
        return !rsc.isAvailable() && System.currentTimeMillis() - rsc.getUnavailabilityTriggerDate().getTime() > (long)(1000 * this.unavailabilityPeriod);
    }

    public final String toString() {
        StringBuilder strBuildDer = new StringBuilder();
        strBuildDer.append("\nLoadBalanced state : globalCount <" + this.globalCount + "> totalCount <" + this.totalCount + "> ");
        strBuildDer.append(" unavailableCount <" + this.unavailableCount + ">");
        for (LoadBalancedResource<RSC> wrapper : this.resources) {
            strBuildDer.append("\n" + wrapper.toString());
            if (!wrapper.isAvailable()) continue;
            strBuildDer.append(" currentUse " + Double.valueOf(100.0 * (wrapper.getNbUse() / this.totalCount)).intValue() + "%");
        }
        return strBuildDer.toString();
    }

    public final LoadBalancedResource<RSC> handleComponentError(LoadBalancedResource<RSC> component, Throwable parentException) {
        component.setAvailable(false);
        component.setUnavailabilityCause(parentException.getMessage());
        component.setUnavailabilityError(parentException);
        component.setUnavailabilityTriggerDate(new Date());
        this.redistributeWeights();
        return this.getLoadBalancedResource();
    }

    public final List<LoadBalancedResource<RSC>> getResourceList() {
        return this.resources;
    }

    public final double getTotalCount() {
        return this.totalCount;
    }

    public final void setTotalCount(int ptotalCount) {
        this.totalCount = ptotalCount;
    }

    public final LoadBalancingPolicy getMode() {
        return this.lbPolicy;
    }

    public final void setWrappeeElementList(List<LoadBalancedResource<RSC>> pwrappeeElementList) {
        this.resources = pwrappeeElementList;
    }

    public final int getUnavailabilityPeriod() {
        return this.unavailabilityPeriod;
    }

    public final void setUnavailabilityPeriod(int punavailabilityPeriod) {
        this.unavailabilityPeriod = punavailabilityPeriod;
    }

    public final int getUnavailableCount() {
        return this.unavailableCount;
    }

    public final void setUnavailableCount(int punavailableCount) {
        this.unavailableCount = punavailableCount;
    }

    public final double getGlobalCount() {
        return this.globalCount;
    }
}

