/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.tenant.config;

import com.diboot.core.util.S;
import java.util.List;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="diboot.tenant")
public class TenantProperties {
    private String platformCode = "00000";
    private List<String> ignoreTable;
    private List<String> ignoreTablePrefix;

    public boolean isIgnoreTable(String tableName) {
        if (this.ignoreTable != null && this.ignoreTable.stream().anyMatch(e -> e.equalsIgnoreCase(tableName))) {
            return true;
        }
        return this.ignoreTablePrefix != null && this.ignoreTablePrefix.stream().anyMatch(e -> S.startsWithIgnoreCase((CharSequence)tableName, (CharSequence)e));
    }

    @Generated
    public String getPlatformCode() {
        return this.platformCode;
    }

    @Generated
    public List<String> getIgnoreTable() {
        return this.ignoreTable;
    }

    @Generated
    public List<String> getIgnoreTablePrefix() {
        return this.ignoreTablePrefix;
    }

    @Generated
    public void setPlatformCode(String platformCode) {
        this.platformCode = platformCode;
    }

    @Generated
    public void setIgnoreTable(List<String> ignoreTable) {
        this.ignoreTable = ignoreTable;
    }

    @Generated
    public void setIgnoreTablePrefix(List<String> ignoreTablePrefix) {
        this.ignoreTablePrefix = ignoreTablePrefix;
    }
}

