/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.tenant.dto;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.diboot.core.exception.BusinessException;
import com.diboot.core.util.ContextHolder;
import com.diboot.core.util.V;
import com.diboot.iam.config.Cons;
import com.diboot.iam.dto.PwdCredential;
import com.diboot.tenant.config.TenantProperties;
import com.diboot.tenant.entity.IamTenant;
import com.diboot.tenant.service.IamTenantService;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;

public class TenantPwdCredential
extends PwdCredential {
    private static final long serialVersionUID = -5020652642432896556L;
    @NotNull(message="{validation.tenantPwdCredential.tenantCode.NotNull.message}")
    private @NotNull(message="{validation.tenantPwdCredential.tenantCode.NotNull.message}") String tenantCode;

    public TenantPwdCredential() {
        this.setAuthType(Cons.DICTCODE_AUTH_TYPE.PWD.name());
    }

    public TenantPwdCredential(String username, String password, String tenantCode) {
        super(username, password);
        this.tenantCode = tenantCode;
        this.setAuthType(Cons.DICTCODE_AUTH_TYPE.PWD.name());
    }

    public String getTenantId() {
        if (V.notEmpty((String)super.getTenantId())) {
            return super.getTenantId();
        }
        if (V.equals((Object)this.tenantCode, (Object)Objects.requireNonNull((TenantProperties)ContextHolder.getBean(TenantProperties.class)).getPlatformCode())) {
            this.setTenantId("0");
            return super.getTenantId();
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(IamTenant::getCode, (Object)this.tenantCode);
        IamTenant tenant = (IamTenant)((Object)Objects.requireNonNull((IamTenantService)ContextHolder.getBean(IamTenantService.class)).getSingleEntity((Wrapper)queryWrapper));
        if (tenant == null) {
            throw new BusinessException("exception.business.tenantPwdCredential.tenant.nonexistent", new Object[0]);
        }
        if (!Cons.DICTCODE_ACCOUNT_STATUS.A.name().equals(tenant.getStatus())) {
            throw new BusinessException("exception.business.tenantPwdCredential.tenant.unusable", new Object[0]);
        }
        LocalDate startDate = tenant.getStartDate();
        LocalDate endDate = tenant.getEndDate();
        if (V.isEmpty((Object)startDate) || V.isEmpty((Object)endDate)) {
            throw new BusinessException("exception.business.tenantPwdCredential.tenant.configFailed", new Object[0]);
        }
        LocalDate now = LocalDate.now();
        if (now.isBefore(startDate)) {
            throw new BusinessException("exception.business.tenantPwdCredential.tenant.invalid", new Object[0]);
        }
        if (now.isAfter(endDate)) {
            throw new BusinessException("exception.business.tenantPwdCredential.tenant.expired", new Object[0]);
        }
        this.setTenantId((String)((Object)tenant.getId()));
        return super.getTenantId();
    }

    public String getAuthAccount() {
        return this.getUsername();
    }

    public String getAuthSecret() {
        return this.getPassword();
    }

    @Generated
    public String getTenantCode() {
        return this.tenantCode;
    }

    @Generated
    public TenantPwdCredential setTenantCode(String tenantCode) {
        this.tenantCode = tenantCode;
        return this;
    }
}

