/*
 * Decompiled with CFR 0.152.
 */
package com.diboot.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.diboot.core.service.impl.BaseServiceImpl;
import com.diboot.core.util.V;
import com.diboot.iam.auth.IamTenantPermission;
import com.diboot.iam.entity.IamResource;
import com.diboot.iam.entity.IamUser;
import com.diboot.iam.service.IamResourceService;
import com.diboot.iam.util.IamSecurityUtils;
import com.diboot.tenant.entity.IamTenantResource;
import com.diboot.tenant.mapper.IamTenantResourceMapper;
import com.diboot.tenant.service.IamTenantResourceService;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IamTenantResourceServiceImpl
extends BaseServiceImpl<IamTenantResourceMapper, IamTenantResource>
implements IamTenantResourceService,
IamTenantPermission {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IamTenantResourceServiceImpl.class);
    @Autowired
    private IamResourceService iamResourceService;

    @Override
    public List<String> filterPermission(List<String> resourceIds) {
        IamUser currentUser = (IamUser)IamSecurityUtils.getCurrentUser();
        if (currentUser == null) {
            return Collections.emptyList();
        }
        return this.filterPermission(currentUser.getTenantId(), resourceIds);
    }

    @Override
    public List<String> filterPermission(String tenantId, List<String> resourceIds) {
        if (V.equals((Object)tenantId, (Object)"0")) {
            return resourceIds;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)queryWrapper.eq(IamTenantResource::getTenantId, (Object)tenantId)).in(IamTenantResource::getResourceId, resourceIds);
        return this.getValuesOfField((Wrapper)queryWrapper, IamTenantResource::getResourceId);
    }

    public List<String> findAllPermissions(String tenantId) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(IamTenantResource::getTenantId, (Object)tenantId);
        return this.getValuesOfField((Wrapper)queryWrapper, IamTenantResource::getResourceId);
    }

    public List<String> findAllPermissionCodes(String tenantId) {
        List<String> permissionIds = this.findAllPermissions(tenantId);
        if (V.isEmpty(permissionIds)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{IamResource::getPermissionCode}).in(IamResource::getId, permissionIds)).isNotNull(IamResource::getPermissionCode);
        return this.iamResourceService.getValuesOfField((Wrapper)queryWrapper, IamResource::getPermissionCode);
    }
}

