/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.glue.jdt;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;

public class EclipseJdtFormatterStepImpl {
    public static final String LINE_DELIMITER = "\n";
    private final CodeFormatter codeFormatter;

    public EclipseJdtFormatterStepImpl(Properties settings) {
        this.codeFormatter = ToolFactory.createCodeFormatter((Map)settings, (int)ToolFactory.M_FORMAT_EXISTING);
    }

    public String format(String raw, File file) throws Exception {
        int kind = (file.getName().equals("module-info.java") ? 128 : 8) | 0x1000;
        TextEdit edit = this.codeFormatter.format(kind, raw, 0, raw.length(), 0, LINE_DELIMITER);
        if (edit == null) {
            throw new IllegalArgumentException("Invalid java syntax for formatting.");
        }
        Document doc = new Document(raw);
        edit.apply((IDocument)doc);
        return doc.get();
    }
}

