/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import com.diffplug.spotless.MoreIterables;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class FileSignature
implements Serializable {
    private static final long serialVersionUID = 2L;
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient List<File> files;
    private final Sig[] signatures;
    private static boolean machineIsWin = System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("win");
    static final Cache cache = new Cache();

    public static FileSignature signAsList(File ... files) throws IOException {
        return FileSignature.signAsList(Arrays.asList(files));
    }

    public static FileSignature signAsList(Iterable<File> files) throws IOException {
        return new FileSignature(MoreIterables.toNullHostileList(files));
    }

    public static FileSignature signAsSet(File ... files) throws IOException {
        return FileSignature.signAsSet(Arrays.asList(files));
    }

    public static FileSignature signAsSet(Iterable<File> files) throws IOException {
        List<File> natural = MoreIterables.toSortedSet(files);
        List<File> onNameOnly = MoreIterables.toSortedSet(files, Comparator.comparing(File::getName));
        if (natural.size() != onNameOnly.size()) {
            StringBuilder builder = new StringBuilder();
            builder.append("For these files:\n");
            for (File file : files) {
                builder.append("  " + file.getAbsolutePath() + "\n");
            }
            builder.append("a caching signature is being generated, which will be based only on their\n");
            builder.append("names, not their full path (foo.txt, not C:\folder\foo.txt). Unexpectedly,\n");
            builder.append("you have two files with different paths, but the same names.  You must\n");
            builder.append("rename one of them so that all files have unique names.");
            throw new IllegalArgumentException(builder.toString());
        }
        return new FileSignature(onNameOnly);
    }

    private FileSignature(List<File> files) throws IOException {
        this.files = FileSignature.validateInputFiles(files);
        this.signatures = new Sig[this.files.size()];
        int i = 0;
        for (File file : this.files) {
            this.signatures[i] = cache.sign(file);
            ++i;
        }
    }

    public Collection<File> files() {
        return Collections.unmodifiableList(this.files);
    }

    public File getOnlyFile() {
        if (this.files.size() == 1) {
            return this.files.iterator().next();
        }
        throw new IllegalArgumentException("Expected one file, but was " + this.files.size());
    }

    public static boolean machineIsWin() {
        return machineIsWin;
    }

    public static String pathNativeToUnix(String pathNative) {
        return pathNative.replace(File.separatorChar, '/');
    }

    public static String pathUnixToNative(String pathUnix) {
        return pathUnix.replace('/', File.separatorChar);
    }

    private static List<File> validateInputFiles(List<File> files) {
        for (File file : files) {
            if (file.isFile()) continue;
            throw new IllegalArgumentException("File signature can only be created for existing regular files, given: " + file);
        }
        return files;
    }

    public static String subpath(String root, String child) {
        if (child.startsWith(root)) {
            return child.substring(root.length());
        }
        if (FileSignature.machineIsWin() && root.endsWith("://") && child.startsWith(root.substring(0, root.length() - 1))) {
            return child.substring(root.length() - 1);
        }
        throw new IllegalArgumentException("Expected '" + child + "' to start with '" + root + "'");
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static final class Sig
    implements Serializable {
        private static final long serialVersionUID = 6727302747168655222L;
        final String name;
        final long size;
        final byte[] hash;
        final transient long lastModified;

        Sig(String name, long size, byte[] hash, long lastModified) {
            this.name = name;
            this.size = size;
            this.hash = hash;
            this.lastModified = lastModified;
        }
    }

    private static final class Cache {
        Map<String, Sig> cache = new HashMap<String, Sig>();

        private Cache() {
        }

        synchronized Sig sign(File fileInput) throws IOException {
            String canonicalPath = fileInput.getCanonicalPath();
            Sig sig = this.cache.computeIfAbsent(canonicalPath, ThrowingEx.wrap(p -> {
                long lastModified;
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                File file = new File((String)p);
                long size = 0L;
                byte[] buf = new byte[1024];
                try (FileInputStream input = new FileInputStream(file);){
                    int numRead;
                    lastModified = file.lastModified();
                    while ((numRead = ((InputStream)input).read(buf)) != -1) {
                        size += (long)numRead;
                        digest.update(buf, 0, numRead);
                    }
                }
                return new Sig(file.getName(), size, digest.digest(), lastModified);
            }));
            long lastModified = fileInput.lastModified();
            if (sig.lastModified != lastModified) {
                this.cache.remove(canonicalPath);
                return this.sign(fileInput);
            }
            return sig;
        }
    }
}

