/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.rdf;

import java.io.Serializable;
import java.util.Objects;

public class RdfFormatterConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean failOnWarning = true;
    private String turtleFormatterVersion = "1.2.13";
    private boolean verify = true;

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    public boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTurtleFormatterVersion() {
        return this.turtleFormatterVersion;
    }

    public void setTurtleFormatterVersion(String turtleFormatterVersion) {
        this.turtleFormatterVersion = turtleFormatterVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RdfFormatterConfig)) {
            return false;
        }
        RdfFormatterConfig that = (RdfFormatterConfig)o;
        return this.isFailOnWarning() == that.isFailOnWarning() && Objects.equals(this.turtleFormatterVersion, that.turtleFormatterVersion);
    }

    public int hashCode() {
        return Objects.hash(this.isFailOnWarning(), this.turtleFormatterVersion);
    }

    public static class Builder {
        RdfFormatterConfig config = new RdfFormatterConfig();

        public Builder failOnWarning() {
            return this.failOnWarning(true);
        }

        public Builder failOnWarning(boolean fail) {
            this.config.setFailOnWarning(fail);
            return this;
        }

        public Builder turtleFormatterVersion(String version) {
            this.config.turtleFormatterVersion = version;
            return this;
        }

        public Builder verify(boolean verify) {
            this.config.verify = verify;
            return this;
        }

        public Builder verify() {
            this.config.verify = true;
            return this;
        }

        public RdfFormatterConfig build() {
            return this.config;
        }
    }
}

