/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;

public abstract class UUIDConverter {
    public static final UUID MIN_UUID;
    public static final JsonReader.ReadObject<UUID> READER;
    public static final JsonWriter.WriteObject<UUID> WRITER;
    private static final char[] Lookup;
    private static final byte[] Values;

    static <T> void registerDefault(DslJson<T> json) {
        json.registerReader(UUID.class, READER);
        json.registerWriter(UUID.class, WRITER);
    }

    public static void serializeNullable(@Nullable UUID value, JsonWriter sw) {
        if (value == null) {
            sw.writeNull();
        } else {
            UUIDConverter.serialize(value, sw);
        }
    }

    public static void serialize(UUID value, JsonWriter sw) {
        UUIDConverter.serialize(value.getMostSignificantBits(), value.getLeastSignificantBits(), sw);
    }

    public static void serialize(long hi, long lo, JsonWriter sw) {
        int hi1 = (int)(hi >> 32);
        int hi2 = (int)hi;
        int lo1 = (int)(lo >> 32);
        int lo2 = (int)lo;
        byte[] buf = sw.ensureCapacity(38);
        int pos = sw.size();
        buf[pos] = 34;
        int v = hi1 >> 24 & 0xFF;
        char l = Lookup[v];
        buf[pos + 1] = (byte)(l >> 8);
        buf[pos + 2] = (byte)l;
        v = hi1 >> 16 & 0xFF;
        l = Lookup[v];
        buf[pos + 3] = (byte)(l >> 8);
        buf[pos + 4] = (byte)l;
        v = hi1 >> 8 & 0xFF;
        l = Lookup[v];
        buf[pos + 5] = (byte)(l >> 8);
        buf[pos + 6] = (byte)l;
        v = hi1 & 0xFF;
        l = Lookup[v];
        buf[pos + 7] = (byte)(l >> 8);
        buf[pos + 8] = (byte)l;
        buf[pos + 9] = 45;
        v = hi2 >> 24 & 0xFF;
        l = Lookup[v];
        buf[pos + 10] = (byte)(l >> 8);
        buf[pos + 11] = (byte)l;
        v = hi2 >> 16 & 0xFF;
        l = Lookup[v];
        buf[pos + 12] = (byte)(l >> 8);
        buf[pos + 13] = (byte)l;
        buf[pos + 14] = 45;
        v = hi2 >> 8 & 0xFF;
        l = Lookup[v];
        buf[pos + 15] = (byte)(l >> 8);
        buf[pos + 16] = (byte)l;
        v = hi2 & 0xFF;
        l = Lookup[v];
        buf[pos + 17] = (byte)(l >> 8);
        buf[pos + 18] = (byte)l;
        buf[pos + 19] = 45;
        v = lo1 >> 24 & 0xFF;
        l = Lookup[v];
        buf[pos + 20] = (byte)(l >> 8);
        buf[pos + 21] = (byte)l;
        v = lo1 >> 16 & 0xFF;
        l = Lookup[v];
        buf[pos + 22] = (byte)(l >> 8);
        buf[pos + 23] = (byte)l;
        buf[pos + 24] = 45;
        v = lo1 >> 8 & 0xFF;
        l = Lookup[v];
        buf[pos + 25] = (byte)(l >> 8);
        buf[pos + 26] = (byte)l;
        v = lo1 & 0xFF;
        l = Lookup[v];
        buf[pos + 27] = (byte)(l >> 8);
        buf[pos + 28] = (byte)l;
        v = lo2 >> 24 & 0xFF;
        l = Lookup[v];
        buf[pos + 29] = (byte)(l >> 8);
        buf[pos + 30] = (byte)l;
        v = lo2 >> 16 & 0xFF;
        l = Lookup[v];
        buf[pos + 31] = (byte)(l >> 8);
        buf[pos + 32] = (byte)l;
        v = lo2 >> 8 & 0xFF;
        l = Lookup[v];
        buf[pos + 33] = (byte)(l >> 8);
        buf[pos + 34] = (byte)l;
        v = lo2 & 0xFF;
        l = Lookup[v];
        buf[pos + 35] = (byte)(l >> 8);
        buf[pos + 36] = (byte)l;
        buf[pos + 37] = 34;
        sw.advance(38);
    }

    public static UUID deserialize(JsonReader reader) throws IOException {
        char[] buf = reader.readSimpleQuote();
        int len = reader.getCurrentIndex() - reader.getTokenStart();
        if (len == 37 && buf[8] == '-' && buf[13] == '-' && buf[18] == '-' && buf[23] == '-') {
            try {
                int i;
                int i2;
                long hi = 0L;
                for (i2 = 0; i2 < 8; ++i2) {
                    hi = (hi << 4) + (long)Values[buf[i2] - 48];
                }
                for (i2 = 9; i2 < 13; ++i2) {
                    hi = (hi << 4) + (long)Values[buf[i2] - 48];
                }
                for (i2 = 14; i2 < 18; ++i2) {
                    hi = (hi << 4) + (long)Values[buf[i2] - 48];
                }
                long lo = 0L;
                for (i = 19; i < 23; ++i) {
                    lo = (lo << 4) + (long)Values[buf[i] - 48];
                }
                for (i = 24; i < 36; ++i) {
                    lo = (lo << 4) + (long)Values[buf[i] - 48];
                }
                return new UUID(hi, lo);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return UUID.fromString(new String(buf, 0, 36));
            }
        }
        if (len == 33) {
            try {
                long hi = 0L;
                for (int i = 0; i < 16; ++i) {
                    hi = (hi << 4) + (long)Values[buf[i] - 48];
                }
                long lo = 0L;
                for (int i = 16; i < 32; ++i) {
                    lo = (lo << 4) + (long)Values[buf[i] - 48];
                }
                return new UUID(hi, lo);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                return UUID.fromString(new String(buf, 0, 32));
            }
        }
        return UUID.fromString(new String(buf, 0, len - 1));
    }

    public static ArrayList<UUID> deserializeCollection(JsonReader reader) throws IOException {
        return reader.deserializeCollection(READER);
    }

    public static void deserializeCollection(JsonReader reader, Collection<UUID> res) throws IOException {
        reader.deserializeCollection(READER, res);
    }

    public static ArrayList<UUID> deserializeNullableCollection(JsonReader reader) throws IOException {
        return reader.deserializeNullableCollection(READER);
    }

    public static void deserializeNullableCollection(JsonReader reader, Collection<UUID> res) throws IOException {
        reader.deserializeNullableCollection(READER, res);
    }

    static {
        int c;
        MIN_UUID = new UUID(0L, 0L);
        READER = new JsonReader.ReadObject<UUID>(){

            @Override
            @Nullable
            public UUID read(JsonReader reader) throws IOException {
                return reader.wasNull() ? null : UUIDConverter.deserialize(reader);
            }
        };
        WRITER = (writer, value) -> UUIDConverter.serializeNullable(value, writer);
        Lookup = new char[256];
        Values = new byte[55];
        for (int i = 0; i < 256; ++i) {
            int hi = i >> 4 & 0xF;
            int lo = i & 0xF;
            UUIDConverter.Lookup[i] = (char)(((hi < 10 ? 48 + hi : 97 + hi - 10) << 8) + (lo < 10 ? 48 + lo : 97 + lo - 10));
        }
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            UUIDConverter.Values[c - 48] = (byte)(c - 48);
        }
        for (c = 97; c <= 102; c = (int)((char)(c + 1))) {
            UUIDConverter.Values[c - 48] = (byte)(c - 97 + 10);
        }
        for (c = 65; c <= 70; c = (int)((char)(c + 1))) {
            UUIDConverter.Values[c - 48] = (byte)(c - 65 + 10);
        }
    }
}

