/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.jsonb;

import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.SerializationException;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.json.bind.JsonbException;
import javax.json.bind.spi.JsonbProvider;
import javax.json.spi.JsonProvider;

public class DslJsonbProvider
extends JsonbProvider {
    public JsonbBuilder create() {
        return new DslJsonbBuilder();
    }

    private static class DslJsonb
    implements Jsonb {
        private final DslJson<Object> dslJson;
        private final ThreadLocal<JsonWriter> localWriter;

        DslJsonb(DslJson.Settings settings) {
            this.dslJson = new DslJson(settings);
            this.localWriter = ThreadLocal.withInitial(this.dslJson::newWriter);
        }

        public <T> T fromJson(String input, Class<T> as) throws JsonbException {
            return this.fromJson(input, (Type)as);
        }

        public <T> T fromJson(String input, Type type) throws JsonbException {
            if (input == null) {
                throw new JsonbException("input can't be null");
            }
            if (type == null) {
                throw new JsonbException("type can't be null");
            }
            try {
                byte[] bytes = input.getBytes("UTF-8");
                return (T)this.dslJson.deserialize(type, bytes, bytes.length);
            }
            catch (IOException e) {
                throw new JsonbException(e.getMessage(), e.getCause());
            }
        }

        public <T> T fromJson(Reader reader, Class<T> as) throws JsonbException {
            return this.fromJson(reader, (Type)as);
        }

        public <T> T fromJson(Reader reader, Type type) throws JsonbException {
            throw new JsonbException("DSL-JSON does not support Reader API. Use InputStream API instead");
        }

        public <T> T fromJson(InputStream stream, Class<T> as) throws JsonbException {
            return this.fromJson(stream, (Type)as);
        }

        public <T> T fromJson(InputStream stream, Type type) throws JsonbException {
            if (stream == null) {
                throw new JsonbException("stream can't be null");
            }
            if (type == null) {
                throw new JsonbException("type can't be null");
            }
            try {
                return (T)this.dslJson.deserialize(type, stream);
            }
            catch (IOException e) {
                throw new JsonbException(e.getMessage(), e.getCause());
            }
        }

        public String toJson(Object obj) throws JsonbException {
            try {
                JsonWriter writer = this.localWriter.get();
                writer.reset();
                this.dslJson.serialize(writer, obj);
                return new String(writer.getByteBuffer(), 0, writer.size(), "UTF-8");
            }
            catch (SerializationException | IOException ex) {
                throw new JsonbException(ex.getMessage(), ex.getCause());
            }
        }

        public String toJson(Object obj, Type type) throws JsonbException {
            if (type == null) {
                throw new JsonbException("type can't be null");
            }
            try {
                JsonWriter writer = this.localWriter.get();
                writer.reset();
                if (!this.dslJson.serialize(writer, type, obj)) {
                    throw new JsonbException("Unable to serialize provided " + type);
                }
                return new String(writer.getByteBuffer(), 0, writer.size(), "UTF-8");
            }
            catch (SerializationException | IOException ex) {
                throw new JsonbException(ex.getMessage(), ex.getCause());
            }
        }

        public void toJson(Object obj, Writer writer) throws JsonbException {
            if (writer == null) {
                throw new JsonbException("writer can't be null");
            }
            try {
                JsonWriter jw = this.localWriter.get();
                jw.reset();
                this.dslJson.serialize(jw, obj);
                writer.write(new String(jw.getByteBuffer(), 0, jw.size(), "UTF-8"));
            }
            catch (SerializationException | IOException ex) {
                throw new JsonbException(ex.getMessage(), ex.getCause());
            }
        }

        public void toJson(Object obj, Type type, Writer writer) throws JsonbException {
            if (type == null) {
                throw new JsonbException("type can't be null");
            }
            if (writer == null) {
                throw new JsonbException("writer can't be null");
            }
            try {
                JsonWriter jw = this.localWriter.get();
                jw.reset();
                if (!this.dslJson.serialize(jw, type, obj)) {
                    throw new JsonbException("Unable to serialize provided " + type);
                }
                writer.write(new String(jw.getByteBuffer(), 0, jw.size(), "UTF-8"));
            }
            catch (SerializationException | IOException ex) {
                throw new JsonbException(ex.getMessage(), ex.getCause());
            }
        }

        public void toJson(Object obj, OutputStream stream) throws JsonbException {
            if (stream == null) {
                throw new JsonbException("stream can't be null");
            }
            try {
                this.dslJson.serialize(obj, stream);
            }
            catch (SerializationException | IOException ex) {
                throw new JsonbException(ex.getMessage(), ex.getCause());
            }
        }

        public void toJson(Object obj, Type type, OutputStream stream) throws JsonbException {
            if (type == null) {
                throw new JsonbException("type can't be null");
            }
            if (stream == null) {
                throw new JsonbException("stream can't be null");
            }
            JsonWriter jw = this.localWriter.get();
            try {
                jw.reset(stream);
                if (!this.dslJson.serialize(jw, type, obj)) {
                    throw new JsonbException("Unable to serialize provided " + type);
                }
                jw.flush();
            }
            catch (SerializationException ex) {
                throw new JsonbException(ex.getMessage(), ex.getCause());
            }
            finally {
                jw.reset(null);
            }
        }

        public void close() {
        }
    }

    private static class DslJsonbBuilder
    implements JsonbBuilder {
        private final DslJson.Settings settings = Settings.withRuntime().skipDefaultValues(true).includeServiceLoader();

        private DslJsonbBuilder() {
        }

        public JsonbBuilder withConfig(JsonbConfig config) {
            config.getProperty("jsonb.null-values").ifPresent(o -> this.settings.skipDefaultValues(Boolean.FALSE.equals(o)));
            return this;
        }

        public JsonbBuilder withProvider(JsonProvider provider) {
            return this;
        }

        public Jsonb build() {
            return new DslJsonb(this.settings);
        }
    }
}

