/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.FormatConverter;
import com.dslplatform.json.runtime.InstanceFactory;
import com.dslplatform.json.runtime.Reflection;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.lang.reflect.Type;

public final class ArrayFormatDescription<B, T>
implements FormatConverter<T>,
JsonReader.BindObject<B> {
    private final Type manifest;
    private final InstanceFactory<B> newInstance;
    private final Settings.Function<B, T> finalize;
    private final boolean isEmpty;
    private final JsonWriter.WriteObject[] encoders;
    private final JsonReader.BindObject[] decoders;
    private final String startError;
    private final String endError;
    private final String countError;
    private static final Settings.Function identity = new Settings.Function(){

        public Object apply(@Nullable Object t) {
            return t;
        }
    };

    public static <D> ArrayFormatDescription<D, D> create(Class<D> manifest, InstanceFactory<D> newInstance, JsonWriter.WriteObject[] encoders, JsonReader.BindObject[] decoders) {
        return new ArrayFormatDescription(manifest, newInstance, identity, encoders, decoders);
    }

    public ArrayFormatDescription(Type manifest, InstanceFactory<B> newInstance, Settings.Function<B, T> finalize, JsonWriter.WriteObject[] encoders, JsonReader.BindObject[] decoders) {
        if (manifest == null) {
            throw new IllegalArgumentException("manifest can't be null");
        }
        if (newInstance == null) {
            throw new IllegalArgumentException("create can't be null");
        }
        if (finalize == null) {
            throw new IllegalArgumentException("finalize can't be null");
        }
        if (encoders == null) {
            throw new IllegalArgumentException("encoders can't be null or empty");
        }
        if (decoders == null) {
            throw new IllegalArgumentException("decoders can't be null");
        }
        if (encoders.length != decoders.length) {
            throw new IllegalArgumentException("decoders must match encoders (" + decoders.length + " != " + encoders.length + ")");
        }
        this.manifest = manifest;
        this.newInstance = newInstance;
        this.finalize = finalize;
        this.isEmpty = encoders.length == 0;
        this.encoders = (JsonWriter.WriteObject[])encoders.clone();
        this.decoders = (JsonReader.BindObject[])decoders.clone();
        this.startError = String.format("Expecting '[' to start decoding %s", Reflection.typeDescription(manifest));
        this.endError = String.format("Expecting ']' to end decoding %s", Reflection.typeDescription(manifest));
        this.countError = String.format("Expecting to read %d elements in the array while decoding %s", decoders.length, Reflection.typeDescription(manifest));
    }

    @Override
    public final void write(JsonWriter writer, @Nullable T instance) {
        if (instance == null) {
            writer.writeNull();
        } else {
            writer.writeByte((byte)91);
            this.writeContentFull(writer, instance);
            writer.writeByte((byte)93);
        }
    }

    @Override
    public void writeContentFull(JsonWriter writer, @Nullable T instance) {
        if (this.isEmpty) {
            return;
        }
        this.encoders[0].write(writer, instance);
        for (int i = 1; i < this.encoders.length; ++i) {
            writer.writeByte((byte)44);
            this.encoders[i].write(writer, instance);
        }
    }

    @Override
    public boolean writeContentMinimal(JsonWriter writer, @Nullable T instance) {
        this.writeContentFull(writer, instance);
        return false;
    }

    @Override
    @Nullable
    public T read(JsonReader reader) throws IOException {
        if (reader.wasNull()) {
            return null;
        }
        B instance = this.newInstance.create();
        this.bind(reader, instance);
        return this.finalize.apply(instance);
    }

    @Override
    public B bind(JsonReader reader, B instance) throws IOException {
        if (reader.last() != 91) {
            throw reader.newParseError(this.startError);
        }
        reader.getNextToken();
        this.bindContent(reader, instance);
        return instance;
    }

    @Override
    public T readContent(JsonReader reader) throws IOException {
        B instance = this.newInstance.create();
        this.bindContent(reader, instance);
        return this.finalize.apply(instance);
    }

    private void bindContent(JsonReader reader, B instance) throws IOException {
        int i;
        for (i = 0; i < this.decoders.length; ++i) {
            this.decoders[i].bind(reader, instance);
            if (reader.getNextToken() != 44) break;
            reader.getNextToken();
        }
        if (i != this.decoders.length) {
            throw reader.newParseErrorWith(this.countError, 0, this.countError, ". Read only: ", i, "");
        }
        if (reader.last() != 93) {
            throw reader.newParseError(this.endError, 1);
        }
    }
}

