/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.ParsingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;

public class DecodePropertyInfo<T> {
    public final String name;
    public final int hash;
    public final int weakHash;
    public final boolean exactName;
    public final boolean mandatory;
    public final int index;
    public final boolean nonNull;
    public final T value;
    final long mandatoryValue;
    final byte[] nameBytes;

    public DecodePropertyInfo(String name, boolean exactName, boolean mandatory, int index, boolean nonNull, T value) {
        this(name, exactName, mandatory, 0L, index, nonNull, DecodePropertyInfo.calcHash(name), DecodePropertyInfo.calcWeakHash(name), value, name.getBytes(StandardCharsets.UTF_8));
    }

    static int calcHash(String name) {
        long hash = -2128831035L;
        for (int x = 0; x < name.length(); ++x) {
            hash ^= (long)((byte)name.charAt(x));
            hash *= 16777619L;
        }
        return (int)hash;
    }

    static int calcWeakHash(String name) {
        int hash = 0;
        for (int x = 0; x < name.length(); ++x) {
            hash += (byte)name.charAt(x);
        }
        return hash;
    }

    private DecodePropertyInfo(String name, boolean exactName, boolean mandatory, long mandatoryValue, int index, boolean nonNull, int hash, int weakHash, T value, byte[] nameBytes) {
        this.name = name;
        this.exactName = exactName;
        this.mandatory = mandatory;
        this.mandatoryValue = mandatoryValue;
        this.index = index;
        this.nonNull = nonNull;
        this.hash = hash;
        this.weakHash = weakHash;
        this.value = value;
        this.nameBytes = nameBytes;
    }

    static <T> DecodePropertyInfo<T>[] prepare(DecodePropertyInfo<T>[] initial, int argumentCount) {
        DecodePropertyInfo[] decoders = (DecodePropertyInfo[])initial.clone();
        HashSet<Integer> hashes = new HashSet<Integer>();
        int mandatoryIndex = 0;
        boolean needsSorting = false;
        for (int i = 0; i < decoders.length; ++i) {
            DecodePropertyInfo ri = decoders[i];
            if (!hashes.add(ri.hash)) {
                for (int j = 0; j < decoders.length; ++j) {
                    DecodePropertyInfo si = decoders[j];
                    if (si.hash != ri.hash || si.exactName) continue;
                    decoders[j] = new DecodePropertyInfo<T>(ri.name, true, ri.mandatory, -1L, ri.index, ri.nonNull, ri.hash, ri.weakHash, ri.value, ri.nameBytes);
                }
            }
            if (ri.mandatory) {
                ri = decoders[i];
                if (mandatoryIndex > 63) {
                    throw new ConfigurationException("Only up to 64 mandatory properties are supported");
                }
                decoders[i] = new DecodePropertyInfo<T>(ri.name, ri.exactName, true, ~(1 << mandatoryIndex), ri.index, ri.nonNull, ri.hash, ri.weakHash, ri.value, ri.nameBytes);
                ++mandatoryIndex;
            }
            needsSorting = needsSorting || ri.index >= 0;
        }
        if (argumentCount != initial.length) {
            return decoders;
        }
        if (needsSorting) {
            Arrays.sort(decoders, new Comparator<DecodePropertyInfo<T>>(){

                @Override
                public int compare(DecodePropertyInfo<T> a, DecodePropertyInfo<T> b) {
                    if (b.index == -1) {
                        return -1;
                    }
                    if (a.index == -1) {
                        return 1;
                    }
                    return a.index - b.index;
                }
            });
        }
        HashMap<String, Integer> nameOrder = new HashMap<String, Integer>();
        for (int i = 0; i < decoders.length; ++i) {
            DecodePropertyInfo ri = decoders[i];
            Integer index = (Integer)nameOrder.get(ri.name);
            if (index == null) {
                index = nameOrder.size();
                nameOrder.put(ri.name, index);
            }
            decoders[i] = new DecodePropertyInfo<T>(ri.name, ri.exactName, ri.mandatory, ri.mandatoryValue, index, ri.nonNull, ri.hash, ri.weakHash, ri.value, ri.nameBytes);
        }
        return decoders;
    }

    static long calculateMandatory(DecodePropertyInfo[] decoders) {
        long flag = 0L;
        for (DecodePropertyInfo dp : decoders) {
            if (!dp.mandatory) continue;
            flag |= dp.mandatoryValue ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return flag;
    }

    static void showMandatoryError(JsonReader reader, long mandatoryFlag, DecodePropertyInfo[] decoders) throws ParsingException {
        StringBuilder sb = new StringBuilder("Mandatory ");
        sb.append(Long.bitCount(mandatoryFlag) == 1 ? "property" : "properties");
        sb.append(" (");
        for (DecodePropertyInfo ri : decoders) {
            if (!ri.mandatory || (mandatoryFlag & (ri.mandatoryValue ^ 0xFFFFFFFFFFFFFFFFL)) == 0L) continue;
            sb.append(ri.name).append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append(") not found");
        throw reader.newParseErrorAt(sb.toString(), 1);
    }
}

