/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.processor.Analysis;
import com.dslplatform.json.runtime.CompositeParameterNameExtractor;
import com.dslplatform.json.runtime.DecodePropertyInfo;
import com.dslplatform.json.runtime.Generics;
import com.dslplatform.json.runtime.GenericsMapper;
import com.dslplatform.json.runtime.ImmutableDescription;
import com.dslplatform.json.runtime.Java8ParameterNameExtractor;
import com.dslplatform.json.runtime.ObjectAnalyzer;
import com.dslplatform.json.runtime.ParameterNameExtractor;
import com.dslplatform.json.runtime.ParanamerParameterNameExtractor;
import com.dslplatform.json.runtime.Reflection;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class ImmutableAnalyzer {
    private static final Set<String> objectMethods = new HashSet<String>();
    private static final ParameterNameExtractor parameterNameExtractor;
    public static final DslJson.ConverterFactory<ImmutableDescription> CONVERTER;

    private static boolean isClassAvailable(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError ignore) {
            return false;
        }
    }

    @Nullable
    public static String[] extractNames(Method factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory can't be null");
        }
        return parameterNameExtractor.extractNames(factory);
    }

    @Nullable
    public static String[] extractNames(Constructor<?> ctor) {
        if (ctor == null) {
            throw new IllegalArgumentException("ctor can't be null");
        }
        return parameterNameExtractor.extractNames(ctor);
    }

    @Nullable
    private static <T> ImmutableDescription<T> analyze(Type manifest, final Class<T> raw, DslJson<?> json) {
        JsonWriter.WriteObject[] writeProps;
        HashMap<Type, Integer> typeIndex;
        String[] names;
        Type[] paramTypes;
        if (raw.isArray() || Collection.class.isAssignableFrom(raw) || (raw.getModifiers() & 0x400) != 0 || raw.isInterface() || raw.getDeclaringClass() != null && (raw.getModifiers() & 8) == 0 || (raw.getModifiers() & 1) == 0) {
            return null;
        }
        final Constructor<T> ctor = ImmutableAnalyzer.findBestCtor(raw, json);
        final Method factory = ImmutableAnalyzer.findBestFactory(raw, json);
        if (ctor == null && factory == null) {
            return null;
        }
        Type[] typeArray = paramTypes = factory != null ? factory.getGenericParameterTypes() : ctor.getGenericParameterTypes();
        if (paramTypes.length == 0 || paramTypes.length == 1 && ObjectAnalyzer.matchesContext(paramTypes[0], json)) {
            return null;
        }
        String[] stringArray = names = factory != null ? ImmutableAnalyzer.extractNames(factory) : ImmutableAnalyzer.extractNames(ctor);
        if (names == null) {
            typeIndex = new HashMap<Type, Integer>();
            for (Type p : paramTypes) {
                if (typeIndex.containsKey(p)) {
                    return null;
                }
                typeIndex.put(p, typeIndex.size());
            }
        } else {
            typeIndex = null;
        }
        LazyImmutableDescription lazy = new LazyImmutableDescription(json, manifest);
        JsonWriter.WriteObject oldWriter = json.registerWriter(manifest, lazy);
        JsonReader.ReadObject oldReader = json.registerReader(manifest, lazy);
        LinkedHashMap<String, JsonWriter.WriteObject> fields = new LinkedHashMap<String, JsonWriter.WriteObject>();
        LinkedHashMap<String, JsonWriter.WriteObject> methods = new LinkedHashMap<String, JsonWriter.WriteObject>();
        GenericsMapper genericMappings = GenericsMapper.create(manifest, raw);
        Object[] defArgs = ImmutableAnalyzer.findDefaultArguments(paramTypes, raw, genericMappings, json);
        int contextCount = json.context != null && Arrays.asList(defArgs).contains(json.context) ? 1 : 0;
        LinkedHashMap<String, Field> matchingFields = new LinkedHashMap<String, Field>();
        for (Field f : raw.getFields()) {
            if (!ImmutableAnalyzer.isPublicFinalNonStatic(f.getModifiers())) continue;
            matchingFields.put(f.getName(), f);
        }
        LinkedHashMap<String, Method> matchingMethods = new LinkedHashMap<String, Method>();
        for (Method mget : raw.getMethods()) {
            if (mget.getParameterTypes().length != 0) continue;
            int isBoolean = Boolean.TYPE.equals(mget.getReturnType());
            String name = Analysis.beanOrActualName(mget.getName(), isBoolean != 0);
            if (!ImmutableAnalyzer.isPublicNonStatic(mget.getModifiers()) || name.contains("$") || objectMethods.contains(name)) continue;
            matchingMethods.put(name, mget);
            if (isBoolean == 0 || name.equals(mget.getName())) continue;
            matchingMethods.put(mget.getName(), mget);
        }
        int attributesCount = paramTypes.length - contextCount;
        if (contextCount == 1 && paramTypes.length == 1) {
            return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
        }
        if (names != null) {
            int i;
            if (matchingFields.size() == attributesCount) {
                for (i = 0; i < paramTypes.length; ++i) {
                    Field f = (Field)matchingFields.get(names[i]);
                    if (f == null && json.context != null && json.context == defArgs[i] || f != null && ImmutableAnalyzer.analyzeField(json, paramTypes[i], fields, f, raw, genericMappings)) continue;
                    return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
                }
                writeProps = fields.values().toArray(new JsonWriter.WriteObject[0]);
            } else {
                for (i = 0; i < paramTypes.length; ++i) {
                    Method m = (Method)matchingMethods.get(names[i]);
                    if (m == null && json.context != null && json.context == defArgs[i] || m != null && ImmutableAnalyzer.analyzeMethod(m, json, paramTypes[i], names[i], methods, raw, genericMappings)) continue;
                    return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
                }
                writeProps = methods.values().toArray(new JsonWriter.WriteObject[0]);
            }
        } else {
            names = new String[typeIndex.size()];
            if (matchingFields.size() == attributesCount) {
                block5: for (Type p : paramTypes) {
                    for (Map.Entry kv : matchingFields.entrySet()) {
                        Field f = (Field)kv.getValue();
                        if (!ImmutableAnalyzer.analyzeField(json, p, fields, f, raw, genericMappings)) continue;
                        matchingFields.remove(kv.getKey());
                        names[((Integer)typeIndex.get((Object)p)).intValue()] = (String)kv.getKey();
                        continue block5;
                    }
                }
                if (fields.size() != attributesCount) {
                    return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
                }
                writeProps = fields.values().toArray(new JsonWriter.WriteObject[0]);
            } else {
                block7: for (Type p : paramTypes) {
                    for (Map.Entry kv : matchingMethods.entrySet()) {
                        Method m = (Method)kv.getValue();
                        if (!ImmutableAnalyzer.analyzeMethod(m, json, p, (String)kv.getKey(), methods, raw, genericMappings)) continue;
                        matchingMethods.remove(kv.getKey());
                        names[((Integer)typeIndex.get((Object)p)).intValue()] = (String)kv.getKey();
                        continue block7;
                    }
                }
                if (methods.size() != attributesCount) {
                    return ImmutableAnalyzer.unregister(manifest, json, oldWriter, oldReader);
                }
                writeProps = methods.values().toArray(new JsonWriter.WriteObject[0]);
            }
        }
        DecodePropertyInfo[] readProps = new DecodePropertyInfo[attributesCount];
        int idx = 0;
        for (int i = 0; i < paramTypes.length; ++i) {
            Type concreteType = genericMappings.makeConcrete(paramTypes[i], raw);
            if (json.context != null && defArgs[i] == json.context) continue;
            readProps[idx++] = new DecodePropertyInfo<WriteMember>(names[i], false, false, i, false, new WriteMember(json, concreteType, factory != null ? factory : ctor));
        }
        Settings.Function instanceFactory = factory != null ? new Settings.Function<Object[], T>(){

            @Override
            public T apply(@Nullable Object[] args) {
                try {
                    return factory.invoke(null, args);
                }
                catch (Exception ex) {
                    throw new ConfigurationException("Unable to create an instance of " + raw);
                }
            }
        } : new Settings.Function<Object[], T>(){

            @Override
            public T apply(@Nullable Object[] args) {
                try {
                    return raw.cast(ctor.newInstance(args));
                }
                catch (Exception ex) {
                    throw new ConfigurationException("Unable to create an instance of " + raw);
                }
            }
        };
        ImmutableDescription converter = new ImmutableDescription(manifest, defArgs, instanceFactory, writeProps, readProps, !json.omitDefaults, true);
        json.registerWriter(manifest, converter);
        json.registerReader(manifest, converter);
        lazy.resolved = converter;
        return converter;
    }

    @Nullable
    static <T> Constructor<?> findBestCtor(Class<?> raw, DslJson<T> json) {
        Map<Class<Annotation>, Boolean> creatorMarkers = json.getRegisteredCreatorMarkers();
        ArrayList ctors = new ArrayList();
        boolean hasCtorWithMarker = false;
        for (Constructor<?> ctor : raw.getDeclaredConstructors()) {
            boolean isPublic = (ctor.getModifiers() & 1) == 1;
            boolean hasMarker = false;
            if (!creatorMarkers.isEmpty()) {
                for (Map.Entry<Class<Annotation>, Boolean> kv : creatorMarkers.entrySet()) {
                    if (ctor.getAnnotation(kv.getKey()) == null || !isPublic && !kv.getValue().booleanValue()) continue;
                    if (!isPublic) {
                        try {
                            ctor.setAccessible(true);
                        }
                        catch (Exception ex) {
                            throw new ConfigurationException("Unable to promote access for private constructor " + ctor + ". Please check environment setup, or set marker on public constructor", ex);
                        }
                    }
                    hasMarker = true;
                    break;
                }
            }
            if (hasMarker) {
                hasCtorWithMarker = true;
                ctors.add(0, ctor);
                continue;
            }
            if (!isPublic) continue;
            ctors.add(ctor);
        }
        return !hasCtorWithMarker && ctors.size() != 1 ? null : (Constructor)ctors.get(0);
    }

    @Nullable
    private static <T> Method findBestFactory(Class<?> raw, DslJson<T> json) {
        Map<Class<Annotation>, Boolean> creatorMarkers = json.getRegisteredCreatorMarkers();
        if (creatorMarkers.isEmpty()) {
            return null;
        }
        for (Method factory : raw.getDeclaredMethods()) {
            int modifiers = factory.getModifiers();
            if ((modifiers & 8) != 8 || !raw.isAssignableFrom(factory.getReturnType())) continue;
            boolean isPublic = (modifiers & 1) == 1;
            for (Map.Entry<Class<Annotation>, Boolean> kv : creatorMarkers.entrySet()) {
                if (factory.getAnnotation(kv.getKey()) == null || !isPublic && !kv.getValue().booleanValue()) continue;
                if (!isPublic) {
                    try {
                        factory.setAccessible(true);
                    }
                    catch (Exception ex) {
                        throw new ConfigurationException("Unable to promote access for private factory " + factory + ". Please check environment setup, or set marker on public method", ex);
                    }
                }
                return factory;
            }
        }
        return null;
    }

    @Nullable
    private static <T> ImmutableDescription<T> unregister(Type manifest, DslJson<?> json, @Nullable JsonWriter.WriteObject oldWriter, @Nullable JsonReader.ReadObject oldReader) {
        json.registerWriter(manifest, oldWriter);
        json.registerReader(manifest, oldReader);
        return null;
    }

    private static Object[] findDefaultArguments(Type[] paramTypes, Class<?> raw, GenericsMapper genericMappings, DslJson json) {
        Object[] defArgs = new Object[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            Type concreteType = genericMappings.makeConcrete(paramTypes[i], raw);
            defArgs[i] = json.context != null && json.context.getClass().equals(concreteType) ? json.context : json.getDefault(concreteType);
        }
        return defArgs;
    }

    private static boolean analyzeField(DslJson json, Type paramType, LinkedHashMap<String, JsonWriter.WriteObject> found, Field field, Class<?> raw, GenericsMapper genericMappings) {
        Type type = field.getGenericType();
        Type concreteType = genericMappings.makeConcrete(type, raw);
        boolean isUnknown = Generics.isUnknownType(type);
        if (type.equals(paramType) && (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null)) {
            found.put(field.getName(), Settings.createEncoder(new Reflection.ReadField(field), field.getName(), json, isUnknown ? null : concreteType));
            return true;
        }
        return false;
    }

    private static boolean analyzeMethod(Method mget, DslJson json, Type paramType, String name, HashMap<String, JsonWriter.WriteObject> found, Class<?> raw, GenericsMapper genericMappings) {
        Type type = mget.getGenericReturnType();
        Type concreteType = genericMappings.makeConcrete(type, raw);
        boolean isUnknown = Generics.isUnknownType(type);
        if (type.equals(paramType) && (isUnknown || json.tryFindWriter(concreteType) != null && json.tryFindReader(concreteType) != null)) {
            found.put(name, Settings.createEncoder(new Reflection.ReadMethod(mget), name, json, isUnknown ? null : concreteType));
            return true;
        }
        return false;
    }

    private static boolean isPublicFinalNonStatic(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x100) == 0 && (modifiers & 0x10) != 0 && (modifiers & 8) == 0;
    }

    private static boolean isPublicNonStatic(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x80) == 0 && (modifiers & 0x100) == 0 && (modifiers & 8) == 0;
    }

    static {
        for (Method m : Object.class.getMethods()) {
            if (m.getParameterTypes().length != 0) continue;
            objectMethods.add(m.getName());
        }
        ArrayList<ParameterNameExtractor> extractors = new ArrayList<ParameterNameExtractor>();
        if (ImmutableAnalyzer.isClassAvailable("java.lang.reflect.Parameter")) {
            extractors.add(new Java8ParameterNameExtractor());
        }
        if (ImmutableAnalyzer.isClassAvailable("com.thoughtworks.paranamer.Paranamer")) {
            extractors.add(new ParanamerParameterNameExtractor());
        }
        parameterNameExtractor = new CompositeParameterNameExtractor(extractors);
        CONVERTER = new DslJson.ConverterFactory<ImmutableDescription>(){

            @Override
            @Nullable
            public ImmutableDescription tryCreate(Type manifest, DslJson dslJson) {
                ParameterizedType pt;
                if (manifest instanceof Class) {
                    return ImmutableAnalyzer.analyze(manifest, (Class)manifest, dslJson);
                }
                if (manifest instanceof ParameterizedType && (pt = (ParameterizedType)manifest).getActualTypeArguments().length == 1) {
                    return ImmutableAnalyzer.analyze(manifest, (Class)pt.getRawType(), dslJson);
                }
                return null;
            }
        };
    }

    private static class WriteMember
    implements JsonReader.ReadObject {
        private final DslJson json;
        private final Type type;
        private final AccessibleObject ctorOrMethod;
        private JsonReader.ReadObject decoder;

        WriteMember(DslJson json, Type type, AccessibleObject ctorOrMethod) {
            this.json = json;
            this.type = type;
            this.ctorOrMethod = ctorOrMethod;
        }

        public Object read(JsonReader reader) throws IOException {
            if (this.decoder == null) {
                this.decoder = this.json.tryFindReader(this.type);
                if (this.decoder == null) {
                    throw new ConfigurationException("Unable to find reader for " + this.type + " on " + this.ctorOrMethod);
                }
            }
            return this.decoder.read(reader);
        }
    }

    private static class LazyImmutableDescription
    implements JsonWriter.WriteObject,
    JsonReader.ReadObject {
        private final DslJson json;
        private final Type type;
        private JsonWriter.WriteObject encoder;
        private JsonReader.ReadObject decoder;
        volatile ImmutableDescription resolved;

        LazyImmutableDescription(DslJson json, Type type) {
            this.json = json;
            this.type = type;
        }

        private boolean checkSignatureNotFound() {
            ImmutableDescription local = null;
            for (int i = 0; i < 50; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new ConfigurationException(e);
                }
                local = this.resolved;
                if (local == null) continue;
                this.encoder = local;
                this.decoder = local;
                break;
            }
            return local == null;
        }

        public Object read(JsonReader reader) throws IOException {
            if (this.decoder == null && this.checkSignatureNotFound()) {
                JsonReader.ReadObject<?> tmp = this.json.tryFindReader(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find reader for " + this.type);
                }
                this.decoder = tmp;
            }
            return this.decoder.read(reader);
        }

        public void write(JsonWriter writer, @Nullable Object value) {
            if (this.encoder == null && this.checkSignatureNotFound()) {
                JsonWriter.WriteObject<?> tmp = this.json.tryFindWriter(this.type);
                if (tmp == null || tmp == this) {
                    throw new ConfigurationException("Unable to find writer for " + this.type);
                }
                this.encoder = tmp;
            }
            this.encoder.write(writer, value);
        }
    }
}

