/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.runtime.Settings;
import java.io.IOException;
import java.lang.reflect.Type;

class LazyAttributeDecoder<T, P>
implements JsonReader.BindObject<T> {
    private final Settings.BiConsumer<T, P> write;
    private JsonReader.ReadObject<P> decoder;
    private final DslJson json;
    private final Type type;

    LazyAttributeDecoder(Settings.BiConsumer<T, P> write, DslJson json, Type type) {
        if (write == null) {
            throw new IllegalArgumentException("write can't be null");
        }
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type can't be null");
        }
        this.write = write;
        this.json = json;
        this.type = type;
    }

    @Override
    public T bind(JsonReader reader, T instance) throws IOException {
        if (this.decoder == null) {
            this.decoder = this.json.tryFindReader(this.type);
            if (this.decoder == null) {
                throw new ConfigurationException("Unable to find reader for " + this.type);
            }
        }
        P attr = this.decoder.read(reader);
        this.write.accept(instance, attr);
        return instance;
    }
}

