/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.ExplicitDescription;
import java.util.Map;

public final class MapEncoder<K, V, T extends Map<K, V>>
implements JsonWriter.WriteObject<T>,
ExplicitDescription {
    private final DslJson json;
    private final boolean checkForConversionToString;
    private final JsonWriter.WriteObject<K> keyEncoder;
    private final JsonWriter.WriteObject<V> valueEncoder;
    private static final byte[] EMPTY = new byte[]{123, 125};

    public MapEncoder(DslJson json, boolean checkForConversionToString, @Nullable JsonWriter.WriteObject<K> keyEncoder, @Nullable JsonWriter.WriteObject<V> valueEncoder) {
        if (json == null) {
            throw new IllegalArgumentException("json can't be null");
        }
        this.json = json;
        this.checkForConversionToString = checkForConversionToString;
        this.keyEncoder = keyEncoder;
        this.valueEncoder = valueEncoder;
    }

    @Override
    public void write(JsonWriter writer, @Nullable T value) {
        if (value == null) {
            writer.writeNull();
        } else if (value.isEmpty()) {
            writer.writeAscii(EMPTY);
        } else if (this.keyEncoder != null && this.valueEncoder != null) {
            boolean pastFirst = false;
            writer.writeByte((byte)123);
            for (Map.Entry e : value.entrySet()) {
                if (pastFirst) {
                    writer.writeByte((byte)44);
                } else {
                    pastFirst = true;
                }
                if (this.checkForConversionToString) {
                    writer.writeQuoted(this.keyEncoder, e.getKey());
                } else {
                    this.keyEncoder.write(writer, e.getKey());
                }
                writer.writeByte((byte)58);
                this.valueEncoder.write(writer, e.getValue());
            }
            writer.writeByte((byte)125);
        } else {
            boolean pastFirst = false;
            writer.writeByte((byte)123);
            Class<?> lastKeyClass = null;
            Class<?> lastValueClass = null;
            JsonWriter.WriteObject<Object> lastKeyEncoder = this.keyEncoder;
            JsonWriter.WriteObject<?> lastValueEncoder = null;
            for (Map.Entry e : value.entrySet()) {
                if (pastFirst) {
                    writer.writeByte((byte)44);
                } else {
                    pastFirst = true;
                }
                Class<?> currentKeyClass = e.getKey().getClass();
                if ((lastKeyEncoder == null || currentKeyClass != lastKeyClass) && (lastKeyEncoder = this.json.tryFindWriter(lastKeyClass = currentKeyClass)) == null) {
                    throw new ConfigurationException("Unable to find writer for " + lastKeyClass);
                }
                writer.writeQuoted(lastKeyEncoder, e.getKey());
                writer.writeByte((byte)58);
                if (this.valueEncoder != null) {
                    this.valueEncoder.write(writer, e.getValue());
                    continue;
                }
                if (e.getValue() == null) {
                    writer.writeNull();
                    continue;
                }
                Class<?> currentValueClass = e.getValue().getClass();
                if (currentValueClass != lastValueClass && (lastValueEncoder = this.json.tryFindWriter(lastValueClass = currentValueClass)) == null) {
                    throw new ConfigurationException("Unable to find writer for " + lastValueClass);
                }
                lastValueEncoder.write(writer, e.getValue());
            }
            writer.writeByte((byte)125);
        }
    }
}

