/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.ConfigurationException;
import com.dslplatform.json.Nullable;
import com.dslplatform.json.runtime.Settings;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

abstract class Reflection {
    private static boolean canUseTypeName = true;

    Reflection() {
    }

    static String typeDescription(Type manifest) {
        if (manifest instanceof Class) {
            return ((Class)manifest).getName();
        }
        if (canUseTypeName) {
            try {
                return Reflection.tryTypeName(manifest);
            }
            catch (NoSuchMethodError ignore) {
                canUseTypeName = false;
            }
        }
        return manifest.toString();
    }

    private static String tryTypeName(Type manifest) {
        return manifest.getTypeName();
    }

    static final class SetMethod
    implements Settings.BiConsumer {
        private final Method method;

        SetMethod(Method method) {
            this.method = method;
        }

        public void accept(Object instance, @Nullable Object value) {
            try {
                this.method.invoke(instance, value);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Unable to invoke method " + this.method.getName() + " in " + this.method.getDeclaringClass() + " on object " + instance + " with an argument of type " + (value == null ? "Void" : value.getClass().getCanonicalName()), e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfigurationException("Unable to call method " + this.method.getName() + " of " + this.method.getDeclaringClass(), e);
            }
        }
    }

    static final class SetField
    implements Settings.BiConsumer {
        private final Field field;

        SetField(Field field) {
            this.field = field;
        }

        public void accept(Object instance, @Nullable Object value) {
            try {
                this.field.set(instance, value);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Unable to set field " + this.field.getName() + " in " + this.field.getDeclaringClass() + " of object " + instance + " to value of type " + (value == null ? "Void" : value.getClass().getCanonicalName()), e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Unable to set field " + this.field.getName() + " of " + this.field.getDeclaringClass(), e);
            }
        }
    }

    static final class ReadMethod
    implements Settings.Function {
        private final Method method;

        ReadMethod(Method method) {
            this.method = method;
        }

        public Object apply(@Nullable Object instance) {
            try {
                return this.method.invoke(instance, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Unable to invoke method " + this.method.getName() + " in class " + this.method.getDeclaringClass() + " for object " + instance, e);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new ConfigurationException("Unable to call method " + this.method.getName() + " of " + this.method.getDeclaringClass(), e);
            }
        }
    }

    static final class ReadField
    implements Settings.Function {
        private final Field field;

        ReadField(Field field) {
            this.field = field;
        }

        public Object apply(@Nullable Object instance) {
            try {
                return this.field.get(instance);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException("Unable to find field " + this.field.getName() + " in " + this.field.getDeclaringClass() + " for object " + instance, e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Unable to read field " + this.field.getName() + " of " + this.field.getDeclaringClass(), e);
            }
        }
    }
}

