/*
 * Decompiled with CFR 0.152.
 */
package com.dslplatform.json.runtime;

import com.dslplatform.json.JsonWriter;
import com.dslplatform.json.Nullable;

abstract class WriteDescription<T>
implements JsonWriter.WriteObject<T> {
    private final boolean alwaysSerialize;
    private final boolean isEmpty;
    private final JsonWriter.WriteObject[] encoders;

    WriteDescription(JsonWriter.WriteObject[] encoders, boolean alwaysSerialize) {
        if (encoders == null) {
            throw new IllegalArgumentException("encoders can't be null or empty");
        }
        this.encoders = (JsonWriter.WriteObject[])encoders.clone();
        this.alwaysSerialize = alwaysSerialize;
        this.isEmpty = encoders.length == 0;
    }

    @Override
    public final void write(JsonWriter writer, @Nullable T instance) {
        if (instance == null) {
            writer.writeNull();
        } else if (this.alwaysSerialize) {
            writer.writeByte((byte)123);
            this.writeContentFull(writer, instance);
            writer.writeByte((byte)125);
        } else {
            writer.writeByte((byte)123);
            if (this.writeContentMinimal(writer, instance)) {
                writer.getByteBuffer()[writer.size() - 1] = 125;
            } else {
                writer.writeByte((byte)125);
            }
        }
    }

    public final void writeContentFull(JsonWriter writer, @Nullable T instance) {
        if (this.isEmpty) {
            return;
        }
        this.encoders[0].write(writer, instance);
        for (int i = 1; i < this.encoders.length; ++i) {
            writer.writeByte((byte)44);
            this.encoders[i].write(writer, instance);
        }
    }

    public final boolean writeContentMinimal(JsonWriter writer, @Nullable T instance) {
        if (this.isEmpty) {
            return false;
        }
        int originalPos = writer.size();
        long originalFlushed = writer.flushed();
        int pos = originalPos;
        long flushed = originalFlushed;
        this.encoders[0].write(writer, instance);
        if (writer.size() != pos || writer.flushed() != flushed) {
            writer.writeByte((byte)44);
            pos = writer.size();
            flushed = writer.flushed();
        }
        for (int i = 1; i < this.encoders.length; ++i) {
            this.encoders[i].write(writer, instance);
            if (writer.size() == pos && writer.flushed() == flushed) continue;
            writer.writeByte((byte)44);
            pos = writer.size();
            flushed = writer.flushed();
        }
        return originalPos != pos || originalFlushed != flushed;
    }
}

