/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.cmss;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.cmss.SwitchConfiguration;
import com.amazonaws.services.s3.model.ListBucketsRequest;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class COSClient
extends AmazonS3Client {
    private boolean isMaster = true;
    private SwitchConfiguration switchConfiguration;
    private AmazonS3Client anonymous;
    private Timer checkHealthTimer;
    private static Log log = LogFactory.getLog(COSClient.class);

    public COSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        this(awsCredentials, clientConfiguration, null);
    }

    public COSClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, SwitchConfiguration switchConfiguration) {
        super(awsCredentials, clientConfiguration);
        this.switchConfiguration = switchConfiguration;
        if (switchConfiguration != null && switchConfiguration.isAutoSwitch()) {
            this.anonymous = new AmazonS3Client();
            this.anonymous.setEndpoint(switchConfiguration.getMasterEndpoint());
            this.setEndpoint(switchConfiguration.getMasterEndpoint());
            if (switchConfiguration.getPeriod() <= 0L) {
                this.switchConfiguration.setPeriod(5000L);
            }
        }
    }

    public void init() {
        if (this.checkHealthTimer != null) {
            return;
        }
        this.checkHealth();
        this.checkHealthTimer = new Timer();
        this.checkHealthTimer.scheduleAtFixedRate((TimerTask)new CheckHealthTask(), this.switchConfiguration.getPeriod(), this.switchConfiguration.getPeriod());
    }

    @Override
    public void shutdown() {
        this.checkHealthTimer.cancel();
        this.checkHealthTimer = null;
        this.anonymous.shutdown();
        super.shutdown();
    }

    public boolean isMaster() {
        return this.isMaster;
    }

    private void checkHealth() {
        block3: {
            try {
                this.anonymous.getS3AccountOwner();
                if (!this.isMaster) {
                    this.setEndpoint(this.switchConfiguration.getMasterEndpoint());
                    this.isMaster = true;
                    log.info((Object)"Master zone comes back, change to the master zone");
                }
            }
            catch (Exception e) {
                if (!this.isMaster) break block3;
                this.setEndpoint(this.switchConfiguration.getSlaveEndpoint());
                this.isMaster = false;
                log.info((Object)"Can't connect to the master zone, change to the slave zone");
            }
        }
    }

    private class CheckHealthTask
    extends TimerTask {
        ListBucketsRequest request = new ListBucketsRequest();

        @Override
        public void run() {
            COSClient.this.checkHealth();
        }
    }
}

