/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal;

import com.amazonaws.Request;
import com.amazonaws.services.s3.model.Callback;
import com.amazonaws.util.Base64;
import com.amazonaws.util.json.Jackson;
import java.util.Map;

public class CallbackUtils {
    public static void populateRequestCallback(Request<?> request, Callback callback) {
        if (callback != null) {
            String jsonCb = CallbackUtils.jsonizeCallback(callback);
            String base64Cb = Base64.encodeAsString((byte[])jsonCb.getBytes());
            request.addHeader("x-amz-meta-callback", base64Cb);
            if (callback.hasCallbackVar()) {
                String jsonCbVar = CallbackUtils.jsonizeCallbackVar(callback);
                String base64CbVar = Base64.encodeAsString((byte[])jsonCbVar.getBytes());
                base64CbVar = base64CbVar.replaceAll("\n", "").replaceAll("\r", "");
                request.addHeader("x-amz-meta-callback-var", base64CbVar);
            }
        }
    }

    public static String jsonizeCallback(Callback callback) {
        StringBuilder jsonBody = new StringBuilder();
        jsonBody.append("{");
        jsonBody.append("\"callbackUrl\":\"" + callback.getCallbackUrl() + "\"");
        if (callback.getCallbackHost() != null && !callback.getCallbackHost().isEmpty()) {
            jsonBody.append(",\"callbackHost\":\"" + callback.getCallbackHost() + "\"");
        }
        jsonBody.append(",\"callbackBody\":" + Jackson.toJsonString((Object)callback.getCallbackBody()));
        if (callback.getCallbackBodyType() == Callback.CallbackBodyType.JSON) {
            jsonBody.append(",\"callbackBodyType\":\"application/json\"");
        } else if (callback.getCallbackBodyType() == Callback.CallbackBodyType.URL) {
            jsonBody.append(",\"callbackBodyType\":\"application/x-www-form-urlencoded\"");
        }
        jsonBody.append("}");
        return jsonBody.toString();
    }

    public static String jsonizeCallbackVar(Callback callback) {
        StringBuilder jsonBody = new StringBuilder();
        jsonBody.append("{");
        for (Map.Entry<String, String> entry : callback.getCallbackVar().entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            if (!jsonBody.toString().equals("{")) {
                jsonBody.append(",");
            }
            jsonBody.append("\"" + entry.getKey() + "\":\"" + entry.getValue() + "\" ");
        }
        jsonBody.append("}");
        return jsonBody.toString();
    }

    public static void ensureCallbackValid(Callback callback) {
        if (callback != null) {
            CallbackUtils.assertStringNotNullOrEmpty(callback.getCallbackUrl(), "The callback url must be specified and not empty");
            CallbackUtils.assertParameterNotNull(callback.getCallbackBody(), "The callback body must be specified");
        }
    }

    private static void assertStringNotNullOrEmpty(String param, String errorMessage) {
        CallbackUtils.assertParameterNotNull(param, errorMessage);
        if (param.trim().length() == 0) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    private static void assertParameterNotNull(Object param, String errorMessage) {
        if (param == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }
}

