/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.ali.api;

import com.egzosn.pay.ali.bean.CertEnvironment;
import com.egzosn.pay.common.api.BasePayConfigStorage;
import com.egzosn.pay.common.api.CertStore;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import java.io.IOException;
import java.io.InputStream;

public class AliPayConfigStorage
extends BasePayConfigStorage {
    private String appAuthToken;
    private String appId;
    private String pid;
    private String seller;
    private Object merchantCert;
    private Object aliPayCert;
    private Object aliPayRootCert;
    private CertStore certStoreType;
    private CertEnvironment certEnvironment;

    public String getAppAuthToken() {
        return this.appAuthToken;
    }

    public void setAppAuthToken(String appAuthToken) {
        this.appAuthToken = appAuthToken;
    }

    public void setAppid(String appId) {
        this.appId = appId;
    }

    @Deprecated
    public String getAppid() {
        return this.appId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getSeller() {
        return this.seller;
    }

    public void setSeller(String seller) {
        this.seller = seller;
    }

    public Object getMerchantCert() {
        return this.merchantCert;
    }

    public void setMerchantCert(Object merchantCert) {
        this.merchantCert = merchantCert;
    }

    public Object getAliPayCert() {
        return this.aliPayCert;
    }

    public void setAliPayCert(Object aliPayCert) {
        this.aliPayCert = aliPayCert;
    }

    public Object getAliPayRootCert() {
        return this.aliPayRootCert;
    }

    public void setAliPayRootCert(Object aliPayRootCert) {
        this.aliPayRootCert = aliPayRootCert;
    }

    public CertStore getCertStoreType() {
        return this.certStoreType;
    }

    public void setCertStoreType(CertStore certStoreType) {
        this.certStoreType = certStoreType;
    }

    public CertEnvironment getCertEnvironment() {
        return this.certEnvironment;
    }

    public void setCertEnvironment(CertEnvironment certEnvironment) {
        this.certEnvironment = certEnvironment;
    }

    public void loadCertEnvironment() {
        if (!this.isCertSign() || null != this.certEnvironment) {
            return;
        }
        try (InputStream merchantCertStream = this.certStoreType.getInputStream(this.merchantCert);
             InputStream aliPayCertStream = this.certStoreType.getInputStream(this.aliPayCert);
             InputStream aliPayRootCertStream = this.certStoreType.getInputStream(this.aliPayRootCert);){
            this.certEnvironment = new CertEnvironment(merchantCertStream, aliPayCertStream, aliPayRootCertStream);
        }
        catch (IOException e) {
            throw new PayErrorException((PayError)new PayException("\u8bfb\u53d6\u8bc1\u4e66\u5f02\u5e38", e.getMessage()));
        }
    }
}

