/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.api;

import com.alibaba.fastjson.JSONObject;
import com.egzosn.pay.common.api.BasePayService;
import com.egzosn.pay.common.api.PayConfigStorage;
import com.egzosn.pay.common.api.TransferService;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.BillType;
import com.egzosn.pay.common.bean.MethodType;
import com.egzosn.pay.common.bean.NoticeParams;
import com.egzosn.pay.common.bean.NoticeRequest;
import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.bean.OrderParaStructure;
import com.egzosn.pay.common.bean.PayMessage;
import com.egzosn.pay.common.bean.PayOrder;
import com.egzosn.pay.common.bean.PayOutMessage;
import com.egzosn.pay.common.bean.RefundOrder;
import com.egzosn.pay.common.bean.TransactionType;
import com.egzosn.pay.common.bean.TransferOrder;
import com.egzosn.pay.common.bean.TransferType;
import com.egzosn.pay.common.bean.result.PayError;
import com.egzosn.pay.common.bean.result.PayException;
import com.egzosn.pay.common.exception.PayErrorException;
import com.egzosn.pay.common.http.ClientHttpRequest;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.HttpStringEntity;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.Util;
import com.egzosn.pay.common.util.XML;
import com.egzosn.pay.common.util.sign.SignTextUtils;
import com.egzosn.pay.common.util.sign.SignUtils;
import com.egzosn.pay.common.util.sign.encrypt.AES;
import com.egzosn.pay.common.util.sign.encrypt.RSA2;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.api.WxBillService;
import com.egzosn.pay.wx.api.WxPayConfigStorage;
import com.egzosn.pay.wx.api.WxRedPackService;
import com.egzosn.pay.wx.bean.RedpackOrder;
import com.egzosn.pay.wx.bean.WxPayBillType;
import com.egzosn.pay.wx.bean.WxPayError;
import com.egzosn.pay.wx.bean.WxPayMessage;
import com.egzosn.pay.wx.bean.WxRefundResult;
import com.egzosn.pay.wx.bean.WxSendredpackType;
import com.egzosn.pay.wx.bean.WxTransactionType;
import com.egzosn.pay.wx.bean.WxTransferType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public class WxPayService
extends BasePayService<WxPayConfigStorage>
implements WxRedPackService,
WxBillService,
TransferService {
    public WxPayService(WxPayConfigStorage payConfigStorage) {
        super((PayConfigStorage)payConfigStorage);
    }

    public WxPayService(WxPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super((PayConfigStorage)payConfigStorage, configStorage);
    }

    public BasePayService setPayConfigStorage(WxPayConfigStorage payConfigStorage) {
        String signType = payConfigStorage.getSignType();
        if ("HMAC-SHA256".equals(signType)) {
            payConfigStorage.setSignType("HMACSHA256");
        }
        this.payConfigStorage = payConfigStorage;
        return this;
    }

    public String getReqUrl(TransactionType transactionType) {
        return "https://api.mch.weixin.qq.com/" + (((WxPayConfigStorage)this.payConfigStorage).isTest() ? "xdc/apiv2sandbox/" : "") + transactionType.getMethod();
    }

    @Deprecated
    public boolean verify(Map<String, Object> params) {
        return this.verify(new NoticeParams(params));
    }

    public boolean verify(NoticeParams noticeParams) {
        Map params = noticeParams.getBody();
        if (params.containsKey("req_info")) {
            return true;
        }
        if (Objects.isNull(params.get("sign")) || !"SUCCESS".equals(params.get("return_code")) || !"SUCCESS".equals(params.get("result_code"))) {
            if (this.LOG.isErrorEnabled()) {
                this.LOG.error(String.format("\u5fae\u4fe1\u652f\u4ed8\u5f02\u5e38\uff1areturn_code=%s,\u53c2\u6570\u96c6=%s", params.get("return_code"), params));
            }
            return false;
        }
        return this.signVerify(params, (String)params.get("sign"));
    }

    private boolean signVerify(Map<String, Object> params, String sign) {
        return this.signVerify(params, sign, ((WxPayConfigStorage)this.payConfigStorage).isTest());
    }

    private boolean signVerify(Map<String, Object> params, String sign, boolean isTest) {
        SignUtils signUtils = SignUtils.valueOf((String)((WxPayConfigStorage)this.payConfigStorage).getSignType());
        String keyPrivate = ((WxPayConfigStorage)this.payConfigStorage).getKeyPrivate();
        if (isTest) {
            keyPrivate = this.getKeyPrivate();
        }
        String content = SignTextUtils.parameterText(params, (String)"&", (String[])new String[]{"sign", "appId"}) + "&key=" + (signUtils == SignUtils.MD5 ? "" : keyPrivate);
        return signUtils.verify(content, sign, keyPrivate, ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
    }

    private Map<String, Object> getPublicParameters() {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("appid", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
        parameters.put("mch_id", ((WxPayConfigStorage)this.payConfigStorage).getMchId());
        OrderParaStructure.loadParameters(parameters, (String)"sub_mch_id", (String)((WxPayConfigStorage)this.payConfigStorage).getSubMchId());
        OrderParaStructure.loadParameters(parameters, (String)"sub_appid", (String)((WxPayConfigStorage)this.payConfigStorage).getSubAppId());
        parameters.put("nonce_str", SignTextUtils.randomStr());
        return parameters;
    }

    public JSONObject unifiedOrder(PayOrder order) {
        Map parameters = this.getPublicParameters();
        parameters.put((String)"body", (Object)order.getSubject());
        OrderParaStructure.loadParameters(parameters, (String)"detail", (Order)order);
        parameters.put((String)"out_trade_no", (Object)order.getOutTradeNo());
        parameters.put((String)"spbill_create_ip", (Object)(StringUtils.isEmpty((CharSequence)order.getSpbillCreateIp()) ? "192.168.1.150" : order.getSpbillCreateIp()));
        parameters.put((String)"total_fee", Util.conversionCentAmount((BigDecimal)order.getPrice()));
        OrderParaStructure.loadParameters(parameters, (String)"attach", (String)order.getAddition());
        this.initNotifyUrl(parameters, (AssistOrder)order);
        parameters.put((String)"trade_type", (Object)order.getTransactionType().getType());
        if (null != order.getExpirationTime()) {
            parameters.put((String)"time_start", (Object)DateUtils.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss"));
            parameters.put((String)"time_expire", (Object)DateUtils.formatDate((Date)order.getExpirationTime(), (String)"yyyyMMddHHmmss"));
        }
        if (null != order.getCurType()) {
            parameters.put((String)"fee_type", (Object)order.getCurType().getType());
        }
        ((WxTransactionType)order.getTransactionType()).setAttribute(parameters, order);
        parameters.putAll(order.getAttrs());
        parameters = this.preOrderHandler(parameters, order);
        this.setSign(parameters);
        String requestXML = XML.getMap2Xml((Map)parameters);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("requestXML\uff1a" + requestXML);
        }
        HttpStringEntity entity = new HttpStringEntity(requestXML, ClientHttpRequest.APPLICATION_XML_UTF_8);
        JSONObject result = (JSONObject)this.requestTemplate.postForObject(this.getReqUrl(order.getTransactionType()), (Object)entity, JSONObject.class, new Object[0]);
        if (!"SUCCESS".equals(result.get((Object)"return_code")) || !"SUCCESS".equals(result.get((Object)"result_code"))) {
            throw new PayErrorException((PayError)new WxPayError(result.getString("result_code"), result.getString("return_msg"), result.toJSONString()));
        }
        return result;
    }

    public Map<String, Object> orderInfo(PayOrder order) {
        JSONObject result = this.unifiedOrder(order);
        if (this.verify(new NoticeParams(this.preOrderHandler((Map)result, order)))) {
            if (((WxTransactionType)order.getTransactionType()).isReturn()) {
                return result;
            }
            TreeMap<String, Object> params = new TreeMap<String, Object>();
            if (WxTransactionType.JSAPI == order.getTransactionType()) {
                params.put("signType", ((WxPayConfigStorage)this.payConfigStorage).getSignType());
                params.put("appId", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
                params.put("timeStamp", System.currentTimeMillis() / 1000L + "");
                params.put("nonceStr", result.get((Object)"nonce_str"));
                params.put("package", "prepay_id=" + result.get((Object)"prepay_id"));
            } else if (WxTransactionType.APP == order.getTransactionType()) {
                params.put("partnerid", ((WxPayConfigStorage)this.payConfigStorage).getPid());
                params.put("appid", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
                params.put("prepayid", result.get((Object)"prepay_id"));
                params.put("timestamp", System.currentTimeMillis() / 1000L);
                params.put("noncestr", result.get((Object)"nonce_str"));
                params.put("package", "Sign=WXPay");
            }
            String paySign = this.createSign(SignTextUtils.parameterText(params), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
            params.put(WxTransactionType.JSAPI.equals(order.getTransactionType()) ? "paySign" : "sign", paySign);
            return params;
        }
        throw new PayErrorException((PayError)new WxPayError(result.getString("return_code"), result.getString("return_msg"), "Invalid sign value"));
    }

    private Map<String, Object> setSign(Map<String, Object> parameters) {
        String signTypeStr = ((WxPayConfigStorage)this.payConfigStorage).getSignType();
        if ("HMACSHA256".equals(signTypeStr)) {
            signTypeStr = SignUtils.HMACSHA256.getName();
        }
        parameters.put("sign_type", signTypeStr);
        String sign = this.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"sign", "appId"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
        parameters.put("sign", sign);
        return parameters;
    }

    private String getKeyPrivate() {
        if (!((WxPayConfigStorage)this.payConfigStorage).isTest()) {
            return ((WxPayConfigStorage)this.payConfigStorage).getKeyPrivate();
        }
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("mch_id", ((WxPayConfigStorage)this.payConfigStorage).getMchId());
        parameters.put("nonce_str", SignTextUtils.randomStr());
        String sign = this.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"sign", "appId"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset(), false);
        parameters.put("sign", sign);
        HttpStringEntity entity = new HttpStringEntity(XML.getMap2Xml(parameters), ClientHttpRequest.APPLICATION_XML_UTF_8);
        JSONObject result = (JSONObject)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.GETSIGNKEY), (Object)entity, JSONObject.class, new Object[0]);
        if ("SUCCESS".equals(result.get((Object)"return_code"))) {
            return result.getString("sandbox_signkey");
        }
        this.LOG.error("\u83b7\u53d6sandbox_signkey\u5931\u8d25", (Throwable)new PayErrorException((PayError)new PayException(result.getString("return_code"), result.getString("return_msg"), result.toJSONString())));
        return null;
    }

    public String createSign(String content, String characterEncoding) {
        return this.createSign(content, characterEncoding, ((WxPayConfigStorage)this.payConfigStorage).isTest());
    }

    public String createSign(String content, String characterEncoding, boolean test) {
        SignUtils signType = SignUtils.valueOf((String)((WxPayConfigStorage)this.payConfigStorage).getSignType().toUpperCase());
        String keyPrivate = ((WxPayConfigStorage)this.payConfigStorage).getKeyPrivate();
        if (test) {
            keyPrivate = this.getKeyPrivate();
        }
        return signType.createSign(content + "&key=" + (signType == SignUtils.MD5 ? "" : keyPrivate), keyPrivate, characterEncoding).toUpperCase();
    }

    public Map<String, Object> getRefundNoticeParams(Map<String, Object> body) {
        String reqInfo = (String)body.get("req_info");
        if (StringUtils.isEmpty((CharSequence)reqInfo)) {
            return body;
        }
        try {
            String decrypt = AES.decrypt((String)reqInfo, (String)((WxPayConfigStorage)this.payConfigStorage).getSecretKey(), (String)((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
            JSONObject data = XML.toJSONObject((String)decrypt);
            body.putAll((Map<String, Object>)data);
            return body;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new PayErrorException((PayError)new WxPayError("FAIL", e.getMessage()), (Throwable)e);
        }
    }

    public NoticeParams getNoticeParams(NoticeRequest request) {
        TreeMap map = new TreeMap();
        try {
            Map<String, Object> body = XML.inputStream2Map((InputStream)request.getInputStream(), map);
            body = this.getRefundNoticeParams(body);
            return new NoticeParams(body);
        }
        catch (IOException e) {
            throw new PayErrorException((PayError)new PayException("IOException", e.getMessage()));
        }
    }

    public PayOutMessage getPayOutMessage(String code, String message) {
        return PayOutMessage.XML().code(code.toUpperCase()).content(message).build();
    }

    public PayOutMessage successPayOutMessage(PayMessage payMessage) {
        return PayOutMessage.XML().code("SUCCESS").content("\u6210\u529f").build();
    }

    public String buildRequest(Map<String, Object> orderInfo, MethodType method) {
        if (!"SUCCESS".equals(orderInfo.get("return_code"))) {
            throw new PayErrorException((PayError)new WxPayError((String)orderInfo.get("return_code"), (String)orderInfo.get("return_msg")));
        }
        if (WxTransactionType.MWEB.name().equals(orderInfo.get("trade_type"))) {
            return String.format("<script type=\"text/javascript\">location.href=\"%s%s\"</script>", orderInfo.get("mweb_url"), StringUtils.isEmpty((CharSequence)((WxPayConfigStorage)this.payConfigStorage).getReturnUrl()) ? "" : "&redirect_url=" + URLEncoder.encode(((WxPayConfigStorage)this.payConfigStorage).getReturnUrl()));
        }
        throw new UnsupportedOperationException();
    }

    public String getQrPay(PayOrder order) {
        order.setTransactionType((TransactionType)WxTransactionType.NATIVE);
        Map<String, Object> orderInfo = this.orderInfo(order);
        if (!"SUCCESS".equals(orderInfo.get("result_code"))) {
            throw new PayErrorException((PayError)new WxPayError((String)orderInfo.get("err_code"), orderInfo.toString()));
        }
        return (String)orderInfo.get("code_url");
    }

    public Map<String, Object> microPay(PayOrder order) {
        if (null == order.getTransactionType()) {
            order.setTransactionType((TransactionType)WxTransactionType.MICROPAY);
        } else if (WxTransactionType.MICROPAY != order.getTransactionType() && WxTransactionType.FACEPAY != order.getTransactionType()) {
            throw new PayErrorException((PayError)new PayException("-1", "\u9519\u8bef\u7684\u4ea4\u6613\u7c7b\u578b:" + order.getTransactionType()));
        }
        return this.orderInfo(order);
    }

    public Map<String, Object> query(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.QUERY);
    }

    public Map<String, Object> query(AssistOrder assistOrder) {
        return this.secondaryInterface(assistOrder.getTradeNo(), assistOrder.getOutTradeNo(), WxTransactionType.QUERY);
    }

    public Map<String, Object> close(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.CLOSE);
    }

    public Map<String, Object> close(AssistOrder assistOrder) {
        return this.secondaryInterface(assistOrder.getTradeNo(), assistOrder.getOutTradeNo(), WxTransactionType.CLOSE);
    }

    public Map<String, Object> cancel(String transactionId, String outTradeNo) {
        return this.secondaryInterface(transactionId, outTradeNo, WxTransactionType.REVERSE);
    }

    private Map<String, Object> initNotifyUrl(Map<String, Object> parameters, AssistOrder order) {
        OrderParaStructure.loadParameters(parameters, (String)"notify_url", (String)((WxPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        OrderParaStructure.loadParameters(parameters, (String)"notify_url", (String)order.getNotifyUrl());
        OrderParaStructure.loadParameters(parameters, (String)"notify_url", (Order)order);
        return parameters;
    }

    public WxRefundResult refund(RefundOrder refundOrder) {
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"transaction_id", (String)refundOrder.getTradeNo());
        OrderParaStructure.loadParameters(parameters, (String)"out_trade_no", (String)refundOrder.getOutTradeNo());
        OrderParaStructure.loadParameters(parameters, (String)"out_refund_no", (String)refundOrder.getRefundNo());
        parameters.put("total_fee", Util.conversionCentAmount((BigDecimal)refundOrder.getTotalAmount()));
        parameters.put("refund_fee", Util.conversionCentAmount((BigDecimal)refundOrder.getRefundAmount()));
        this.initNotifyUrl(parameters, (AssistOrder)refundOrder);
        if (null != refundOrder.getCurType()) {
            parameters.put("refund_fee_type", refundOrder.getCurType().getType());
        }
        OrderParaStructure.loadParameters(parameters, (String)"refund_desc", (String)refundOrder.getDescription());
        parameters.putAll(refundOrder.getAttrs());
        this.setSign(parameters);
        return WxRefundResult.create((Map)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.REFUND), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]));
    }

    public Map<String, Object> refundquery(RefundOrder refundOrder) {
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"transaction_id", (String)refundOrder.getTradeNo());
        OrderParaStructure.loadParameters(parameters, (String)"out_trade_no", (String)refundOrder.getOutTradeNo());
        OrderParaStructure.loadParameters(parameters, (String)"out_refund_no", (String)refundOrder.getRefundNo());
        this.setSign(parameters);
        return (Map)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.REFUNDQUERY), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> downloadBill(Date billDate, String billType) {
        return this.downloadBill(billDate, WxPayBillType.valueOf(billType));
    }

    public Map<String, Object> downloadBill(Date billDate, BillType billType) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("bill_type", billType.getType());
        parameters.put("bill_date", DateUtils.formatDate((Date)billDate, (String)"yyyyMMdd"));
        String fileType = billType.getFileType();
        OrderParaStructure.loadParameters(parameters, (String)"tar_type", (String)fileType);
        this.setSign(parameters);
        HashMap<String, Object> ret = new HashMap<String, Object>(3);
        ret.put("return_code", "SUCCESS");
        ret.put("return_msg", "ok");
        if (StringUtils.isEmpty((CharSequence)fileType)) {
            String respStr = (String)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.DOWNLOADBILL), (Object)XML.getMap2Xml(parameters), String.class, new Object[0]);
            if (respStr.indexOf("<") == 0) {
                return XML.toJSONObject((String)respStr);
            }
            ret.put("data", respStr);
            return ret;
        }
        InputStream respStream = (InputStream)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.DOWNLOADBILL), (Object)XML.getMap2Xml(parameters), InputStream.class, new Object[0]);
        ret.put("data", respStream);
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Deprecated
    public Map<String, Object> downloadbill(Date billDate, String billType, String path) {
        Map<String, Object> parameters = this.getDownloadBillParam(billDate, billType, true);
        this.setSign(parameters);
        InputStream inputStream = (InputStream)this.requestTemplate.postForObject(this.getReqUrl(WxTransactionType.DOWNLOADBILL), (Object)XML.getMap2Xml(parameters), InputStream.class, new Object[0]);
        try (InputStream fileIs = WxPayService.uncompress(inputStream);){
            this.writeToLocal(path + DateUtils.formatDate((Date)new Date(), (String)"yyyyMM") + "/" + DateUtils.formatDate((Date)new Date(), (String)"yyyyMMddHHmmss") + ".txt", fileIs);
            HashMap<String, Object> ret = new HashMap<String, Object>(3);
            ret.put("return_code", "SUCCESS");
            ret.put("return_msg", "ok");
            ret.put("data", path);
            HashMap<String, Object> hashMap = ret;
            return hashMap;
        }
        catch (IOException e) {
            throw new PayErrorException((PayError)new WxPayError("FAIL", e.getMessage()), (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    @Deprecated
    public static InputStream uncompress(InputStream input) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Deprecated
    private void writeToLocal(String destination, InputStream inputStream) throws IOException {
        if (inputStream.available() != 0) {
            boolean result;
            this.LOG.debug("\u7ed3\u679c\u5927\u5c0f:{}", (Object)inputStream.available());
            File file = new File(destination);
            if (!file.getParentFile().exists() && !(result = file.getParentFile().mkdirs())) {
                this.LOG.warn("\u521b\u5efa\u5931\u8d25");
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                int size = 0;
                int len = 0;
                byte[] buf = new byte[1024];
                while ((size = inputStream.read(buf)) != -1) {
                    len += size;
                    ((OutputStream)out).write(buf, 0, size);
                }
                this.LOG.debug("\u6700\u7ec8\u5199\u5165\u5b57\u8282\u6570\u5927\u5c0f:{}", (Object)len);
            }
        }
    }

    @Deprecated
    private Map<String, Object> getDownloadBillParam(Date billDate, String billType, boolean tarType) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("bill_type", billType);
        parameters.put("bill_date", DateUtils.formatDate((Date)billDate, (String)"yyyyMMdd"));
        if (tarType) {
            parameters.put("tar_type", "GZIP");
        }
        return parameters;
    }

    private Map<String, Object> secondaryInterface(Object transactionIdOrBillDate, String outTradeNoBillType, TransactionType transactionType) {
        if (transactionType == WxTransactionType.REFUND) {
            throw new PayErrorException((PayError)new PayException("failure", "\u901a\u7528\u63a5\u53e3\u4e0d\u652f\u6301:" + transactionType));
        }
        if (transactionType == WxTransactionType.DOWNLOADBILL) {
            if (transactionIdOrBillDate instanceof Date) {
                return this.downloadBill((Date)transactionIdOrBillDate, WxPayBillType.forType(outTradeNoBillType));
            }
            throw new PayErrorException((PayError)new PayException("failure", "\u975e\u6cd5\u7c7b\u578b\u5f02\u5e38:" + transactionIdOrBillDate.getClass()));
        }
        if (null != transactionIdOrBillDate && !(transactionIdOrBillDate instanceof String)) {
            throw new PayErrorException((PayError)new PayException("failure", "\u975e\u6cd5\u7c7b\u578b\u5f02\u5e38:" + transactionIdOrBillDate.getClass()));
        }
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"out_trade_no", (String)outTradeNoBillType);
        OrderParaStructure.loadParameters(parameters, (String)"transaction_id", (String)((String)transactionIdOrBillDate));
        this.setSign(parameters);
        return (Map)this.requestTemplate.postForObject(this.getReqUrl(transactionType), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    public Map<String, Object> transfer(TransferOrder order) {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("partner_trade_no", order.getOutNo());
        parameters.put("amount", Util.conversionCentAmount((BigDecimal)order.getAmount()));
        if (!StringUtils.isEmpty((CharSequence)order.getRemark())) {
            parameters.put("desc", order.getRemark());
        }
        parameters.put("nonce_str", SignTextUtils.randomStr());
        if (null != order.getTransferType() && WxTransferType.TRANSFERS == order.getTransferType()) {
            this.transfers(parameters, order);
            parameters.put("mchid", ((WxPayConfigStorage)this.payConfigStorage).getPid());
        } else {
            parameters.put("mch_id", ((WxPayConfigStorage)this.payConfigStorage).getPid());
            order.setTransferType((TransferType)WxTransferType.PAY_BANK);
            this.payBank(parameters, order);
        }
        parameters.put("sign", this.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"sign"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset()));
        return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl((TransactionType)order.getTransferType()), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    private Map<String, Object> transfers(Map<String, Object> parameters, TransferOrder order) {
        parameters.put("mch_appid", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
        parameters.put("openid", order.getPayeeAccount());
        parameters.put("spbill_create_ip", StringUtils.isEmpty((CharSequence)order.getIp()) ? "192.168.1.150" : order.getIp());
        parameters.put("check_name", "NO_CHECK");
        if (!StringUtils.isEmpty((CharSequence)order.getPayeeName())) {
            parameters.put("check_name", "FORCE_CHECK");
            parameters.put("re_user_name", order.getPayeeName());
        }
        return parameters;
    }

    private Map<String, Object> payBank(Map<String, Object> parameters, TransferOrder order) {
        parameters.put("enc_bank_no", this.keyPublic(order.getPayeeAccount()));
        parameters.put("enc_true_name", this.keyPublic(order.getPayeeName()));
        parameters.put("bank_code", order.getBank().getCode());
        return parameters;
    }

    @Deprecated
    public Map<String, Object> transferQuery(String outNo, String wxTransferType) {
        if (StringUtils.isEmpty((CharSequence)wxTransferType)) {
            throw new PayErrorException((PayError)new WxPayError("failure", "\u5fae\u4fe1\u8f6c\u8d26\u7c7b\u578b\u5fc5\u586b\uff0c\u8be6\u60c5com.egzosn.pay.wx.bean.WxTransferType"));
        }
        AssistOrder assistOrder = new AssistOrder(outNo);
        assistOrder.setTransactionType((TransactionType)WxTransferType.valueOf(wxTransferType));
        return this.transferQuery(assistOrder);
    }

    public Map<String, Object> transferQuery(AssistOrder assistOrder) {
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put("mch_id", ((WxPayConfigStorage)this.payConfigStorage).getPid());
        parameters.put("partner_trade_no", assistOrder.getOutTradeNo());
        parameters.put("nonce_str", SignTextUtils.randomStr());
        if (null == assistOrder.getTransactionType()) {
            throw new PayErrorException((PayError)new WxPayError("failure", "\u5fae\u4fe1\u8f6c\u8d26\u7c7b\u578b\u5fc5\u586b\uff0c\u8be6\u60c5com.egzosn.pay.wx.bean.WxTransferType"));
        }
        if (WxTransferType.TRANSFERS == assistOrder.getTransactionType() || WxTransferType.GETTRANSFERINFO == assistOrder.getTransactionType()) {
            parameters.put("appid", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
            parameters.put("sign", this.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"sign"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset()));
            return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl((TransactionType)WxTransferType.GETTRANSFERINFO), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
        }
        parameters.put("sign", this.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"sign"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset()));
        return (Map)this.getHttpRequestTemplate().postForObject(this.getReqUrl((TransactionType)WxTransferType.QUERY_BANK), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    private String keyPublic(String content) {
        try {
            return RSA2.encrypt((String)content, (String)((WxPayConfigStorage)this.payConfigStorage).getKeyPublic(), (String)"RSA/ECB/OAEPWITHSHA-1ANDMGF1PADDING", (String)((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
        }
        catch (IOException | GeneralSecurityException e) {
            throw new PayErrorException((PayError)new WxPayError("failure", e.getLocalizedMessage()));
        }
    }

    public PayMessage createMessage(Map<String, Object> message) {
        return WxPayMessage.create(message);
    }

    @Override
    public Map<String, Object> sendredpack(RedpackOrder redpackOrder) {
        return this.sendRedPack(redpackOrder);
    }

    @Override
    public Map<String, Object> sendRedPack(RedpackOrder redpackOrder) {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        this.redPackParam(redpackOrder, parameters);
        TransferType transferType = redpackOrder.getTransferType();
        if (WxSendredpackType.SENDGROUPREDPACK == transferType) {
            parameters.put("total_num", Math.max(redpackOrder.getTotalNum(), 3));
            parameters.put("amt_type", "ALL_RAND");
        } else if (WxSendredpackType.SENDMINIPROGRAMHB == transferType) {
            parameters.put("notify_way", "MINI_PROGRAM_JSAPI");
        }
        parameters.put("sign", this.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"sign"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset()));
        JSONObject resp = (JSONObject)this.requestTemplate.postForObject(this.getReqUrl((TransactionType)redpackOrder.getTransferType()), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
        if (WxSendredpackType.SENDMINIPROGRAMHB != transferType || "FAIL".equals(resp.getString("result_code"))) {
            return resp;
        }
        TreeMap<String, Object> params = new TreeMap<String, Object>();
        params.put("appId", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
        params.put("timeStamp", System.currentTimeMillis() / 1000L + "");
        params.put("nonceStr", parameters.get("nonce_str"));
        params.put("package", UriVariables.urlEncoder((String)resp.getString("package")));
        String paySign = this.createSign(SignTextUtils.parameterText(params), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset());
        params.put("signType", ((WxPayConfigStorage)this.payConfigStorage).getSignType());
        params.put("paySign", paySign);
        return params;
    }

    @Override
    public Map<String, Object> gethbinfo(String mchBillno) {
        return this.getHbInfo(mchBillno);
    }

    @Override
    public Map<String, Object> getHbInfo(String mchBillNo) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("mch_billno", mchBillNo);
        parameters.put("bill_type", "MCHT");
        parameters.put("sign", this.createSign(SignTextUtils.parameterText(parameters, (String)"&", (String[])new String[]{"sign"}), ((WxPayConfigStorage)this.payConfigStorage).getInputCharset()));
        return (Map)this.requestTemplate.postForObject(this.getReqUrl((TransactionType)WxSendredpackType.GETHBINFO), (Object)XML.getMap2Xml(parameters), JSONObject.class, new Object[0]);
    }

    private void redPackParam(RedpackOrder redpackOrder, Map<String, Object> parameters) {
        parameters.put("nonce_str", SignTextUtils.randomStr());
        parameters.put("mch_id", ((WxPayConfigStorage)this.payConfigStorage).getPid());
        if (StringUtils.isEmpty((CharSequence)redpackOrder.getWxAppId())) {
            throw new PayErrorException((PayError)new WxPayError("FAIL", "RedpackOrder#getWxAppId()\u516c\u4f17\u8d26\u53f7appid \u5fc5\u586b"));
        }
        parameters.put("wxappid", redpackOrder.getWxAppId());
        parameters.put("send_name", redpackOrder.getSendName());
        parameters.put("re_openid", redpackOrder.getReOpenid());
        parameters.put("mch_billno", redpackOrder.getMchBillNo());
        parameters.put("total_amount", Util.conversionCentAmount((BigDecimal)redpackOrder.getTotalAmount()));
        parameters.put("total_num", 1);
        parameters.put("wishing", redpackOrder.getWishing());
        parameters.put("client_ip", StringUtils.isNotEmpty((CharSequence)redpackOrder.getIp()) ? redpackOrder.getIp() : "192.168.0.1");
        parameters.put("act_name", redpackOrder.getActName());
        parameters.put("remark", redpackOrder.getRemark());
        if (StringUtils.isNotEmpty((CharSequence)redpackOrder.getSceneId())) {
            parameters.put("scene_id", redpackOrder.getSceneId());
        }
    }
}

