/*
 * Decompiled with CFR 0.152.
 */
package com.egzosn.pay.wx.v3.api;

import com.alibaba.fastjson.JSON;
import com.egzosn.pay.common.bean.AssistOrder;
import com.egzosn.pay.common.bean.Order;
import com.egzosn.pay.common.bean.OrderParaStructure;
import com.egzosn.pay.common.http.HttpConfigStorage;
import com.egzosn.pay.common.http.UriVariables;
import com.egzosn.pay.common.util.DateUtils;
import com.egzosn.pay.common.util.str.StringUtils;
import com.egzosn.pay.wx.v3.api.WxPayConfigStorage;
import com.egzosn.pay.wx.v3.api.WxPayService;
import com.egzosn.pay.wx.v3.bean.WxPayScoreTransactionType;
import com.egzosn.pay.wx.v3.bean.payscore.CompleteOrder;
import com.egzosn.pay.wx.v3.bean.payscore.CreateOrder;
import com.egzosn.pay.wx.v3.bean.payscore.ModifyOrder;
import com.egzosn.pay.wx.v3.bean.payscore.RiskFund;
import com.egzosn.pay.wx.v3.bean.payscore.TimeRange;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class WxPayScoreService
extends WxPayService {
    public WxPayScoreService(WxPayConfigStorage payConfigStorage) {
        super(payConfigStorage);
    }

    public WxPayScoreService(WxPayConfigStorage payConfigStorage, HttpConfigStorage configStorage) {
        super(payConfigStorage, configStorage);
    }

    private Map<String, Object> getPublicParameters() {
        TreeMap<String, Object> parameters = new TreeMap<String, Object>();
        parameters.put("appid", ((WxPayConfigStorage)this.payConfigStorage).getAppId());
        parameters.put("mch_id", ((WxPayConfigStorage)this.payConfigStorage).getPid());
        parameters.put("service_id", ((WxPayConfigStorage)this.payConfigStorage).getServiceId());
        return parameters;
    }

    public void initNotifyUrl(Map<String, Object> parameters, Order order) {
        OrderParaStructure.loadParameters(parameters, (String)"notify_url", (String)((WxPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        OrderParaStructure.loadParameters(parameters, (String)"notify_url", (Order)order);
    }

    public Map<String, Object> permissions(String authorizationCode) {
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"authorization_code", (String)authorizationCode);
        OrderParaStructure.loadParameters(parameters, (String)"notify_url", (String)((WxPayConfigStorage)this.payConfigStorage).getNotifyUrl());
        return this.getAssistService().doExecute(parameters, WxPayScoreTransactionType.PERMISSIONS);
    }

    public Map<String, Object> queryPermissionsByAuthorizationCode(String authorizationCode) {
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"authorization_code", (String)authorizationCode);
        String params = JSON.toJSONString(parameters);
        return this.getAssistService().doExecute(params, WxPayScoreTransactionType.QUERY_PERMISSIONS_AUTHORIZATION_CODE, authorizationCode);
    }

    public Map<String, Object> terminatePermissionsByAuthorizationCode(String authorizationCode, String reason) {
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"authorization_code", (String)authorizationCode);
        OrderParaStructure.loadParameters(parameters, (String)"reason", (String)reason);
        String params = JSON.toJSONString(parameters);
        return this.getAssistService().doExecute(params, WxPayScoreTransactionType.UNBIND_PERMISSIONS_AUTHORIZATION_CODE, authorizationCode);
    }

    public Map<String, Object> queryPermissionsByOpenId(String openId) {
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"open_id", (String)openId);
        String params = JSON.toJSONString(parameters);
        return this.getAssistService().doExecute(params, WxPayScoreTransactionType.QUERY_PERMISSIONS_OPENID, openId);
    }

    public Map<String, Object> terminatePermissionsByOpenId(String openId, String reason) {
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"open_id", (String)openId);
        OrderParaStructure.loadParameters(parameters, (String)"reason", (String)reason);
        String params = JSON.toJSONString(parameters);
        return this.getAssistService().doExecute(params, WxPayScoreTransactionType.UNBIND_PERMISSIONS_OPENID, openId);
    }

    public Map<String, Object> create(CreateOrder createOrder) {
        Map<String, Object> parameters = this.getPublicParameters();
        OrderParaStructure.loadParameters(parameters, (String)"out_order_no", (String)createOrder.getOutTradeNo());
        OrderParaStructure.loadParameters(parameters, (String)"service_introduction", (String)createOrder.getServiceIntroduction());
        RiskFund riskFund = new RiskFund();
        riskFund.setName(createOrder.getRiskFundName());
        riskFund.setAmount(createOrder.getRiskFundAmount());
        parameters.put("risk_fund", riskFund);
        String attach = createOrder.getAttach();
        if (StringUtils.isNotBlank((CharSequence)attach)) {
            String attachEncode = URLEncoder.encode(attach);
            OrderParaStructure.loadParameters(parameters, (String)"attach", (String)(attachEncode.length() <= 256 ? attachEncode : attachEncode.substring(0, 255)));
        }
        TimeRange timeRange = new TimeRange();
        timeRange.setStartTime(createOrder.getStartTime());
        timeRange.setEndTime(createOrder.getEndTime());
        parameters.put("time_range", timeRange);
        this.initNotifyUrl(parameters, (Order)createOrder);
        OrderParaStructure.loadParameters(parameters, (String)"openid", (String)createOrder.getOpenId());
        if (null != createOrder.getNeedUserConfirm()) {
            OrderParaStructure.loadParameters(parameters, (String)"need_user_confirm", (String)createOrder.getNeedUserConfirm().toString());
        }
        return this.getAssistService().doExecute(parameters, WxPayScoreTransactionType.CREATE);
    }

    public Map<String, Object> cancel(String orderNo, String reason) {
        Map<String, Object> parameters = this.getPublicParameters();
        reason = reason.length() <= 50 ? reason : reason.substring(0, 50);
        parameters.put("reason", reason);
        String params = JSON.toJSONString(parameters);
        return this.getAssistService().doExecute(params, WxPayScoreTransactionType.CANCEL, orderNo);
    }

    public Map<String, Object> modify(ModifyOrder modifyOrder) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("post_payments", modifyOrder.getPostPayments());
        parameters.put("total_amount", modifyOrder.getTotalAmount());
        OrderParaStructure.loadParameters(parameters, (String)"reason", (String)modifyOrder.getReason());
        String params = JSON.toJSONString(parameters);
        return this.getAssistService().doExecute(params, WxPayScoreTransactionType.MODIFY, modifyOrder.getOutTradeNo());
    }

    public Map<String, Object> complete(CompleteOrder completeOrder) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("post_payments", completeOrder.getPostPayments());
        parameters.put("total_amount", completeOrder.getTotalAmount());
        String params = JSON.toJSONString(parameters);
        return this.getAssistService().doExecute(params, WxPayScoreTransactionType.COMPLETE, completeOrder.getOutTradeNo());
    }

    public Map<String, Object> sync(String outOrderNo, Date payTime) {
        Map<String, Object> parameters = this.getPublicParameters();
        parameters.put("type", "Order_Paid");
        HashMap<String, String> detail = new HashMap<String, String>();
        detail.put("paid_time", DateUtils.formatDate((Date)payTime, (String)"yyyyMMddHHmmss"));
        parameters.put("detail", detail);
        String params = JSON.toJSONString(parameters);
        return this.getAssistService().doExecute(params, WxPayScoreTransactionType.SYNC, outOrderNo);
    }

    @Override
    public Map<String, Object> query(AssistOrder assistOrder) {
        String outTradeNo = assistOrder.getOutTradeNo();
        Map<String, Object> publicParameters = this.getPublicParameters();
        if (StringUtils.isNotBlank((CharSequence)outTradeNo)) {
            OrderParaStructure.loadParameters(publicParameters, (String)"out_order_no", (String)outTradeNo);
        }
        String parameters = UriVariables.getMapToParameters(publicParameters);
        return this.getAssistService().doExecute(parameters, WxPayScoreTransactionType.QUERY, new Object[0]);
    }
}

