-- ----------------------------
-- 弹窗广告轮播图
-- ----------------------------
-- DROP TABLE "T_BASE_AD_BANNER";
CREATE TABLE "T_BASE_AD_BANNER" (
  "ID" VARCHAR2(32 BYTE) NOT NULL ,
  "TITLE" VARCHAR2(255 BYTE) ,
  "IMG_URL" VARCHAR2(255 BYTE) ,
  "IMG_LINK" VARCHAR2(255 BYTE) ,
  "IMG_ALT" VARCHAR2(255 BYTE) ,
  "SORT_NO" NUMBER(7) ,
  "IS_ENABLE" NUMBER(2) ,
  "CREATE_TIME" DATE ,
  "CREATE_USER_ID" VARCHAR2(32 BYTE) ,
  "CREATE_USER_NAME" VARCHAR2(255 BYTE)
);

COMMENT ON COLUMN "T_BASE_AD_BANNER"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."TITLE" IS '标题';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."IMG_URL" IS '显示图片的URL';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."IMG_LINK" IS '图片的外链地址';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."IMG_ALT" IS '图片上的提示';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."SORT_NO" IS '图片排序,倒序';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."IS_ENABLE" IS '是否启用,1启用,0禁用';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."CREATE_TIME" IS '创建时间';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."CREATE_USER_ID" IS '创建人id';
COMMENT ON COLUMN "T_BASE_AD_BANNER"."CREATE_USER_NAME" IS '创建人名称';
COMMENT ON TABLE "T_BASE_AD_BANNER" IS '弹窗广告轮播图';

ALTER TABLE "T_BASE_AD_BANNER" ADD PRIMARY KEY ("ID");

-- ----------------------------
-- 弹窗轮播图点击率
-- ----------------------------
-- DROP TABLE "T_BASE_AD_BANNER_CTR";
CREATE TABLE "T_BASE_AD_BANNER_CTR" (
       "ID" VARCHAR2(32 BYTE) NOT NULL ,
       "AD_BANNER_ID" VARCHAR2(32 BYTE) NOT NULL ,
       "AD_BANNER_TITLE" VARCHAR2(255 BYTE) ,
       "USER_ID" VARCHAR2(32 BYTE) ,
       "USER_NAME" VARCHAR2(255 BYTE) ,
       "COMPANY_ID" VARCHAR2(32 BYTE) ,
       "COMPANY_NAME" VARCHAR2(255 BYTE) ,
       "CLICK_RATE" NUMBER(10) ,
       "LAST_CLICK_TIME" DATE ,
       "COMPANY_SRM_CODE" VARCHAR2(255 BYTE) ,
       "USER_PHONE" VARCHAR2(255 BYTE)
);

COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."ID" IS '主键';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."AD_BANNER_ID" IS '广告图id';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."AD_BANNER_TITLE" IS '广告图标题';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."USER_ID" IS '用户id';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."USER_NAME" IS '用户名称';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."COMPANY_ID" IS '公司id';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."COMPANY_NAME" IS '公司名称';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."CLICK_RATE" IS '点击次数';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."LAST_CLICK_TIME" IS '最后一次点击的时间';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."COMPANY_SRM_CODE" IS '供应商srm编码';
COMMENT ON COLUMN "T_BASE_AD_BANNER_CTR"."USER_PHONE" IS '用户电话';
COMMENT ON TABLE "T_BASE_AD_BANNER_CTR" IS '弹窗轮播图点击率';

ALTER TABLE "T_BASE_AD_BANNER_CTR" ADD  PRIMARY KEY ("ID");









