/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.OperatorMapper;
import com.els.base.auth.entity.Menu;
import com.els.base.auth.entity.Operator;
import com.els.base.auth.entity.OperatorExample;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.entity.RoleRightExample;
import com.els.base.auth.service.MenuService;
import com.els.base.auth.service.OperatorService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OperatorServiceImpl
implements OperatorService {
    @Resource
    private OperatorMapper operatorMapper;
    @Resource
    private RoleRightService roleRightService;
    @Resource
    private MenuService menuService;

    @CacheEvict(value={"operatorCache"}, allEntries=true)
    public void addObj(Operator operator) {
        Assert.isNotBlank((String)operator.getMenuId(), (String)"\u83dc\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)operator.getOperCode(), (String)"operatecode\u4e0d\u80fd\u4e3a\u7a7a");
        OperatorExample operatorExample = new OperatorExample();
        operatorExample.createCriteria().andOperCodeEqualTo(operator.getOperCode());
        if (this.operatorMapper.countByExample(operatorExample) > 0) {
            throw new CommonException("\u64cd\u4f5ccode\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
        }
        if (StringUtils.isBlank((String)operator.getMenuCode())) {
            Menu menu = (Menu)this.menuService.queryObjById(operator.getMenuId());
            operator.setMenuCode(menu.getMenuCode());
            operator.setMenuName(menu.getMenuName());
        }
        operator.setCreateTime(new Date());
        this.operatorMapper.insertSelective(operator);
    }

    @CacheEvict(value={"operatorCache"}, allEntries=true)
    public void deleteObjById(String id) {
        this.operatorMapper.deleteByPrimaryKey(id);
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andKeyIdEqualTo(id).andTypeEqualTo("operator");
        this.roleRightService.deleteByExample(roleRightExample);
    }

    @CacheEvict(value={"operatorCache"}, allEntries=true)
    public void modifyObj(Operator operator) {
        if (operator == null || StringUtils.isBlank((String)operator.getId())) {
            throw new IllegalArgumentException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        OperatorExample operatorExample = new OperatorExample();
        operatorExample.createCriteria().andOperCodeEqualTo(operator.getOperCode()).andIdNotEqualTo(operator.getId());
        if (this.operatorMapper.countByExample(operatorExample) > 0) {
            throw new CommonException("\u64cd\u4f5ccode\u503c\u5df2\u5b58\u5728", "base_is_exists", new Object[]{"code\u503c"});
        }
        operator.setUpdateTime(new Date());
        this.operatorMapper.updateByPrimaryKeySelective(operator);
    }

    @Override
    public void editOperatorsByMenuId(Operator operator) {
        if (StringUtils.isNotBlank((String)operator.getId())) {
            this.modifyObj(operator);
        } else {
            this.addObj(operator);
        }
    }

    @Cacheable(value={"operatorCache"}, keyGenerator="redisKeyGenerator")
    public Operator queryObjById(String id) {
        return this.operatorMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"operatorCache"}, keyGenerator="redisKeyGenerator")
    public List<Operator> queryAllOperatorsByMenuId(String menuId) {
        OperatorExample example = new OperatorExample();
        example.createCriteria().andMenuIdEqualTo(menuId);
        return this.operatorMapper.selectByExample(example);
    }

    @Cacheable(value={"operatorCache"}, keyGenerator="redisKeyGenerator")
    public List<Operator> queryAllObjByExample(OperatorExample example) {
        return this.operatorMapper.selectByExample(example);
    }

    @Cacheable(value={"operatorCache"}, keyGenerator="redisKeyGenerator")
    public PageView<Operator> queryObjByPage(OperatorExample example) {
        PageView<Operator> pageView = example.getPageView();
        pageView.setQueryResult(this.operatorMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"operatorCache"}, allEntries=true)
    public void deleteByExample(OperatorExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.operatorMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"operatorCache"}, allEntries=true)
    public void modifyByExample(Operator operator, OperatorExample example) {
        this.operatorMapper.updateByExampleSelective(operator, example);
    }

    private List<Operator> queryByRoleIds(List<String> currentRoleIds, List<String> targetRoleIds) {
        List<Operator> operatorList;
        if (CollectionUtils.isEmpty(currentRoleIds)) {
            return null;
        }
        OperatorExample operatorExample = new OperatorExample();
        OperatorExample.Criteria criteria = operatorExample.createCriteria();
        if (!currentRoleIds.contains(AuthConstant.SYS_MANAGER_ROLE.getId())) {
            List<String> currentOperatorIds = this.queryOperatorIdsByRoleIds(currentRoleIds);
            if (CollectionUtils.isEmpty(currentOperatorIds)) {
                return null;
            }
            criteria.andIdIn((List)currentOperatorIds);
        }
        if (CollectionUtils.isEmpty(operatorList = this.operatorMapper.selectByExample(operatorExample))) {
            return operatorList;
        }
        if (targetRoleIds.contains(AuthConstant.SYS_MANAGER_ROLE.getId()) || currentRoleIds.equals(targetRoleIds)) {
            return operatorList;
        }
        List<String> targetOperatorIds = this.queryOperatorIdsByRoleIds(targetRoleIds);
        for (int i = 0; i < operatorList.size(); ++i) {
            Operator operator = operatorList.get(i);
            operator.setAuthorized(targetOperatorIds.contains(operator.getId()));
        }
        return operatorList;
    }

    private List<String> queryOperatorIdsByRoleIds(List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return new ArrayList<String>();
        }
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andRoleIdIn((List)roleIds).andTypeEqualTo("operator");
        List roleRightList = this.roleRightService.queryAllObjByExample((IExample)roleRightExample);
        if (CollectionUtils.isEmpty((Collection)roleRightList)) {
            return new ArrayList<String>();
        }
        ArrayList<String> operatorIds = new ArrayList<String>();
        for (RoleRight roleRight : roleRightList) {
            operatorIds.add(roleRight.getKeyId());
        }
        return operatorIds;
    }

    @Override
    public void setAuthDataInMenu(List<Menu> allMenu, List<String> currentRoleIds, List<String> targetRoleIds) {
        if (CollectionUtils.isEmpty(allMenu) || CollectionUtils.isEmpty(currentRoleIds)) {
            return;
        }
        List<Operator> allOperator = this.queryByRoleIds(currentRoleIds, targetRoleIds);
        if (CollectionUtils.isEmpty(allOperator)) {
            return;
        }
        this.setOperatorListInMenu(allMenu, allOperator);
    }

    private void setOperatorListInMenu(List<Menu> allMenu, List<Operator> allOperator) {
        if (CollectionUtils.isEmpty(allMenu) || CollectionUtils.isEmpty(allOperator)) {
            return;
        }
        for (Menu menu : allMenu) {
            List<Operator> operatorsInMenu = menu.getOperatorList();
            if (operatorsInMenu == null) {
                operatorsInMenu = new ArrayList<Operator>();
                menu.setOperatorList(operatorsInMenu);
            }
            for (Operator operator : allOperator) {
                if (!menu.getId().equals(operator.getMenuId())) continue;
                operatorsInMenu.add(operator);
            }
            this.setOperatorListInMenu(menu.getChildren(), allOperator);
        }
    }

    @CacheEvict(value={"operatorCache"}, allEntries=true)
    @Transactional
    public void addAll(List<Operator> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.operatorMapper.insertSelective((Operator)record));
    }
}

