/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.config;

import com.els.base.auth.utils.AnonymousMatcherUtils;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.auth.web.security.impl.CustomAccessDecisionManagerImpl;
import com.els.base.auth.web.security.impl.CustomAuthenticationEntryPoint;
import com.els.base.auth.web.security.impl.CustomCaptchaAuthenticationFilter;
import com.els.base.auth.web.security.impl.CustomDaoAuthenticationProvider;
import com.els.base.auth.web.security.impl.CustomFilterInvocationSecurityMetadataSource;
import com.els.base.auth.web.security.impl.CustomInvalidSessionStrategy;
import com.els.base.auth.web.security.impl.CustomLogoutSuccessHandler;
import com.els.base.auth.web.security.impl.InVaildSessionHandlerForAnonymouoseFilter;
import com.els.base.auth.web.security.impl.LocaleChangeAndSaveFilter;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.ProviderManager;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionManagementFilter;

@EnableWebSecurity
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Resource(name="customPasswordEncoder")
    PasswordEncoder passwordEncoder;
    @Resource(name="customUserDetailsService")
    UserDetailsService userDetailsService;
    @Resource(name="customAuthenticationFailureHandler")
    AuthenticationFailureHandler failureHandler;
    @Resource(name="customAuthenticationSuccessHandler")
    protected AuthenticationSuccessHandler successHandler;
    @Resource(name="customAccessDecisionManager")
    protected CustomAccessDecisionManagerImpl customAccessDecisionManager;
    @Resource(name="customFilterInvocationSecurityMetadataSource")
    protected CustomFilterInvocationSecurityMetadataSource customFilterInvocationSecurityMetadataSource;
    @Resource(name="accessDeniedHandler")
    protected AccessDeniedHandler accessDeniedHandler;

    public void configure(WebSecurity web) throws Exception {
        ((WebSecurity.IgnoredRequestConfigurer)((WebSecurity.IgnoredRequestConfigurer)web.ignoring().antMatchers(new String[]{"/resources/**", "/swagger/**", "/mobileview/**", "/login.html*"})).antMatchers(new String[]{"/auditevents", "/beans", "/caches", "/conditions", "/configprops", "/env", "/flyway", "/health", "/heapdump", "/httptrace", "/info", "/integrationgraph", "/jolokia", "/logfile", "/loggers", "/liquibase", "/metrics", "/mappings", "/prometheus", "/scheduledtasks", "/sessions", "/shutdown", "/threaddump"})).antMatchers(new String[]{"/captcha/**", "/v2/api-docs", "/sap/**", "/api/applications/**"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        http.addFilterBefore(this.getLocaleChangeAndSaveFilter(), ConcurrentSessionFilter.class).addFilterBefore(this.getCaptchaAuthenticaionFilter(), UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.getCustomSessionManagementFilter(), SessionManagementFilter.class).addFilterBefore(this.getCustomFilterSecurityInterceptor(), FilterSecurityInterceptor.class);
        http.sessionManagement().sessionFixation().migrateSession();
        http.sessionManagement().invalidSessionStrategy(this.getInvalidSessionStrategy());
        http.sessionManagement().sessionAuthenticationErrorUrl("/login.html");
        http.sessionManagement().maximumSessions(1).maxSessionsPreventsLogin(false).expiredUrl("/login.html");
        http.exceptionHandling().accessDeniedHandler(this.accessDeniedHandler).authenticationEntryPoint(this.getAuthenticationEntryPoint());
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)http.formLogin().failureHandler(this.failureHandler)).and()).anonymous().key("anonymousDoesNotMatter").authorities(new String[]{AuthConstant.ANONYMOUS_ROLE.getId()}).and()).logout().invalidateHttpSession(true).logoutUrl("/logout").logoutSuccessHandler(this.getCustomLogoutSuccessHandler()).and()).csrf().disable();
        AnonymousMatcherUtils.configAnonymousMatchers("/*/front/**");
    }

    private Filter getCustomFilterSecurityInterceptor() {
        FilterSecurityInterceptor filter = new FilterSecurityInterceptor();
        filter.setAuthenticationManager(this.getAuthenticationManager());
        filter.setAccessDecisionManager((AccessDecisionManager)this.customAccessDecisionManager);
        filter.setSecurityMetadataSource((FilterInvocationSecurityMetadataSource)this.customFilterInvocationSecurityMetadataSource);
        return filter;
    }

    @Bean(value={"sessionManagementFilter"})
    protected InVaildSessionHandlerForAnonymouoseFilter getCustomSessionManagementFilter() {
        InVaildSessionHandlerForAnonymouoseFilter filter = new InVaildSessionHandlerForAnonymouoseFilter();
        return filter;
    }

    @Bean(value={"customLogoutSuccessHandler"})
    protected LogoutSuccessHandler getCustomLogoutSuccessHandler() {
        CustomLogoutSuccessHandler handler = new CustomLogoutSuccessHandler();
        handler.setDefaultTargetUrl("/logout.html");
        return handler;
    }

    @Bean(value={"captchaAuthenticaionFilter"})
    protected Filter getCaptchaAuthenticaionFilter() {
        CustomCaptchaAuthenticationFilter filter = new CustomCaptchaAuthenticationFilter();
        filter.setAuthenticationManager(this.getAuthenticationManager());
        filter.setAuthenticationFailureHandler(this.failureHandler);
        filter.setAuthenticationSuccessHandler(this.successHandler);
        filter.setFilterProcessesUrl("/loginForSpringSecurity");
        return filter;
    }

    @Bean(value={"authenticationManager"})
    protected AuthenticationManager getAuthenticationManager() {
        List<AuthenticationProvider> providers = Arrays.asList(this.getAuthenticationProvider());
        ProviderManager authenticationManager = new ProviderManager(providers);
        return authenticationManager;
    }

    @Bean(value={"daoAuthenticationProvider"})
    protected AuthenticationProvider getAuthenticationProvider() {
        CustomDaoAuthenticationProvider authenticationProvider = new CustomDaoAuthenticationProvider();
        authenticationProvider.setPasswordEncoder(this.passwordEncoder);
        authenticationProvider.setUserDetailsService(this.userDetailsService);
        authenticationProvider.setHideUserNotFoundExceptions(true);
        return authenticationProvider;
    }

    @Bean(value={"authenticationEntryPoint"})
    protected AuthenticationEntryPoint getAuthenticationEntryPoint() {
        CustomAuthenticationEntryPoint entryPoint = new CustomAuthenticationEntryPoint("/login.html");
        return entryPoint;
    }

    @Bean(value={"localeChangeAndSaveFilter"})
    protected Filter getLocaleChangeAndSaveFilter() {
        return new LocaleChangeAndSaveFilter();
    }

    @Bean(value={"customInvalidSessionStrategy"})
    protected InvalidSessionStrategy getInvalidSessionStrategy() {
        CustomInvalidSessionStrategy strategy = new CustomInvalidSessionStrategy("/login.html");
        return strategy;
    }
}

