/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.auth.service.impl;

import com.els.base.auth.dao.ButtonMapper;
import com.els.base.auth.entity.Button;
import com.els.base.auth.entity.ButtonExample;
import com.els.base.auth.entity.Menu;
import com.els.base.auth.entity.RoleRight;
import com.els.base.auth.entity.RoleRightExample;
import com.els.base.auth.service.ButtonService;
import com.els.base.auth.service.RoleRightService;
import com.els.base.auth.utils.AuthConstant;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultButtonService")
public class ButtonServiceImpl
implements ButtonService {
    @Resource
    protected ButtonMapper buttonMapper;
    @Resource
    private RoleRightService roleRightService;

    @CacheEvict(value={"button", "menu"}, allEntries=true)
    public void addObj(Button button) {
        Assert.isNotBlank((String)button.getBtnCode(), (String)"code\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)button.getMenuId(), (String)"menuId\u4e0d\u80fd\u4e3a\u7a7a");
        button.setCreateTime(new Date());
        button.setUpdateTime(new Date());
        this.buttonMapper.insertSelective(button);
    }

    @Transactional
    @CacheEvict(value={"button", "menu"}, allEntries=true)
    public void deleteObjById(String id) {
        this.buttonMapper.deleteByPrimaryKey(id);
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andKeyIdEqualTo(id).andTypeEqualTo("buttons");
        this.roleRightService.deleteByExample(roleRightExample);
    }

    @CacheEvict(value={"button", "menu"}, allEntries=true)
    public void modifyObj(Button t) {
        if (StringUtils.isBlank((String)t.getId())) {
            throw new NullPointerException("id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u66f4\u65b0");
        }
        t.setUpdateTime(new Date());
        this.buttonMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"button"}, keyGenerator="redisKeyGenerator")
    public Button queryObjById(String id) {
        return this.buttonMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"button"}, keyGenerator="redisKeyGenerator")
    public List<Button> queryAllObjByExample(ButtonExample example) {
        return this.buttonMapper.selectByExample(example);
    }

    @Cacheable(value={"button"}, keyGenerator="redisKeyGenerator")
    public PageView<Button> queryObjByPage(ButtonExample example) {
        PageView<Button> pageView = example.getPageView();
        pageView.setQueryResult(this.buttonMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public void setAuthDataInMenu(List<Menu> allMenu, List<String> currentRoleIds, List<String> targetRoleIds) {
        if (CollectionUtils.isEmpty(allMenu) || CollectionUtils.isEmpty(currentRoleIds)) {
            return;
        }
        List<Button> allButtons = this.queryByRoleIds(currentRoleIds, targetRoleIds);
        if (CollectionUtils.isEmpty(allButtons)) {
            return;
        }
        this.setButtonListInMenu(allMenu, allButtons);
    }

    private void setButtonListInMenu(List<Menu> allMenu, List<Button> allButtonList) {
        if (CollectionUtils.isEmpty(allMenu) || CollectionUtils.isEmpty(allButtonList)) {
            return;
        }
        for (Menu menu : allMenu) {
            List<Button> buttonsInMenu = menu.getButtonList();
            if (buttonsInMenu == null) {
                buttonsInMenu = new ArrayList<Button>();
                menu.setButtonList(buttonsInMenu);
            }
            for (Button button : allButtonList) {
                if (!menu.getId().equals(button.getMenuId())) continue;
                buttonsInMenu.add(button);
            }
            this.setButtonListInMenu(menu.getChildren(), allButtonList);
        }
    }

    private List<Button> queryByRoleIds(List<String> currentRoleIds, List<String> targetRoleIds) {
        List<Button> buttonList;
        if (CollectionUtils.isEmpty(currentRoleIds)) {
            return null;
        }
        ButtonExample operatorExample = new ButtonExample();
        ButtonExample.Criteria criteria = operatorExample.createCriteria();
        if (!currentRoleIds.contains(AuthConstant.SYS_MANAGER_ROLE.getId())) {
            List<String> currentButtonIds = this.queryButtonIdsByRoleIds(currentRoleIds);
            if (CollectionUtils.isEmpty(currentButtonIds)) {
                return null;
            }
            criteria.andIdIn((List)currentButtonIds);
        }
        if (CollectionUtils.isEmpty(buttonList = this.buttonMapper.selectByExample(operatorExample))) {
            return buttonList;
        }
        if (targetRoleIds.contains(AuthConstant.SYS_MANAGER_ROLE.getId()) || currentRoleIds.equals(targetRoleIds)) {
            return buttonList;
        }
        List<String> targetButtonIds = this.queryButtonIdsByRoleIds(targetRoleIds);
        for (int i = 0; i < buttonList.size(); ++i) {
            Button button = buttonList.get(i);
            button.setAuthorized(targetButtonIds.contains(button.getId()));
        }
        return buttonList;
    }

    private List<String> queryButtonIdsByRoleIds(List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            return new ArrayList<String>();
        }
        RoleRightExample roleRightExample = new RoleRightExample();
        roleRightExample.createCriteria().andRoleIdIn((List)roleIds).andTypeEqualTo("buttons");
        List roleRightList = this.roleRightService.queryAllObjByExample((IExample)roleRightExample);
        if (CollectionUtils.isEmpty((Collection)roleRightList)) {
            return new ArrayList<String>();
        }
        ArrayList<String> buttonIds = new ArrayList<String>();
        for (RoleRight roleRight : roleRightList) {
            buttonIds.add(roleRight.getKeyId());
        }
        return buttonIds;
    }

    @Override
    @CacheEvict(value={"button", "menu"}, allEntries=true)
    public void deleteObjByMenuId(String menuId) {
        ButtonExample buttonExample = new ButtonExample();
        buttonExample.createCriteria().andMenuIdEqualTo(menuId);
        this.buttonMapper.deleteByExample(buttonExample);
    }

    @CacheEvict(value={"button", "menu"}, allEntries=true)
    public void deleteByExample(ButtonExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.buttonMapper.deleteByExample(example);
    }

    @CacheEvict(value={"button", "menu"}, allEntries=true)
    @Transactional
    public void addAll(List<Button> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> this.buttonMapper.insertSelective((Button)record));
    }
}

